// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAllocateStaticIp = "AllocateStaticIp"

// AllocateStaticIpRequest generates a "aws/request.Request" representing the
// client's request for the AllocateStaticIp operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AllocateStaticIp for more information on using the AllocateStaticIp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AllocateStaticIpRequest method.
//    req, resp := client.AllocateStaticIpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AllocateStaticIp
func (c *Lightsail) AllocateStaticIpRequest(input *AllocateStaticIpInput) (req *request.Request, output *AllocateStaticIpOutput) {
	op := &request.Operation{
		Name:       opAllocateStaticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocateStaticIpInput{}
	}

	output = &AllocateStaticIpOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AllocateStaticIp API operation for Amazon Lightsail.
//
// Allocates a static IP address.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation AllocateStaticIp for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AllocateStaticIp
func (c *Lightsail) AllocateStaticIp(input *AllocateStaticIpInput) (*AllocateStaticIpOutput, error) {
	req, out := c.AllocateStaticIpRequest(input)
	return out, req.Send()
}

// AllocateStaticIpWithContext is the same as AllocateStaticIp with the addition of
// the ability to pass a context and additional request options.
//
// See AllocateStaticIp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) AllocateStaticIpWithContext(ctx aws.Context, input *AllocateStaticIpInput, opts ...request.Option) (*AllocateStaticIpOutput, error) {
	req, out := c.AllocateStaticIpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachStaticIp = "AttachStaticIp"

// AttachStaticIpRequest generates a "aws/request.Request" representing the
// client's request for the AttachStaticIp operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachStaticIp for more information on using the AttachStaticIp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachStaticIpRequest method.
//    req, resp := client.AttachStaticIpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachStaticIp
func (c *Lightsail) AttachStaticIpRequest(input *AttachStaticIpInput) (req *request.Request, output *AttachStaticIpOutput) {
	op := &request.Operation{
		Name:       opAttachStaticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachStaticIpInput{}
	}

	output = &AttachStaticIpOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachStaticIp API operation for Amazon Lightsail.
//
// Attaches a static IP address to a specific Amazon Lightsail instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation AttachStaticIp for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachStaticIp
func (c *Lightsail) AttachStaticIp(input *AttachStaticIpInput) (*AttachStaticIpOutput, error) {
	req, out := c.AttachStaticIpRequest(input)
	return out, req.Send()
}

// AttachStaticIpWithContext is the same as AttachStaticIp with the addition of
// the ability to pass a context and additional request options.
//
// See AttachStaticIp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) AttachStaticIpWithContext(ctx aws.Context, input *AttachStaticIpInput, opts ...request.Option) (*AttachStaticIpOutput, error) {
	req, out := c.AttachStaticIpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCloseInstancePublicPorts = "CloseInstancePublicPorts"

// CloseInstancePublicPortsRequest generates a "aws/request.Request" representing the
// client's request for the CloseInstancePublicPorts operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CloseInstancePublicPorts for more information on using the CloseInstancePublicPorts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CloseInstancePublicPortsRequest method.
//    req, resp := client.CloseInstancePublicPortsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CloseInstancePublicPorts
func (c *Lightsail) CloseInstancePublicPortsRequest(input *CloseInstancePublicPortsInput) (req *request.Request, output *CloseInstancePublicPortsOutput) {
	op := &request.Operation{
		Name:       opCloseInstancePublicPorts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CloseInstancePublicPortsInput{}
	}

	output = &CloseInstancePublicPortsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CloseInstancePublicPorts API operation for Amazon Lightsail.
//
// Closes the public ports on a specific Amazon Lightsail instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CloseInstancePublicPorts for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CloseInstancePublicPorts
func (c *Lightsail) CloseInstancePublicPorts(input *CloseInstancePublicPortsInput) (*CloseInstancePublicPortsOutput, error) {
	req, out := c.CloseInstancePublicPortsRequest(input)
	return out, req.Send()
}

// CloseInstancePublicPortsWithContext is the same as CloseInstancePublicPorts with the addition of
// the ability to pass a context and additional request options.
//
// See CloseInstancePublicPorts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CloseInstancePublicPortsWithContext(ctx aws.Context, input *CloseInstancePublicPortsInput, opts ...request.Option) (*CloseInstancePublicPortsOutput, error) {
	req, out := c.CloseInstancePublicPortsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDomain = "CreateDomain"

// CreateDomainRequest generates a "aws/request.Request" representing the
// client's request for the CreateDomain operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDomain for more information on using the CreateDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDomainRequest method.
//    req, resp := client.CreateDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomain
func (c *Lightsail) CreateDomainRequest(input *CreateDomainInput) (req *request.Request, output *CreateDomainOutput) {
	op := &request.Operation{
		Name:       opCreateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDomainInput{}
	}

	output = &CreateDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDomain API operation for Amazon Lightsail.
//
// Creates a domain resource for the specified domain (e.g., example.com).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateDomain for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomain
func (c *Lightsail) CreateDomain(input *CreateDomainInput) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	return out, req.Send()
}

// CreateDomainWithContext is the same as CreateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateDomainWithContext(ctx aws.Context, input *CreateDomainInput, opts ...request.Option) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDomainEntry = "CreateDomainEntry"

// CreateDomainEntryRequest generates a "aws/request.Request" representing the
// client's request for the CreateDomainEntry operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDomainEntry for more information on using the CreateDomainEntry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDomainEntryRequest method.
//    req, resp := client.CreateDomainEntryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomainEntry
func (c *Lightsail) CreateDomainEntryRequest(input *CreateDomainEntryInput) (req *request.Request, output *CreateDomainEntryOutput) {
	op := &request.Operation{
		Name:       opCreateDomainEntry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDomainEntryInput{}
	}

	output = &CreateDomainEntryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDomainEntry API operation for Amazon Lightsail.
//
// Creates one of the following entry records associated with the domain: A
// record, CNAME record, TXT record, or MX record.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateDomainEntry for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomainEntry
func (c *Lightsail) CreateDomainEntry(input *CreateDomainEntryInput) (*CreateDomainEntryOutput, error) {
	req, out := c.CreateDomainEntryRequest(input)
	return out, req.Send()
}

// CreateDomainEntryWithContext is the same as CreateDomainEntry with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomainEntry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateDomainEntryWithContext(ctx aws.Context, input *CreateDomainEntryInput, opts ...request.Option) (*CreateDomainEntryOutput, error) {
	req, out := c.CreateDomainEntryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInstanceSnapshot = "CreateInstanceSnapshot"

// CreateInstanceSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateInstanceSnapshot operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInstanceSnapshot for more information on using the CreateInstanceSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInstanceSnapshotRequest method.
//    req, resp := client.CreateInstanceSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstanceSnapshot
func (c *Lightsail) CreateInstanceSnapshotRequest(input *CreateInstanceSnapshotInput) (req *request.Request, output *CreateInstanceSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateInstanceSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstanceSnapshotInput{}
	}

	output = &CreateInstanceSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInstanceSnapshot API operation for Amazon Lightsail.
//
// Creates a snapshot of a specific virtual private server, or instance. You
// can use a snapshot to create a new instance that is based on that snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateInstanceSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstanceSnapshot
func (c *Lightsail) CreateInstanceSnapshot(input *CreateInstanceSnapshotInput) (*CreateInstanceSnapshotOutput, error) {
	req, out := c.CreateInstanceSnapshotRequest(input)
	return out, req.Send()
}

// CreateInstanceSnapshotWithContext is the same as CreateInstanceSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstanceSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateInstanceSnapshotWithContext(ctx aws.Context, input *CreateInstanceSnapshotInput, opts ...request.Option) (*CreateInstanceSnapshotOutput, error) {
	req, out := c.CreateInstanceSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInstances = "CreateInstances"

// CreateInstancesRequest generates a "aws/request.Request" representing the
// client's request for the CreateInstances operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInstances for more information on using the CreateInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInstancesRequest method.
//    req, resp := client.CreateInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstances
func (c *Lightsail) CreateInstancesRequest(input *CreateInstancesInput) (req *request.Request, output *CreateInstancesOutput) {
	op := &request.Operation{
		Name:       opCreateInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstancesInput{}
	}

	output = &CreateInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInstances API operation for Amazon Lightsail.
//
// Creates one or more Amazon Lightsail virtual private servers, or instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstances
func (c *Lightsail) CreateInstances(input *CreateInstancesInput) (*CreateInstancesOutput, error) {
	req, out := c.CreateInstancesRequest(input)
	return out, req.Send()
}

// CreateInstancesWithContext is the same as CreateInstances with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateInstancesWithContext(ctx aws.Context, input *CreateInstancesInput, opts ...request.Option) (*CreateInstancesOutput, error) {
	req, out := c.CreateInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInstancesFromSnapshot = "CreateInstancesFromSnapshot"

// CreateInstancesFromSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateInstancesFromSnapshot operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInstancesFromSnapshot for more information on using the CreateInstancesFromSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInstancesFromSnapshotRequest method.
//    req, resp := client.CreateInstancesFromSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstancesFromSnapshot
func (c *Lightsail) CreateInstancesFromSnapshotRequest(input *CreateInstancesFromSnapshotInput) (req *request.Request, output *CreateInstancesFromSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateInstancesFromSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstancesFromSnapshotInput{}
	}

	output = &CreateInstancesFromSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInstancesFromSnapshot API operation for Amazon Lightsail.
//
// Uses a specific snapshot as a blueprint for creating one or more new instances
// that are based on that identical configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateInstancesFromSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstancesFromSnapshot
func (c *Lightsail) CreateInstancesFromSnapshot(input *CreateInstancesFromSnapshotInput) (*CreateInstancesFromSnapshotOutput, error) {
	req, out := c.CreateInstancesFromSnapshotRequest(input)
	return out, req.Send()
}

// CreateInstancesFromSnapshotWithContext is the same as CreateInstancesFromSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstancesFromSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateInstancesFromSnapshotWithContext(ctx aws.Context, input *CreateInstancesFromSnapshotInput, opts ...request.Option) (*CreateInstancesFromSnapshotOutput, error) {
	req, out := c.CreateInstancesFromSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKeyPair = "CreateKeyPair"

// CreateKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the CreateKeyPair operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateKeyPair for more information on using the CreateKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateKeyPairRequest method.
//    req, resp := client.CreateKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateKeyPair
func (c *Lightsail) CreateKeyPairRequest(input *CreateKeyPairInput) (req *request.Request, output *CreateKeyPairOutput) {
	op := &request.Operation{
		Name:       opCreateKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateKeyPairInput{}
	}

	output = &CreateKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKeyPair API operation for Amazon Lightsail.
//
// Creates sn SSH key pair.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateKeyPair for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateKeyPair
func (c *Lightsail) CreateKeyPair(input *CreateKeyPairInput) (*CreateKeyPairOutput, error) {
	req, out := c.CreateKeyPairRequest(input)
	return out, req.Send()
}

// CreateKeyPairWithContext is the same as CreateKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateKeyPairWithContext(ctx aws.Context, input *CreateKeyPairInput, opts ...request.Option) (*CreateKeyPairOutput, error) {
	req, out := c.CreateKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDomain = "DeleteDomain"

// DeleteDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDomain operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDomain for more information on using the DeleteDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDomainRequest method.
//    req, resp := client.DeleteDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomain
func (c *Lightsail) DeleteDomainRequest(input *DeleteDomainInput) (req *request.Request, output *DeleteDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDomainInput{}
	}

	output = &DeleteDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDomain API operation for Amazon Lightsail.
//
// Deletes the specified domain recordset and all of its domain records.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteDomain for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomain
func (c *Lightsail) DeleteDomain(input *DeleteDomainInput) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	return out, req.Send()
}

// DeleteDomainWithContext is the same as DeleteDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteDomainWithContext(ctx aws.Context, input *DeleteDomainInput, opts ...request.Option) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDomainEntry = "DeleteDomainEntry"

// DeleteDomainEntryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDomainEntry operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDomainEntry for more information on using the DeleteDomainEntry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDomainEntryRequest method.
//    req, resp := client.DeleteDomainEntryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomainEntry
func (c *Lightsail) DeleteDomainEntryRequest(input *DeleteDomainEntryInput) (req *request.Request, output *DeleteDomainEntryOutput) {
	op := &request.Operation{
		Name:       opDeleteDomainEntry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDomainEntryInput{}
	}

	output = &DeleteDomainEntryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDomainEntry API operation for Amazon Lightsail.
//
// Deletes a specific domain entry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteDomainEntry for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomainEntry
func (c *Lightsail) DeleteDomainEntry(input *DeleteDomainEntryInput) (*DeleteDomainEntryOutput, error) {
	req, out := c.DeleteDomainEntryRequest(input)
	return out, req.Send()
}

// DeleteDomainEntryWithContext is the same as DeleteDomainEntry with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDomainEntry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteDomainEntryWithContext(ctx aws.Context, input *DeleteDomainEntryInput, opts ...request.Option) (*DeleteDomainEntryOutput, error) {
	req, out := c.DeleteDomainEntryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInstance = "DeleteInstance"

// DeleteInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInstance operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInstance for more information on using the DeleteInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInstanceRequest method.
//    req, resp := client.DeleteInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstance
func (c *Lightsail) DeleteInstanceRequest(input *DeleteInstanceInput) (req *request.Request, output *DeleteInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInstanceInput{}
	}

	output = &DeleteInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInstance API operation for Amazon Lightsail.
//
// Deletes a specific Amazon Lightsail virtual private server, or instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstance
func (c *Lightsail) DeleteInstance(input *DeleteInstanceInput) (*DeleteInstanceOutput, error) {
	req, out := c.DeleteInstanceRequest(input)
	return out, req.Send()
}

// DeleteInstanceWithContext is the same as DeleteInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteInstanceWithContext(ctx aws.Context, input *DeleteInstanceInput, opts ...request.Option) (*DeleteInstanceOutput, error) {
	req, out := c.DeleteInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInstanceSnapshot = "DeleteInstanceSnapshot"

// DeleteInstanceSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInstanceSnapshot operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInstanceSnapshot for more information on using the DeleteInstanceSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInstanceSnapshotRequest method.
//    req, resp := client.DeleteInstanceSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstanceSnapshot
func (c *Lightsail) DeleteInstanceSnapshotRequest(input *DeleteInstanceSnapshotInput) (req *request.Request, output *DeleteInstanceSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteInstanceSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInstanceSnapshotInput{}
	}

	output = &DeleteInstanceSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInstanceSnapshot API operation for Amazon Lightsail.
//
// Deletes a specific snapshot of a virtual private server (or instance).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteInstanceSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstanceSnapshot
func (c *Lightsail) DeleteInstanceSnapshot(input *DeleteInstanceSnapshotInput) (*DeleteInstanceSnapshotOutput, error) {
	req, out := c.DeleteInstanceSnapshotRequest(input)
	return out, req.Send()
}

// DeleteInstanceSnapshotWithContext is the same as DeleteInstanceSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInstanceSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteInstanceSnapshotWithContext(ctx aws.Context, input *DeleteInstanceSnapshotInput, opts ...request.Option) (*DeleteInstanceSnapshotOutput, error) {
	req, out := c.DeleteInstanceSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteKeyPair = "DeleteKeyPair"

// DeleteKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the DeleteKeyPair operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteKeyPair for more information on using the DeleteKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteKeyPairRequest method.
//    req, resp := client.DeleteKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteKeyPair
func (c *Lightsail) DeleteKeyPairRequest(input *DeleteKeyPairInput) (req *request.Request, output *DeleteKeyPairOutput) {
	op := &request.Operation{
		Name:       opDeleteKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteKeyPairInput{}
	}

	output = &DeleteKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteKeyPair API operation for Amazon Lightsail.
//
// Deletes a specific SSH key pair.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteKeyPair for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteKeyPair
func (c *Lightsail) DeleteKeyPair(input *DeleteKeyPairInput) (*DeleteKeyPairOutput, error) {
	req, out := c.DeleteKeyPairRequest(input)
	return out, req.Send()
}

// DeleteKeyPairWithContext is the same as DeleteKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteKeyPairWithContext(ctx aws.Context, input *DeleteKeyPairInput, opts ...request.Option) (*DeleteKeyPairOutput, error) {
	req, out := c.DeleteKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachStaticIp = "DetachStaticIp"

// DetachStaticIpRequest generates a "aws/request.Request" representing the
// client's request for the DetachStaticIp operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachStaticIp for more information on using the DetachStaticIp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachStaticIpRequest method.
//    req, resp := client.DetachStaticIpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachStaticIp
func (c *Lightsail) DetachStaticIpRequest(input *DetachStaticIpInput) (req *request.Request, output *DetachStaticIpOutput) {
	op := &request.Operation{
		Name:       opDetachStaticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachStaticIpInput{}
	}

	output = &DetachStaticIpOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetachStaticIp API operation for Amazon Lightsail.
//
// Detaches a static IP from the Amazon Lightsail instance to which it is attached.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DetachStaticIp for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachStaticIp
func (c *Lightsail) DetachStaticIp(input *DetachStaticIpInput) (*DetachStaticIpOutput, error) {
	req, out := c.DetachStaticIpRequest(input)
	return out, req.Send()
}

// DetachStaticIpWithContext is the same as DetachStaticIp with the addition of
// the ability to pass a context and additional request options.
//
// See DetachStaticIp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DetachStaticIpWithContext(ctx aws.Context, input *DetachStaticIpInput, opts ...request.Option) (*DetachStaticIpOutput, error) {
	req, out := c.DetachStaticIpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDownloadDefaultKeyPair = "DownloadDefaultKeyPair"

// DownloadDefaultKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the DownloadDefaultKeyPair operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DownloadDefaultKeyPair for more information on using the DownloadDefaultKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DownloadDefaultKeyPairRequest method.
//    req, resp := client.DownloadDefaultKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DownloadDefaultKeyPair
func (c *Lightsail) DownloadDefaultKeyPairRequest(input *DownloadDefaultKeyPairInput) (req *request.Request, output *DownloadDefaultKeyPairOutput) {
	op := &request.Operation{
		Name:       opDownloadDefaultKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DownloadDefaultKeyPairInput{}
	}

	output = &DownloadDefaultKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DownloadDefaultKeyPair API operation for Amazon Lightsail.
//
// Downloads the default SSH key pair from the user's account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DownloadDefaultKeyPair for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DownloadDefaultKeyPair
func (c *Lightsail) DownloadDefaultKeyPair(input *DownloadDefaultKeyPairInput) (*DownloadDefaultKeyPairOutput, error) {
	req, out := c.DownloadDefaultKeyPairRequest(input)
	return out, req.Send()
}

// DownloadDefaultKeyPairWithContext is the same as DownloadDefaultKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See DownloadDefaultKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DownloadDefaultKeyPairWithContext(ctx aws.Context, input *DownloadDefaultKeyPairInput, opts ...request.Option) (*DownloadDefaultKeyPairOutput, error) {
	req, out := c.DownloadDefaultKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetActiveNames = "GetActiveNames"

// GetActiveNamesRequest generates a "aws/request.Request" representing the
// client's request for the GetActiveNames operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetActiveNames for more information on using the GetActiveNames
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetActiveNamesRequest method.
//    req, resp := client.GetActiveNamesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetActiveNames
func (c *Lightsail) GetActiveNamesRequest(input *GetActiveNamesInput) (req *request.Request, output *GetActiveNamesOutput) {
	op := &request.Operation{
		Name:       opGetActiveNames,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetActiveNamesInput{}
	}

	output = &GetActiveNamesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetActiveNames API operation for Amazon Lightsail.
//
// Returns the names of all active (not deleted) resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetActiveNames for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetActiveNames
func (c *Lightsail) GetActiveNames(input *GetActiveNamesInput) (*GetActiveNamesOutput, error) {
	req, out := c.GetActiveNamesRequest(input)
	return out, req.Send()
}

// GetActiveNamesWithContext is the same as GetActiveNames with the addition of
// the ability to pass a context and additional request options.
//
// See GetActiveNames for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetActiveNamesWithContext(ctx aws.Context, input *GetActiveNamesInput, opts ...request.Option) (*GetActiveNamesOutput, error) {
	req, out := c.GetActiveNamesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBlueprints = "GetBlueprints"

// GetBlueprintsRequest generates a "aws/request.Request" representing the
// client's request for the GetBlueprints operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBlueprints for more information on using the GetBlueprints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBlueprintsRequest method.
//    req, resp := client.GetBlueprintsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBlueprints
func (c *Lightsail) GetBlueprintsRequest(input *GetBlueprintsInput) (req *request.Request, output *GetBlueprintsOutput) {
	op := &request.Operation{
		Name:       opGetBlueprints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetBlueprintsInput{}
	}

	output = &GetBlueprintsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBlueprints API operation for Amazon Lightsail.
//
// Returns the list of available instance images, or blueprints. You can use
// a blueprint to create a new virtual private server already running a specific
// operating system, as well as a preinstalled app or development stack. The
// software each instance is running depends on the blueprint image you choose.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetBlueprints for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBlueprints
func (c *Lightsail) GetBlueprints(input *GetBlueprintsInput) (*GetBlueprintsOutput, error) {
	req, out := c.GetBlueprintsRequest(input)
	return out, req.Send()
}

// GetBlueprintsWithContext is the same as GetBlueprints with the addition of
// the ability to pass a context and additional request options.
//
// See GetBlueprints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetBlueprintsWithContext(ctx aws.Context, input *GetBlueprintsInput, opts ...request.Option) (*GetBlueprintsOutput, error) {
	req, out := c.GetBlueprintsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBundles = "GetBundles"

// GetBundlesRequest generates a "aws/request.Request" representing the
// client's request for the GetBundles operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBundles for more information on using the GetBundles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBundlesRequest method.
//    req, resp := client.GetBundlesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBundles
func (c *Lightsail) GetBundlesRequest(input *GetBundlesInput) (req *request.Request, output *GetBundlesOutput) {
	op := &request.Operation{
		Name:       opGetBundles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetBundlesInput{}
	}

	output = &GetBundlesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBundles API operation for Amazon Lightsail.
//
// Returns the list of bundles that are available for purchase. A bundle describes
// the specs for your virtual private server (or instance).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetBundles for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBundles
func (c *Lightsail) GetBundles(input *GetBundlesInput) (*GetBundlesOutput, error) {
	req, out := c.GetBundlesRequest(input)
	return out, req.Send()
}

// GetBundlesWithContext is the same as GetBundles with the addition of
// the ability to pass a context and additional request options.
//
// See GetBundles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetBundlesWithContext(ctx aws.Context, input *GetBundlesInput, opts ...request.Option) (*GetBundlesOutput, error) {
	req, out := c.GetBundlesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDomain = "GetDomain"

// GetDomainRequest generates a "aws/request.Request" representing the
// client's request for the GetDomain operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDomain for more information on using the GetDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDomainRequest method.
//    req, resp := client.GetDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomain
func (c *Lightsail) GetDomainRequest(input *GetDomainInput) (req *request.Request, output *GetDomainOutput) {
	op := &request.Operation{
		Name:       opGetDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDomainInput{}
	}

	output = &GetDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDomain API operation for Amazon Lightsail.
//
// Returns information about a specific domain recordset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetDomain for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomain
func (c *Lightsail) GetDomain(input *GetDomainInput) (*GetDomainOutput, error) {
	req, out := c.GetDomainRequest(input)
	return out, req.Send()
}

// GetDomainWithContext is the same as GetDomain with the addition of
// the ability to pass a context and additional request options.
//
// See GetDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetDomainWithContext(ctx aws.Context, input *GetDomainInput, opts ...request.Option) (*GetDomainOutput, error) {
	req, out := c.GetDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDomains = "GetDomains"

// GetDomainsRequest generates a "aws/request.Request" representing the
// client's request for the GetDomains operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDomains for more information on using the GetDomains
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDomainsRequest method.
//    req, resp := client.GetDomainsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomains
func (c *Lightsail) GetDomainsRequest(input *GetDomainsInput) (req *request.Request, output *GetDomainsOutput) {
	op := &request.Operation{
		Name:       opGetDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDomainsInput{}
	}

	output = &GetDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDomains API operation for Amazon Lightsail.
//
// Returns a list of all domains in the user's account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetDomains for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomains
func (c *Lightsail) GetDomains(input *GetDomainsInput) (*GetDomainsOutput, error) {
	req, out := c.GetDomainsRequest(input)
	return out, req.Send()
}

// GetDomainsWithContext is the same as GetDomains with the addition of
// the ability to pass a context and additional request options.
//
// See GetDomains for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetDomainsWithContext(ctx aws.Context, input *GetDomainsInput, opts ...request.Option) (*GetDomainsOutput, error) {
	req, out := c.GetDomainsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstance = "GetInstance"

// GetInstanceRequest generates a "aws/request.Request" representing the
// client's request for the GetInstance operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstance for more information on using the GetInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstanceRequest method.
//    req, resp := client.GetInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstance
func (c *Lightsail) GetInstanceRequest(input *GetInstanceInput) (req *request.Request, output *GetInstanceOutput) {
	op := &request.Operation{
		Name:       opGetInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceInput{}
	}

	output = &GetInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstance API operation for Amazon Lightsail.
//
// Returns information about a specific Amazon Lightsail instance, which is
// a virtual private server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstance
func (c *Lightsail) GetInstance(input *GetInstanceInput) (*GetInstanceOutput, error) {
	req, out := c.GetInstanceRequest(input)
	return out, req.Send()
}

// GetInstanceWithContext is the same as GetInstance with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetInstanceWithContext(ctx aws.Context, input *GetInstanceInput, opts ...request.Option) (*GetInstanceOutput, error) {
	req, out := c.GetInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstanceAccessDetails = "GetInstanceAccessDetails"

// GetInstanceAccessDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetInstanceAccessDetails operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstanceAccessDetails for more information on using the GetInstanceAccessDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstanceAccessDetailsRequest method.
//    req, resp := client.GetInstanceAccessDetailsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceAccessDetails
func (c *Lightsail) GetInstanceAccessDetailsRequest(input *GetInstanceAccessDetailsInput) (req *request.Request, output *GetInstanceAccessDetailsOutput) {
	op := &request.Operation{
		Name:       opGetInstanceAccessDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceAccessDetailsInput{}
	}

	output = &GetInstanceAccessDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstanceAccessDetails API operation for Amazon Lightsail.
//
// Returns temporary SSH keys you can use to connect to a specific virtual private
// server, or instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetInstanceAccessDetails for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceAccessDetails
func (c *Lightsail) GetInstanceAccessDetails(input *GetInstanceAccessDetailsInput) (*GetInstanceAccessDetailsOutput, error) {
	req, out := c.GetInstanceAccessDetailsRequest(input)
	return out, req.Send()
}

// GetInstanceAccessDetailsWithContext is the same as GetInstanceAccessDetails with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstanceAccessDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetInstanceAccessDetailsWithContext(ctx aws.Context, input *GetInstanceAccessDetailsInput, opts ...request.Option) (*GetInstanceAccessDetailsOutput, error) {
	req, out := c.GetInstanceAccessDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstanceMetricData = "GetInstanceMetricData"

// GetInstanceMetricDataRequest generates a "aws/request.Request" representing the
// client's request for the GetInstanceMetricData operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstanceMetricData for more information on using the GetInstanceMetricData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstanceMetricDataRequest method.
//    req, resp := client.GetInstanceMetricDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceMetricData
func (c *Lightsail) GetInstanceMetricDataRequest(input *GetInstanceMetricDataInput) (req *request.Request, output *GetInstanceMetricDataOutput) {
	op := &request.Operation{
		Name:       opGetInstanceMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceMetricDataInput{}
	}

	output = &GetInstanceMetricDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstanceMetricData API operation for Amazon Lightsail.
//
// Returns the data points for the specified Amazon Lightsail instance metric,
// given an instance name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetInstanceMetricData for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceMetricData
func (c *Lightsail) GetInstanceMetricData(input *GetInstanceMetricDataInput) (*GetInstanceMetricDataOutput, error) {
	req, out := c.GetInstanceMetricDataRequest(input)
	return out, req.Send()
}

// GetInstanceMetricDataWithContext is the same as GetInstanceMetricData with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstanceMetricData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetInstanceMetricDataWithContext(ctx aws.Context, input *GetInstanceMetricDataInput, opts ...request.Option) (*GetInstanceMetricDataOutput, error) {
	req, out := c.GetInstanceMetricDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstancePortStates = "GetInstancePortStates"

// GetInstancePortStatesRequest generates a "aws/request.Request" representing the
// client's request for the GetInstancePortStates operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstancePortStates for more information on using the GetInstancePortStates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstancePortStatesRequest method.
//    req, resp := client.GetInstancePortStatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstancePortStates
func (c *Lightsail) GetInstancePortStatesRequest(input *GetInstancePortStatesInput) (req *request.Request, output *GetInstancePortStatesOutput) {
	op := &request.Operation{
		Name:       opGetInstancePortStates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstancePortStatesInput{}
	}

	output = &GetInstancePortStatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstancePortStates API operation for Amazon Lightsail.
//
// Returns the port states for a specific virtual private server, or instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetInstancePortStates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstancePortStates
func (c *Lightsail) GetInstancePortStates(input *GetInstancePortStatesInput) (*GetInstancePortStatesOutput, error) {
	req, out := c.GetInstancePortStatesRequest(input)
	return out, req.Send()
}

// GetInstancePortStatesWithContext is the same as GetInstancePortStates with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstancePortStates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetInstancePortStatesWithContext(ctx aws.Context, input *GetInstancePortStatesInput, opts ...request.Option) (*GetInstancePortStatesOutput, error) {
	req, out := c.GetInstancePortStatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstanceSnapshot = "GetInstanceSnapshot"

// GetInstanceSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the GetInstanceSnapshot operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstanceSnapshot for more information on using the GetInstanceSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstanceSnapshotRequest method.
//    req, resp := client.GetInstanceSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshot
func (c *Lightsail) GetInstanceSnapshotRequest(input *GetInstanceSnapshotInput) (req *request.Request, output *GetInstanceSnapshotOutput) {
	op := &request.Operation{
		Name:       opGetInstanceSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceSnapshotInput{}
	}

	output = &GetInstanceSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstanceSnapshot API operation for Amazon Lightsail.
//
// Returns information about a specific instance snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetInstanceSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshot
func (c *Lightsail) GetInstanceSnapshot(input *GetInstanceSnapshotInput) (*GetInstanceSnapshotOutput, error) {
	req, out := c.GetInstanceSnapshotRequest(input)
	return out, req.Send()
}

// GetInstanceSnapshotWithContext is the same as GetInstanceSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstanceSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetInstanceSnapshotWithContext(ctx aws.Context, input *GetInstanceSnapshotInput, opts ...request.Option) (*GetInstanceSnapshotOutput, error) {
	req, out := c.GetInstanceSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstanceSnapshots = "GetInstanceSnapshots"

// GetInstanceSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the GetInstanceSnapshots operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstanceSnapshots for more information on using the GetInstanceSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstanceSnapshotsRequest method.
//    req, resp := client.GetInstanceSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshots
func (c *Lightsail) GetInstanceSnapshotsRequest(input *GetInstanceSnapshotsInput) (req *request.Request, output *GetInstanceSnapshotsOutput) {
	op := &request.Operation{
		Name:       opGetInstanceSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceSnapshotsInput{}
	}

	output = &GetInstanceSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstanceSnapshots API operation for Amazon Lightsail.
//
// Returns all instance snapshots for the user's account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetInstanceSnapshots for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshots
func (c *Lightsail) GetInstanceSnapshots(input *GetInstanceSnapshotsInput) (*GetInstanceSnapshotsOutput, error) {
	req, out := c.GetInstanceSnapshotsRequest(input)
	return out, req.Send()
}

// GetInstanceSnapshotsWithContext is the same as GetInstanceSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstanceSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetInstanceSnapshotsWithContext(ctx aws.Context, input *GetInstanceSnapshotsInput, opts ...request.Option) (*GetInstanceSnapshotsOutput, error) {
	req, out := c.GetInstanceSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstanceState = "GetInstanceState"

// GetInstanceStateRequest generates a "aws/request.Request" representing the
// client's request for the GetInstanceState operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstanceState for more information on using the GetInstanceState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstanceStateRequest method.
//    req, resp := client.GetInstanceStateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceState
func (c *Lightsail) GetInstanceStateRequest(input *GetInstanceStateInput) (req *request.Request, output *GetInstanceStateOutput) {
	op := &request.Operation{
		Name:       opGetInstanceState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceStateInput{}
	}

	output = &GetInstanceStateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstanceState API operation for Amazon Lightsail.
//
// Returns the state of a specific instance. Works on one instance at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetInstanceState for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceState
func (c *Lightsail) GetInstanceState(input *GetInstanceStateInput) (*GetInstanceStateOutput, error) {
	req, out := c.GetInstanceStateRequest(input)
	return out, req.Send()
}

// GetInstanceStateWithContext is the same as GetInstanceState with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstanceState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetInstanceStateWithContext(ctx aws.Context, input *GetInstanceStateInput, opts ...request.Option) (*GetInstanceStateOutput, error) {
	req, out := c.GetInstanceStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstances = "GetInstances"

// GetInstancesRequest generates a "aws/request.Request" representing the
// client's request for the GetInstances operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstances for more information on using the GetInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstancesRequest method.
//    req, resp := client.GetInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstances
func (c *Lightsail) GetInstancesRequest(input *GetInstancesInput) (req *request.Request, output *GetInstancesOutput) {
	op := &request.Operation{
		Name:       opGetInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstancesInput{}
	}

	output = &GetInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstances API operation for Amazon Lightsail.
//
// Returns information about all Amazon Lightsail virtual private servers, or
// instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstances
func (c *Lightsail) GetInstances(input *GetInstancesInput) (*GetInstancesOutput, error) {
	req, out := c.GetInstancesRequest(input)
	return out, req.Send()
}

// GetInstancesWithContext is the same as GetInstances with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetInstancesWithContext(ctx aws.Context, input *GetInstancesInput, opts ...request.Option) (*GetInstancesOutput, error) {
	req, out := c.GetInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKeyPair = "GetKeyPair"

// GetKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the GetKeyPair operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKeyPair for more information on using the GetKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetKeyPairRequest method.
//    req, resp := client.GetKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPair
func (c *Lightsail) GetKeyPairRequest(input *GetKeyPairInput) (req *request.Request, output *GetKeyPairOutput) {
	op := &request.Operation{
		Name:       opGetKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetKeyPairInput{}
	}

	output = &GetKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKeyPair API operation for Amazon Lightsail.
//
// Returns information about a specific key pair.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetKeyPair for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPair
func (c *Lightsail) GetKeyPair(input *GetKeyPairInput) (*GetKeyPairOutput, error) {
	req, out := c.GetKeyPairRequest(input)
	return out, req.Send()
}

// GetKeyPairWithContext is the same as GetKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See GetKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetKeyPairWithContext(ctx aws.Context, input *GetKeyPairInput, opts ...request.Option) (*GetKeyPairOutput, error) {
	req, out := c.GetKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKeyPairs = "GetKeyPairs"

// GetKeyPairsRequest generates a "aws/request.Request" representing the
// client's request for the GetKeyPairs operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKeyPairs for more information on using the GetKeyPairs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetKeyPairsRequest method.
//    req, resp := client.GetKeyPairsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPairs
func (c *Lightsail) GetKeyPairsRequest(input *GetKeyPairsInput) (req *request.Request, output *GetKeyPairsOutput) {
	op := &request.Operation{
		Name:       opGetKeyPairs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetKeyPairsInput{}
	}

	output = &GetKeyPairsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKeyPairs API operation for Amazon Lightsail.
//
// Returns information about all key pairs in the user's account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetKeyPairs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPairs
func (c *Lightsail) GetKeyPairs(input *GetKeyPairsInput) (*GetKeyPairsOutput, error) {
	req, out := c.GetKeyPairsRequest(input)
	return out, req.Send()
}

// GetKeyPairsWithContext is the same as GetKeyPairs with the addition of
// the ability to pass a context and additional request options.
//
// See GetKeyPairs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetKeyPairsWithContext(ctx aws.Context, input *GetKeyPairsInput, opts ...request.Option) (*GetKeyPairsOutput, error) {
	req, out := c.GetKeyPairsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOperation = "GetOperation"

// GetOperationRequest generates a "aws/request.Request" representing the
// client's request for the GetOperation operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOperation for more information on using the GetOperation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOperationRequest method.
//    req, resp := client.GetOperationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperation
func (c *Lightsail) GetOperationRequest(input *GetOperationInput) (req *request.Request, output *GetOperationOutput) {
	op := &request.Operation{
		Name:       opGetOperation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOperationInput{}
	}

	output = &GetOperationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOperation API operation for Amazon Lightsail.
//
// Returns information about a specific operation. Operations include events
// such as when you create an instance, allocate a static IP, attach a static
// IP, and so on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetOperation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperation
func (c *Lightsail) GetOperation(input *GetOperationInput) (*GetOperationOutput, error) {
	req, out := c.GetOperationRequest(input)
	return out, req.Send()
}

// GetOperationWithContext is the same as GetOperation with the addition of
// the ability to pass a context and additional request options.
//
// See GetOperation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetOperationWithContext(ctx aws.Context, input *GetOperationInput, opts ...request.Option) (*GetOperationOutput, error) {
	req, out := c.GetOperationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOperations = "GetOperations"

// GetOperationsRequest generates a "aws/request.Request" representing the
// client's request for the GetOperations operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOperations for more information on using the GetOperations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOperationsRequest method.
//    req, resp := client.GetOperationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperations
func (c *Lightsail) GetOperationsRequest(input *GetOperationsInput) (req *request.Request, output *GetOperationsOutput) {
	op := &request.Operation{
		Name:       opGetOperations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOperationsInput{}
	}

	output = &GetOperationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOperations API operation for Amazon Lightsail.
//
// Returns information about all operations.
//
// Results are returned from oldest to newest, up to a maximum of 200. Results
// can be paged by making each subsequent call to GetOperations use the maximum
// (last) statusChangedAt value from the previous request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetOperations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperations
func (c *Lightsail) GetOperations(input *GetOperationsInput) (*GetOperationsOutput, error) {
	req, out := c.GetOperationsRequest(input)
	return out, req.Send()
}

// GetOperationsWithContext is the same as GetOperations with the addition of
// the ability to pass a context and additional request options.
//
// See GetOperations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetOperationsWithContext(ctx aws.Context, input *GetOperationsInput, opts ...request.Option) (*GetOperationsOutput, error) {
	req, out := c.GetOperationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOperationsForResource = "GetOperationsForResource"

// GetOperationsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the GetOperationsForResource operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOperationsForResource for more information on using the GetOperationsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOperationsForResourceRequest method.
//    req, resp := client.GetOperationsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperationsForResource
func (c *Lightsail) GetOperationsForResourceRequest(input *GetOperationsForResourceInput) (req *request.Request, output *GetOperationsForResourceOutput) {
	op := &request.Operation{
		Name:       opGetOperationsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOperationsForResourceInput{}
	}

	output = &GetOperationsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOperationsForResource API operation for Amazon Lightsail.
//
// Gets operations for a specific resource (e.g., an instance or a static IP).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetOperationsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperationsForResource
func (c *Lightsail) GetOperationsForResource(input *GetOperationsForResourceInput) (*GetOperationsForResourceOutput, error) {
	req, out := c.GetOperationsForResourceRequest(input)
	return out, req.Send()
}

// GetOperationsForResourceWithContext is the same as GetOperationsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See GetOperationsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetOperationsForResourceWithContext(ctx aws.Context, input *GetOperationsForResourceInput, opts ...request.Option) (*GetOperationsForResourceOutput, error) {
	req, out := c.GetOperationsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRegions = "GetRegions"

// GetRegionsRequest generates a "aws/request.Request" representing the
// client's request for the GetRegions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRegions for more information on using the GetRegions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRegionsRequest method.
//    req, resp := client.GetRegionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRegions
func (c *Lightsail) GetRegionsRequest(input *GetRegionsInput) (req *request.Request, output *GetRegionsOutput) {
	op := &request.Operation{
		Name:       opGetRegions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRegionsInput{}
	}

	output = &GetRegionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRegions API operation for Amazon Lightsail.
//
// Returns a list of all valid regions for Amazon Lightsail. Use the include
// availability zones parameter to also return the availability zones in a region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRegions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRegions
func (c *Lightsail) GetRegions(input *GetRegionsInput) (*GetRegionsOutput, error) {
	req, out := c.GetRegionsRequest(input)
	return out, req.Send()
}

// GetRegionsWithContext is the same as GetRegions with the addition of
// the ability to pass a context and additional request options.
//
// See GetRegions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRegionsWithContext(ctx aws.Context, input *GetRegionsInput, opts ...request.Option) (*GetRegionsOutput, error) {
	req, out := c.GetRegionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStaticIp = "GetStaticIp"

// GetStaticIpRequest generates a "aws/request.Request" representing the
// client's request for the GetStaticIp operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStaticIp for more information on using the GetStaticIp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetStaticIpRequest method.
//    req, resp := client.GetStaticIpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIp
func (c *Lightsail) GetStaticIpRequest(input *GetStaticIpInput) (req *request.Request, output *GetStaticIpOutput) {
	op := &request.Operation{
		Name:       opGetStaticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetStaticIpInput{}
	}

	output = &GetStaticIpOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStaticIp API operation for Amazon Lightsail.
//
// Returns information about a specific static IP.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetStaticIp for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIp
func (c *Lightsail) GetStaticIp(input *GetStaticIpInput) (*GetStaticIpOutput, error) {
	req, out := c.GetStaticIpRequest(input)
	return out, req.Send()
}

// GetStaticIpWithContext is the same as GetStaticIp with the addition of
// the ability to pass a context and additional request options.
//
// See GetStaticIp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetStaticIpWithContext(ctx aws.Context, input *GetStaticIpInput, opts ...request.Option) (*GetStaticIpOutput, error) {
	req, out := c.GetStaticIpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStaticIps = "GetStaticIps"

// GetStaticIpsRequest generates a "aws/request.Request" representing the
// client's request for the GetStaticIps operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStaticIps for more information on using the GetStaticIps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetStaticIpsRequest method.
//    req, resp := client.GetStaticIpsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIps
func (c *Lightsail) GetStaticIpsRequest(input *GetStaticIpsInput) (req *request.Request, output *GetStaticIpsOutput) {
	op := &request.Operation{
		Name:       opGetStaticIps,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetStaticIpsInput{}
	}

	output = &GetStaticIpsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStaticIps API operation for Amazon Lightsail.
//
// Returns information about all static IPs in the user's account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetStaticIps for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIps
func (c *Lightsail) GetStaticIps(input *GetStaticIpsInput) (*GetStaticIpsOutput, error) {
	req, out := c.GetStaticIpsRequest(input)
	return out, req.Send()
}

// GetStaticIpsWithContext is the same as GetStaticIps with the addition of
// the ability to pass a context and additional request options.
//
// See GetStaticIps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetStaticIpsWithContext(ctx aws.Context, input *GetStaticIpsInput, opts ...request.Option) (*GetStaticIpsOutput, error) {
	req, out := c.GetStaticIpsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportKeyPair = "ImportKeyPair"

// ImportKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the ImportKeyPair operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportKeyPair for more information on using the ImportKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportKeyPairRequest method.
//    req, resp := client.ImportKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ImportKeyPair
func (c *Lightsail) ImportKeyPairRequest(input *ImportKeyPairInput) (req *request.Request, output *ImportKeyPairOutput) {
	op := &request.Operation{
		Name:       opImportKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportKeyPairInput{}
	}

	output = &ImportKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportKeyPair API operation for Amazon Lightsail.
//
// Imports a public SSH key from a specific key pair.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation ImportKeyPair for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ImportKeyPair
func (c *Lightsail) ImportKeyPair(input *ImportKeyPairInput) (*ImportKeyPairOutput, error) {
	req, out := c.ImportKeyPairRequest(input)
	return out, req.Send()
}

// ImportKeyPairWithContext is the same as ImportKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See ImportKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) ImportKeyPairWithContext(ctx aws.Context, input *ImportKeyPairInput, opts ...request.Option) (*ImportKeyPairOutput, error) {
	req, out := c.ImportKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opIsVpcPeered = "IsVpcPeered"

// IsVpcPeeredRequest generates a "aws/request.Request" representing the
// client's request for the IsVpcPeered operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See IsVpcPeered for more information on using the IsVpcPeered
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the IsVpcPeeredRequest method.
//    req, resp := client.IsVpcPeeredRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/IsVpcPeered
func (c *Lightsail) IsVpcPeeredRequest(input *IsVpcPeeredInput) (req *request.Request, output *IsVpcPeeredOutput) {
	op := &request.Operation{
		Name:       opIsVpcPeered,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &IsVpcPeeredInput{}
	}

	output = &IsVpcPeeredOutput{}
	req = c.newRequest(op, input, output)
	return
}

// IsVpcPeered API operation for Amazon Lightsail.
//
// Returns a Boolean value indicating whether your Lightsail VPC is peered.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation IsVpcPeered for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/IsVpcPeered
func (c *Lightsail) IsVpcPeered(input *IsVpcPeeredInput) (*IsVpcPeeredOutput, error) {
	req, out := c.IsVpcPeeredRequest(input)
	return out, req.Send()
}

// IsVpcPeeredWithContext is the same as IsVpcPeered with the addition of
// the ability to pass a context and additional request options.
//
// See IsVpcPeered for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) IsVpcPeeredWithContext(ctx aws.Context, input *IsVpcPeeredInput, opts ...request.Option) (*IsVpcPeeredOutput, error) {
	req, out := c.IsVpcPeeredRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opOpenInstancePublicPorts = "OpenInstancePublicPorts"

// OpenInstancePublicPortsRequest generates a "aws/request.Request" representing the
// client's request for the OpenInstancePublicPorts operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See OpenInstancePublicPorts for more information on using the OpenInstancePublicPorts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the OpenInstancePublicPortsRequest method.
//    req, resp := client.OpenInstancePublicPortsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/OpenInstancePublicPorts
func (c *Lightsail) OpenInstancePublicPortsRequest(input *OpenInstancePublicPortsInput) (req *request.Request, output *OpenInstancePublicPortsOutput) {
	op := &request.Operation{
		Name:       opOpenInstancePublicPorts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &OpenInstancePublicPortsInput{}
	}

	output = &OpenInstancePublicPortsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// OpenInstancePublicPorts API operation for Amazon Lightsail.
//
// Adds public ports to an Amazon Lightsail instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation OpenInstancePublicPorts for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/OpenInstancePublicPorts
func (c *Lightsail) OpenInstancePublicPorts(input *OpenInstancePublicPortsInput) (*OpenInstancePublicPortsOutput, error) {
	req, out := c.OpenInstancePublicPortsRequest(input)
	return out, req.Send()
}

// OpenInstancePublicPortsWithContext is the same as OpenInstancePublicPorts with the addition of
// the ability to pass a context and additional request options.
//
// See OpenInstancePublicPorts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) OpenInstancePublicPortsWithContext(ctx aws.Context, input *OpenInstancePublicPortsInput, opts ...request.Option) (*OpenInstancePublicPortsOutput, error) {
	req, out := c.OpenInstancePublicPortsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPeerVpc = "PeerVpc"

// PeerVpcRequest generates a "aws/request.Request" representing the
// client's request for the PeerVpc operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PeerVpc for more information on using the PeerVpc
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PeerVpcRequest method.
//    req, resp := client.PeerVpcRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PeerVpc
func (c *Lightsail) PeerVpcRequest(input *PeerVpcInput) (req *request.Request, output *PeerVpcOutput) {
	op := &request.Operation{
		Name:       opPeerVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PeerVpcInput{}
	}

	output = &PeerVpcOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PeerVpc API operation for Amazon Lightsail.
//
// Tries to peer the Lightsail VPC with the user's default VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation PeerVpc for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PeerVpc
func (c *Lightsail) PeerVpc(input *PeerVpcInput) (*PeerVpcOutput, error) {
	req, out := c.PeerVpcRequest(input)
	return out, req.Send()
}

// PeerVpcWithContext is the same as PeerVpc with the addition of
// the ability to pass a context and additional request options.
//
// See PeerVpc for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) PeerVpcWithContext(ctx aws.Context, input *PeerVpcInput, opts ...request.Option) (*PeerVpcOutput, error) {
	req, out := c.PeerVpcRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutInstancePublicPorts = "PutInstancePublicPorts"

// PutInstancePublicPortsRequest generates a "aws/request.Request" representing the
// client's request for the PutInstancePublicPorts operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutInstancePublicPorts for more information on using the PutInstancePublicPorts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutInstancePublicPortsRequest method.
//    req, resp := client.PutInstancePublicPortsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutInstancePublicPorts
func (c *Lightsail) PutInstancePublicPortsRequest(input *PutInstancePublicPortsInput) (req *request.Request, output *PutInstancePublicPortsOutput) {
	op := &request.Operation{
		Name:       opPutInstancePublicPorts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutInstancePublicPortsInput{}
	}

	output = &PutInstancePublicPortsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutInstancePublicPorts API operation for Amazon Lightsail.
//
// Sets the specified open ports for an Amazon Lightsail instance, and closes
// all ports for every protocol not included in the current request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation PutInstancePublicPorts for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutInstancePublicPorts
func (c *Lightsail) PutInstancePublicPorts(input *PutInstancePublicPortsInput) (*PutInstancePublicPortsOutput, error) {
	req, out := c.PutInstancePublicPortsRequest(input)
	return out, req.Send()
}

// PutInstancePublicPortsWithContext is the same as PutInstancePublicPorts with the addition of
// the ability to pass a context and additional request options.
//
// See PutInstancePublicPorts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) PutInstancePublicPortsWithContext(ctx aws.Context, input *PutInstancePublicPortsInput, opts ...request.Option) (*PutInstancePublicPortsOutput, error) {
	req, out := c.PutInstancePublicPortsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebootInstance = "RebootInstance"

// RebootInstanceRequest generates a "aws/request.Request" representing the
// client's request for the RebootInstance operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebootInstance for more information on using the RebootInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RebootInstanceRequest method.
//    req, resp := client.RebootInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootInstance
func (c *Lightsail) RebootInstanceRequest(input *RebootInstanceInput) (req *request.Request, output *RebootInstanceOutput) {
	op := &request.Operation{
		Name:       opRebootInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootInstanceInput{}
	}

	output = &RebootInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebootInstance API operation for Amazon Lightsail.
//
// Restarts a specific instance. When your Amazon Lightsail instance is finished
// rebooting, Lightsail assigns a new public IP address. To use the same IP
// address after restarting, create a static IP address and attach it to the
// instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation RebootInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootInstance
func (c *Lightsail) RebootInstance(input *RebootInstanceInput) (*RebootInstanceOutput, error) {
	req, out := c.RebootInstanceRequest(input)
	return out, req.Send()
}

// RebootInstanceWithContext is the same as RebootInstance with the addition of
// the ability to pass a context and additional request options.
//
// See RebootInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) RebootInstanceWithContext(ctx aws.Context, input *RebootInstanceInput, opts ...request.Option) (*RebootInstanceOutput, error) {
	req, out := c.RebootInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReleaseStaticIp = "ReleaseStaticIp"

// ReleaseStaticIpRequest generates a "aws/request.Request" representing the
// client's request for the ReleaseStaticIp operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ReleaseStaticIp for more information on using the ReleaseStaticIp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ReleaseStaticIpRequest method.
//    req, resp := client.ReleaseStaticIpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ReleaseStaticIp
func (c *Lightsail) ReleaseStaticIpRequest(input *ReleaseStaticIpInput) (req *request.Request, output *ReleaseStaticIpOutput) {
	op := &request.Operation{
		Name:       opReleaseStaticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReleaseStaticIpInput{}
	}

	output = &ReleaseStaticIpOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReleaseStaticIp API operation for Amazon Lightsail.
//
// Deletes a specific static IP from your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation ReleaseStaticIp for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ReleaseStaticIp
func (c *Lightsail) ReleaseStaticIp(input *ReleaseStaticIpInput) (*ReleaseStaticIpOutput, error) {
	req, out := c.ReleaseStaticIpRequest(input)
	return out, req.Send()
}

// ReleaseStaticIpWithContext is the same as ReleaseStaticIp with the addition of
// the ability to pass a context and additional request options.
//
// See ReleaseStaticIp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) ReleaseStaticIpWithContext(ctx aws.Context, input *ReleaseStaticIpInput, opts ...request.Option) (*ReleaseStaticIpOutput, error) {
	req, out := c.ReleaseStaticIpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartInstance = "StartInstance"

// StartInstanceRequest generates a "aws/request.Request" representing the
// client's request for the StartInstance operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartInstance for more information on using the StartInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartInstanceRequest method.
//    req, resp := client.StartInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartInstance
func (c *Lightsail) StartInstanceRequest(input *StartInstanceInput) (req *request.Request, output *StartInstanceOutput) {
	op := &request.Operation{
		Name:       opStartInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartInstanceInput{}
	}

	output = &StartInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartInstance API operation for Amazon Lightsail.
//
// Starts a specific Amazon Lightsail instance from a stopped state. To restart
// an instance, use the reboot instance operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation StartInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartInstance
func (c *Lightsail) StartInstance(input *StartInstanceInput) (*StartInstanceOutput, error) {
	req, out := c.StartInstanceRequest(input)
	return out, req.Send()
}

// StartInstanceWithContext is the same as StartInstance with the addition of
// the ability to pass a context and additional request options.
//
// See StartInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) StartInstanceWithContext(ctx aws.Context, input *StartInstanceInput, opts ...request.Option) (*StartInstanceOutput, error) {
	req, out := c.StartInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopInstance = "StopInstance"

// StopInstanceRequest generates a "aws/request.Request" representing the
// client's request for the StopInstance operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopInstance for more information on using the StopInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopInstanceRequest method.
//    req, resp := client.StopInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopInstance
func (c *Lightsail) StopInstanceRequest(input *StopInstanceInput) (req *request.Request, output *StopInstanceOutput) {
	op := &request.Operation{
		Name:       opStopInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopInstanceInput{}
	}

	output = &StopInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopInstance API operation for Amazon Lightsail.
//
// Stops a specific Amazon Lightsail instance that is currently running.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation StopInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopInstance
func (c *Lightsail) StopInstance(input *StopInstanceInput) (*StopInstanceOutput, error) {
	req, out := c.StopInstanceRequest(input)
	return out, req.Send()
}

// StopInstanceWithContext is the same as StopInstance with the addition of
// the ability to pass a context and additional request options.
//
// See StopInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) StopInstanceWithContext(ctx aws.Context, input *StopInstanceInput, opts ...request.Option) (*StopInstanceOutput, error) {
	req, out := c.StopInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUnpeerVpc = "UnpeerVpc"

// UnpeerVpcRequest generates a "aws/request.Request" representing the
// client's request for the UnpeerVpc operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UnpeerVpc for more information on using the UnpeerVpc
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UnpeerVpcRequest method.
//    req, resp := client.UnpeerVpcRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UnpeerVpc
func (c *Lightsail) UnpeerVpcRequest(input *UnpeerVpcInput) (req *request.Request, output *UnpeerVpcOutput) {
	op := &request.Operation{
		Name:       opUnpeerVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnpeerVpcInput{}
	}

	output = &UnpeerVpcOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UnpeerVpc API operation for Amazon Lightsail.
//
// Attempts to unpeer the Lightsail VPC from the user's default VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation UnpeerVpc for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UnpeerVpc
func (c *Lightsail) UnpeerVpc(input *UnpeerVpcInput) (*UnpeerVpcOutput, error) {
	req, out := c.UnpeerVpcRequest(input)
	return out, req.Send()
}

// UnpeerVpcWithContext is the same as UnpeerVpc with the addition of
// the ability to pass a context and additional request options.
//
// See UnpeerVpc for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) UnpeerVpcWithContext(ctx aws.Context, input *UnpeerVpcInput, opts ...request.Option) (*UnpeerVpcOutput, error) {
	req, out := c.UnpeerVpcRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDomainEntry = "UpdateDomainEntry"

// UpdateDomainEntryRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDomainEntry operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDomainEntry for more information on using the UpdateDomainEntry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDomainEntryRequest method.
//    req, resp := client.UpdateDomainEntryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDomainEntry
func (c *Lightsail) UpdateDomainEntryRequest(input *UpdateDomainEntryInput) (req *request.Request, output *UpdateDomainEntryOutput) {
	op := &request.Operation{
		Name:       opUpdateDomainEntry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDomainEntryInput{}
	}

	output = &UpdateDomainEntryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDomainEntry API operation for Amazon Lightsail.
//
// Updates a domain recordset after it is created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation UpdateDomainEntry for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your Region configuration to us-east-1 to create, view, or edit
//   these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDomainEntry
func (c *Lightsail) UpdateDomainEntry(input *UpdateDomainEntryInput) (*UpdateDomainEntryOutput, error) {
	req, out := c.UpdateDomainEntryRequest(input)
	return out, req.Send()
}

// UpdateDomainEntryWithContext is the same as UpdateDomainEntry with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDomainEntry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) UpdateDomainEntryWithContext(ctx aws.Context, input *UpdateDomainEntryInput, opts ...request.Option) (*UpdateDomainEntryOutput, error) {
	req, out := c.UpdateDomainEntryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AllocateStaticIpRequest
type AllocateStaticIpInput struct {
	_ struct{} `type:"structure"`

	// The name of the static IP address.
	//
	// StaticIpName is a required field
	StaticIpName *string `locationName:"staticIpName" type:"string" required:"true"`
}

// String returns the string representation
func (s AllocateStaticIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateStaticIpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllocateStaticIpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllocateStaticIpInput"}
	if s.StaticIpName == nil {
		invalidParams.Add(request.NewErrParamRequired("StaticIpName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStaticIpName sets the StaticIpName field's value.
func (s *AllocateStaticIpInput) SetStaticIpName(v string) *AllocateStaticIpInput {
	s.StaticIpName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AllocateStaticIpResult
type AllocateStaticIpOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the static IP address
	// you allocated.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s AllocateStaticIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateStaticIpOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *AllocateStaticIpOutput) SetOperations(v []*Operation) *AllocateStaticIpOutput {
	s.Operations = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachStaticIpRequest
type AttachStaticIpInput struct {
	_ struct{} `type:"structure"`

	// The instance name to which you want to attach the static IP address.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	// The name of the static IP.
	//
	// StaticIpName is a required field
	StaticIpName *string `locationName:"staticIpName" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachStaticIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachStaticIpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachStaticIpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachStaticIpInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}
	if s.StaticIpName == nil {
		invalidParams.Add(request.NewErrParamRequired("StaticIpName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *AttachStaticIpInput) SetInstanceName(v string) *AttachStaticIpInput {
	s.InstanceName = &v
	return s
}

// SetStaticIpName sets the StaticIpName field's value.
func (s *AttachStaticIpInput) SetStaticIpName(v string) *AttachStaticIpInput {
	s.StaticIpName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachStaticIpResult
type AttachStaticIpOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about your API operations.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s AttachStaticIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachStaticIpOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *AttachStaticIpOutput) SetOperations(v []*Operation) *AttachStaticIpOutput {
	s.Operations = v
	return s
}

// Describes an Availability Zone.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AvailabilityZone
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The state of the Availability Zone.
	State *string `locationName:"state" type:"string"`

	// The name of the Availability Zone. The format is us-east-1a (case-sensitive).
	ZoneName *string `locationName:"zoneName" type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *AvailabilityZone) SetState(v string) *AvailabilityZone {
	s.State = &v
	return s
}

// SetZoneName sets the ZoneName field's value.
func (s *AvailabilityZone) SetZoneName(v string) *AvailabilityZone {
	s.ZoneName = &v
	return s
}

// Describes a blueprint (a virtual private server image).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/Blueprint
type Blueprint struct {
	_ struct{} `type:"structure"`

	// The ID for the virtual private server image (e.g., app_wordpress_4_4 or app_lamp_7_0).
	BlueprintId *string `locationName:"blueprintId" type:"string"`

	// The description of the blueprint.
	Description *string `locationName:"description" type:"string"`

	// The group name of the blueprint (e.g., amazon-linux).
	Group *string `locationName:"group" type:"string"`

	// A Boolean value indicating whether the blueprint is active. When you update
	// your blueprints, you will inactivate old blueprints and keep the most recent
	// versions active.
	IsActive *bool `locationName:"isActive" type:"boolean"`

	// The end-user license agreement URL for the image or blueprint.
	LicenseUrl *string `locationName:"licenseUrl" type:"string"`

	// The minimum bundle power required to run this blueprint. For example, you
	// need a bundle with a power value of 500 or more to create an instance that
	// uses a blueprint with a minimum power value of 500. 0 indicates that the
	// blueprint runs on all instance sizes.
	MinPower *int64 `locationName:"minPower" type:"integer"`

	// The friendly name of the blueprint (e.g., Amazon Linux).
	Name *string `locationName:"name" type:"string"`

	// The operating system platform (either Linux/Unix-based or Windows Server-based)
	// of the blueprint.
	Platform *string `locationName:"platform" type:"string" enum:"InstancePlatform"`

	// The product URL to learn more about the image or blueprint.
	ProductUrl *string `locationName:"productUrl" type:"string"`

	// The type of the blueprint (e.g., os or app).
	Type *string `locationName:"type" type:"string" enum:"BlueprintType"`

	// The version number of the operating system, application, or stack (e.g.,
	// 2016.03.0).
	Version *string `locationName:"version" type:"string"`

	// The version code.
	VersionCode *string `locationName:"versionCode" type:"string"`
}

// String returns the string representation
func (s Blueprint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Blueprint) GoString() string {
	return s.String()
}

// SetBlueprintId sets the BlueprintId field's value.
func (s *Blueprint) SetBlueprintId(v string) *Blueprint {
	s.BlueprintId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Blueprint) SetDescription(v string) *Blueprint {
	s.Description = &v
	return s
}

// SetGroup sets the Group field's value.
func (s *Blueprint) SetGroup(v string) *Blueprint {
	s.Group = &v
	return s
}

// SetIsActive sets the IsActive field's value.
func (s *Blueprint) SetIsActive(v bool) *Blueprint {
	s.IsActive = &v
	return s
}

// SetLicenseUrl sets the LicenseUrl field's value.
func (s *Blueprint) SetLicenseUrl(v string) *Blueprint {
	s.LicenseUrl = &v
	return s
}

// SetMinPower sets the MinPower field's value.
func (s *Blueprint) SetMinPower(v int64) *Blueprint {
	s.MinPower = &v
	return s
}

// SetName sets the Name field's value.
func (s *Blueprint) SetName(v string) *Blueprint {
	s.Name = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *Blueprint) SetPlatform(v string) *Blueprint {
	s.Platform = &v
	return s
}

// SetProductUrl sets the ProductUrl field's value.
func (s *Blueprint) SetProductUrl(v string) *Blueprint {
	s.ProductUrl = &v
	return s
}

// SetType sets the Type field's value.
func (s *Blueprint) SetType(v string) *Blueprint {
	s.Type = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *Blueprint) SetVersion(v string) *Blueprint {
	s.Version = &v
	return s
}

// SetVersionCode sets the VersionCode field's value.
func (s *Blueprint) SetVersionCode(v string) *Blueprint {
	s.VersionCode = &v
	return s
}

// Describes a bundle, which is a set of specs describing your virtual private
// server (or instance).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/Bundle
type Bundle struct {
	_ struct{} `type:"structure"`

	// The bundle ID (e.g., micro_1_0).
	BundleId *string `locationName:"bundleId" type:"string"`

	// The number of vCPUs included in the bundle (e.g., 2).
	CpuCount *int64 `locationName:"cpuCount" type:"integer"`

	// The size of the SSD (e.g., 30).
	DiskSizeInGb *int64 `locationName:"diskSizeInGb" type:"integer"`

	// The Amazon EC2 instance type (e.g., t2.micro).
	InstanceType *string `locationName:"instanceType" type:"string"`

	// A Boolean value indicating whether the bundle is active.
	IsActive *bool `locationName:"isActive" type:"boolean"`

	// A friendly name for the bundle (e.g., Micro).
	Name *string `locationName:"name" type:"string"`

	// A numeric value that represents the power of the bundle (e.g., 500). You
	// can use the bundle's power value in conjunction with a blueprint's minimum
	// power value to determine whether the blueprint will run on the bundle. For
	// example, you need a bundle with a power value of 500 or more to create an
	// instance that uses a blueprint with a minimum power value of 500.
	Power *int64 `locationName:"power" type:"integer"`

	// The price in US dollars (e.g., 5.0).
	Price *float64 `locationName:"price" type:"float"`

	// The amount of RAM in GB (e.g., 2.0).
	RamSizeInGb *float64 `locationName:"ramSizeInGb" type:"float"`

	// The operating system platform (Linux/Unix-based or Windows Server-based)
	// that the bundle supports. You can only launch a WINDOWS bundle on a blueprint
	// that supports the WINDOWS platform. LINUX_UNIX blueprints require a LINUX_UNIX
	// bundle.
	SupportedPlatforms []*string `locationName:"supportedPlatforms" type:"list"`

	// The data transfer rate per month in GB (e.g., 2000).
	TransferPerMonthInGb *int64 `locationName:"transferPerMonthInGb" type:"integer"`
}

// String returns the string representation
func (s Bundle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Bundle) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *Bundle) SetBundleId(v string) *Bundle {
	s.BundleId = &v
	return s
}

// SetCpuCount sets the CpuCount field's value.
func (s *Bundle) SetCpuCount(v int64) *Bundle {
	s.CpuCount = &v
	return s
}

// SetDiskSizeInGb sets the DiskSizeInGb field's value.
func (s *Bundle) SetDiskSizeInGb(v int64) *Bundle {
	s.DiskSizeInGb = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *Bundle) SetInstanceType(v string) *Bundle {
	s.InstanceType = &v
	return s
}

// SetIsActive sets the IsActive field's value.
func (s *Bundle) SetIsActive(v bool) *Bundle {
	s.IsActive = &v
	return s
}

// SetName sets the Name field's value.
func (s *Bundle) SetName(v string) *Bundle {
	s.Name = &v
	return s
}

// SetPower sets the Power field's value.
func (s *Bundle) SetPower(v int64) *Bundle {
	s.Power = &v
	return s
}

// SetPrice sets the Price field's value.
func (s *Bundle) SetPrice(v float64) *Bundle {
	s.Price = &v
	return s
}

// SetRamSizeInGb sets the RamSizeInGb field's value.
func (s *Bundle) SetRamSizeInGb(v float64) *Bundle {
	s.RamSizeInGb = &v
	return s
}

// SetSupportedPlatforms sets the SupportedPlatforms field's value.
func (s *Bundle) SetSupportedPlatforms(v []*string) *Bundle {
	s.SupportedPlatforms = v
	return s
}

// SetTransferPerMonthInGb sets the TransferPerMonthInGb field's value.
func (s *Bundle) SetTransferPerMonthInGb(v int64) *Bundle {
	s.TransferPerMonthInGb = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CloseInstancePublicPortsRequest
type CloseInstancePublicPortsInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance on which you're attempting to close the public ports.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	// Information about the public port you are trying to close.
	//
	// PortInfo is a required field
	PortInfo *PortInfo `locationName:"portInfo" type:"structure" required:"true"`
}

// String returns the string representation
func (s CloseInstancePublicPortsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloseInstancePublicPortsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloseInstancePublicPortsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloseInstancePublicPortsInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}
	if s.PortInfo == nil {
		invalidParams.Add(request.NewErrParamRequired("PortInfo"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *CloseInstancePublicPortsInput) SetInstanceName(v string) *CloseInstancePublicPortsInput {
	s.InstanceName = &v
	return s
}

// SetPortInfo sets the PortInfo field's value.
func (s *CloseInstancePublicPortsInput) SetPortInfo(v *PortInfo) *CloseInstancePublicPortsInput {
	s.PortInfo = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CloseInstancePublicPortsResult
type CloseInstancePublicPortsOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs that contains information about the operation.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s CloseInstancePublicPortsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloseInstancePublicPortsOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *CloseInstancePublicPortsOutput) SetOperation(v *Operation) *CloseInstancePublicPortsOutput {
	s.Operation = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomainEntryRequest
type CreateDomainEntryInput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the domain entry
	// request.
	//
	// DomainEntry is a required field
	DomainEntry *DomainEntry `locationName:"domainEntry" type:"structure" required:"true"`

	// The domain name (e.g., example.com) for which you want to create the domain
	// entry.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDomainEntryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainEntryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainEntryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDomainEntryInput"}
	if s.DomainEntry == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainEntry"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainEntry sets the DomainEntry field's value.
func (s *CreateDomainEntryInput) SetDomainEntry(v *DomainEntry) *CreateDomainEntryInput {
	s.DomainEntry = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateDomainEntryInput) SetDomainName(v string) *CreateDomainEntryInput {
	s.DomainName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomainEntryResult
type CreateDomainEntryOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the operation.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s CreateDomainEntryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainEntryOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *CreateDomainEntryOutput) SetOperation(v *Operation) *CreateDomainEntryOutput {
	s.Operation = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomainRequest
type CreateDomainInput struct {
	_ struct{} `type:"structure"`

	// The domain name to manage (e.g., example.com).
	//
	// You cannot register a new domain name using Lightsail. You must register
	// a domain name using Amazon Route 53 or another domain name registrar. If
	// you have already registered your domain, you can enter its name in this parameter
	// to manage the DNS records for that domain.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *CreateDomainInput) SetDomainName(v string) *CreateDomainInput {
	s.DomainName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomainResult
type CreateDomainOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the domain resource
	// you created.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s CreateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *CreateDomainOutput) SetOperation(v *Operation) *CreateDomainOutput {
	s.Operation = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstanceSnapshotRequest
type CreateInstanceSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The Lightsail instance on which to base your snapshot.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	// The name for your new snapshot.
	//
	// InstanceSnapshotName is a required field
	InstanceSnapshotName *string `locationName:"instanceSnapshotName" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateInstanceSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstanceSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInstanceSnapshotInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}
	if s.InstanceSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *CreateInstanceSnapshotInput) SetInstanceName(v string) *CreateInstanceSnapshotInput {
	s.InstanceName = &v
	return s
}

// SetInstanceSnapshotName sets the InstanceSnapshotName field's value.
func (s *CreateInstanceSnapshotInput) SetInstanceSnapshotName(v string) *CreateInstanceSnapshotInput {
	s.InstanceSnapshotName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstanceSnapshotResult
type CreateInstanceSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// create instances snapshot request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateInstanceSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceSnapshotOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateInstanceSnapshotOutput) SetOperations(v []*Operation) *CreateInstanceSnapshotOutput {
	s.Operations = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstancesFromSnapshotRequest
type CreateInstancesFromSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone where you want to create your instances. Use the following
	// formatting: us-east-1a (case sensitive). You can get a list of availability
	// zones by using the get regions (http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html)
	// operation. Be sure to add the include availability zones parameter to your
	// request.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// The bundle of specification information for your virtual private server (or
	// instance), including the pricing plan (e.g., micro_1_0).
	//
	// BundleId is a required field
	BundleId *string `locationName:"bundleId" type:"string" required:"true"`

	// The names for your new instances.
	//
	// InstanceNames is a required field
	InstanceNames []*string `locationName:"instanceNames" type:"list" required:"true"`

	// The name of the instance snapshot on which you are basing your new instances.
	// Use the get instance snapshots operation to return information about your
	// existing snapshots.
	//
	// InstanceSnapshotName is a required field
	InstanceSnapshotName *string `locationName:"instanceSnapshotName" type:"string" required:"true"`

	// The name for your key pair.
	KeyPairName *string `locationName:"keyPairName" type:"string"`

	// You can create a launch script that configures a server with additional user
	// data. For example, apt-get –y update.
	//
	// Depending on the machine image you choose, the command to get software on
	// your instance varies. Amazon Linux and CentOS use yum, Debian and Ubuntu
	// use apt-get, and FreeBSD uses pkg. For a complete list, see the Dev Guide
	// (http://lightsail.aws.amazon.com/ls/docs/getting-started/articles/pre-installed-apps).
	UserData *string `locationName:"userData" type:"string"`
}

// String returns the string representation
func (s CreateInstancesFromSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstancesFromSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstancesFromSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInstancesFromSnapshotInput"}
	if s.AvailabilityZone == nil {
		invalidParams.Add(request.NewErrParamRequired("AvailabilityZone"))
	}
	if s.BundleId == nil {
		invalidParams.Add(request.NewErrParamRequired("BundleId"))
	}
	if s.InstanceNames == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceNames"))
	}
	if s.InstanceSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateInstancesFromSnapshotInput) SetAvailabilityZone(v string) *CreateInstancesFromSnapshotInput {
	s.AvailabilityZone = &v
	return s
}

// SetBundleId sets the BundleId field's value.
func (s *CreateInstancesFromSnapshotInput) SetBundleId(v string) *CreateInstancesFromSnapshotInput {
	s.BundleId = &v
	return s
}

// SetInstanceNames sets the InstanceNames field's value.
func (s *CreateInstancesFromSnapshotInput) SetInstanceNames(v []*string) *CreateInstancesFromSnapshotInput {
	s.InstanceNames = v
	return s
}

// SetInstanceSnapshotName sets the InstanceSnapshotName field's value.
func (s *CreateInstancesFromSnapshotInput) SetInstanceSnapshotName(v string) *CreateInstancesFromSnapshotInput {
	s.InstanceSnapshotName = &v
	return s
}

// SetKeyPairName sets the KeyPairName field's value.
func (s *CreateInstancesFromSnapshotInput) SetKeyPairName(v string) *CreateInstancesFromSnapshotInput {
	s.KeyPairName = &v
	return s
}

// SetUserData sets the UserData field's value.
func (s *CreateInstancesFromSnapshotInput) SetUserData(v string) *CreateInstancesFromSnapshotInput {
	s.UserData = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstancesFromSnapshotResult
type CreateInstancesFromSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// create instances from snapshot request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateInstancesFromSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstancesFromSnapshotOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateInstancesFromSnapshotOutput) SetOperations(v []*Operation) *CreateInstancesFromSnapshotOutput {
	s.Operations = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstancesRequest
type CreateInstancesInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which to create your instance. Use the following
	// format: us-east-1a (case sensitive). You can get a list of availability zones
	// by using the get regions (http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html)
	// operation. Be sure to add the include availability zones parameter to your
	// request.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// The ID for a virtual private server image (e.g., app_wordpress_4_4 or app_lamp_7_0).
	// Use the get blueprints operation to return a list of available images (or
	// blueprints).
	//
	// BlueprintId is a required field
	BlueprintId *string `locationName:"blueprintId" type:"string" required:"true"`

	// The bundle of specification information for your virtual private server (or
	// instance), including the pricing plan (e.g., micro_1_0).
	//
	// BundleId is a required field
	BundleId *string `locationName:"bundleId" type:"string" required:"true"`

	// (Deprecated) The name for your custom image.
	//
	// In releases prior to June 12, 2017, this parameter was ignored by the API.
	// It is now deprecated.
	CustomImageName *string `locationName:"customImageName" deprecated:"true" type:"string"`

	// The names to use for your new Lightsail instances. Separate multiple values
	// using quotation marks and commas, for example: ["MyFirstInstance","MySecondInstance"]
	//
	// InstanceNames is a required field
	InstanceNames []*string `locationName:"instanceNames" type:"list" required:"true"`

	// The name of your key pair.
	KeyPairName *string `locationName:"keyPairName" type:"string"`

	// A launch script you can create that configures a server with additional user
	// data. For example, you might want to run apt-get –y update.
	//
	// Depending on the machine image you choose, the command to get software on
	// your instance varies. Amazon Linux and CentOS use yum, Debian and Ubuntu
	// use apt-get, and FreeBSD uses pkg. For a complete list, see the Dev Guide
	// (https://lightsail.aws.amazon.com/ls/docs/getting-started/article/compare-options-choose-lightsail-instance-image).
	UserData *string `locationName:"userData" type:"string"`
}

// String returns the string representation
func (s CreateInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInstancesInput"}
	if s.AvailabilityZone == nil {
		invalidParams.Add(request.NewErrParamRequired("AvailabilityZone"))
	}
	if s.BlueprintId == nil {
		invalidParams.Add(request.NewErrParamRequired("BlueprintId"))
	}
	if s.BundleId == nil {
		invalidParams.Add(request.NewErrParamRequired("BundleId"))
	}
	if s.InstanceNames == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateInstancesInput) SetAvailabilityZone(v string) *CreateInstancesInput {
	s.AvailabilityZone = &v
	return s
}

// SetBlueprintId sets the BlueprintId field's value.
func (s *CreateInstancesInput) SetBlueprintId(v string) *CreateInstancesInput {
	s.BlueprintId = &v
	return s
}

// SetBundleId sets the BundleId field's value.
func (s *CreateInstancesInput) SetBundleId(v string) *CreateInstancesInput {
	s.BundleId = &v
	return s
}

// SetCustomImageName sets the CustomImageName field's value.
func (s *CreateInstancesInput) SetCustomImageName(v string) *CreateInstancesInput {
	s.CustomImageName = &v
	return s
}

// SetInstanceNames sets the InstanceNames field's value.
func (s *CreateInstancesInput) SetInstanceNames(v []*string) *CreateInstancesInput {
	s.InstanceNames = v
	return s
}

// SetKeyPairName sets the KeyPairName field's value.
func (s *CreateInstancesInput) SetKeyPairName(v string) *CreateInstancesInput {
	s.KeyPairName = &v
	return s
}

// SetUserData sets the UserData field's value.
func (s *CreateInstancesInput) SetUserData(v string) *CreateInstancesInput {
	s.UserData = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstancesResult
type CreateInstancesOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// create instances request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstancesOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateInstancesOutput) SetOperations(v []*Operation) *CreateInstancesOutput {
	s.Operations = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateKeyPairRequest
type CreateKeyPairInput struct {
	_ struct{} `type:"structure"`

	// The name for your new key pair.
	//
	// KeyPairName is a required field
	KeyPairName *string `locationName:"keyPairName" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeyPairInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKeyPairInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKeyPairInput"}
	if s.KeyPairName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyPairName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyPairName sets the KeyPairName field's value.
func (s *CreateKeyPairInput) SetKeyPairName(v string) *CreateKeyPairInput {
	s.KeyPairName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateKeyPairResult
type CreateKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the new key pair
	// you just created.
	KeyPair *KeyPair `locationName:"keyPair" type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// create key pair request.
	Operation *Operation `locationName:"operation" type:"structure"`

	// A base64-encoded RSA private key.
	PrivateKeyBase64 *string `locationName:"privateKeyBase64" type:"string"`

	// A base64-encoded public key of the ssh-rsa type.
	PublicKeyBase64 *string `locationName:"publicKeyBase64" type:"string"`
}

// String returns the string representation
func (s CreateKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeyPairOutput) GoString() string {
	return s.String()
}

// SetKeyPair sets the KeyPair field's value.
func (s *CreateKeyPairOutput) SetKeyPair(v *KeyPair) *CreateKeyPairOutput {
	s.KeyPair = v
	return s
}

// SetOperation sets the Operation field's value.
func (s *CreateKeyPairOutput) SetOperation(v *Operation) *CreateKeyPairOutput {
	s.Operation = v
	return s
}

// SetPrivateKeyBase64 sets the PrivateKeyBase64 field's value.
func (s *CreateKeyPairOutput) SetPrivateKeyBase64(v string) *CreateKeyPairOutput {
	s.PrivateKeyBase64 = &v
	return s
}

// SetPublicKeyBase64 sets the PublicKeyBase64 field's value.
func (s *CreateKeyPairOutput) SetPublicKeyBase64(v string) *CreateKeyPairOutput {
	s.PublicKeyBase64 = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomainEntryRequest
type DeleteDomainEntryInput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about your domain entries.
	//
	// DomainEntry is a required field
	DomainEntry *DomainEntry `locationName:"domainEntry" type:"structure" required:"true"`

	// The name of the domain entry to delete.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDomainEntryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainEntryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainEntryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDomainEntryInput"}
	if s.DomainEntry == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainEntry"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainEntry sets the DomainEntry field's value.
func (s *DeleteDomainEntryInput) SetDomainEntry(v *DomainEntry) *DeleteDomainEntryInput {
	s.DomainEntry = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteDomainEntryInput) SetDomainName(v string) *DeleteDomainEntryInput {
	s.DomainName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomainEntryResult
type DeleteDomainEntryOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// delete domain entry request.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s DeleteDomainEntryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainEntryOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *DeleteDomainEntryOutput) SetOperation(v *Operation) *DeleteDomainEntryOutput {
	s.Operation = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomainRequest
type DeleteDomainInput struct {
	_ struct{} `type:"structure"`

	// The specific domain name to delete.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteDomainInput) SetDomainName(v string) *DeleteDomainInput {
	s.DomainName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomainResult
type DeleteDomainOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// delete domain request.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s DeleteDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *DeleteDomainOutput) SetOperation(v *Operation) *DeleteDomainOutput {
	s.Operation = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstanceRequest
type DeleteInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance to delete.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInstanceInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *DeleteInstanceInput) SetInstanceName(v string) *DeleteInstanceInput {
	s.InstanceName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstanceResult
type DeleteInstanceOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// delete instance request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInstanceOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteInstanceOutput) SetOperations(v []*Operation) *DeleteInstanceOutput {
	s.Operations = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstanceSnapshotRequest
type DeleteInstanceSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of the snapshot to delete.
	//
	// InstanceSnapshotName is a required field
	InstanceSnapshotName *string `locationName:"instanceSnapshotName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInstanceSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInstanceSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInstanceSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInstanceSnapshotInput"}
	if s.InstanceSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceSnapshotName sets the InstanceSnapshotName field's value.
func (s *DeleteInstanceSnapshotInput) SetInstanceSnapshotName(v string) *DeleteInstanceSnapshotInput {
	s.InstanceSnapshotName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstanceSnapshotResult
type DeleteInstanceSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// delete instance snapshot request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteInstanceSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInstanceSnapshotOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteInstanceSnapshotOutput) SetOperations(v []*Operation) *DeleteInstanceSnapshotOutput {
	s.Operations = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteKeyPairRequest
type DeleteKeyPairInput struct {
	_ struct{} `type:"structure"`

	// The name of the key pair to delete.
	//
	// KeyPairName is a required field
	KeyPairName *string `locationName:"keyPairName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteKeyPairInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKeyPairInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteKeyPairInput"}
	if s.KeyPairName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyPairName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyPairName sets the KeyPairName field's value.
func (s *DeleteKeyPairInput) SetKeyPairName(v string) *DeleteKeyPairInput {
	s.KeyPairName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteKeyPairResult
type DeleteKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// delete key pair request.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s DeleteKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteKeyPairOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *DeleteKeyPairOutput) SetOperation(v *Operation) *DeleteKeyPairOutput {
	s.Operation = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachStaticIpRequest
type DetachStaticIpInput struct {
	_ struct{} `type:"structure"`

	// The name of the static IP to detach from the instance.
	//
	// StaticIpName is a required field
	StaticIpName *string `locationName:"staticIpName" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachStaticIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachStaticIpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachStaticIpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachStaticIpInput"}
	if s.StaticIpName == nil {
		invalidParams.Add(request.NewErrParamRequired("StaticIpName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStaticIpName sets the StaticIpName field's value.
func (s *DetachStaticIpInput) SetStaticIpName(v string) *DetachStaticIpInput {
	s.StaticIpName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachStaticIpResult
type DetachStaticIpOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// detach static IP request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DetachStaticIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachStaticIpOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DetachStaticIpOutput) SetOperations(v []*Operation) *DetachStaticIpOutput {
	s.Operations = v
	return s
}

// Describes the hard disk (an SSD).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/Disk
type Disk struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the disk.
	Arn *string `locationName:"arn" type:"string"`

	// The resources to which the disk is attached.
	AttachedTo *string `locationName:"attachedTo" type:"string"`

	// The attachment state of the disk.
	AttachmentState *string `locationName:"attachmentState" type:"string"`

	// The date when the disk was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"unix"`

	// The number of GB in use by the disk.
	GbInUse *int64 `locationName:"gbInUse" type:"integer"`

	// The input/output operations per second (IOPS) of the disk.
	Iops *int64 `locationName:"iops" type:"integer"`

	// A Boolean value indicating whether the disk is attached.
	IsAttached *bool `locationName:"isAttached" type:"boolean"`

	// A Boolean value indicating whether this disk is a system disk (has an operating
	// system loaded on it).
	IsSystemDisk *bool `locationName:"isSystemDisk" type:"boolean"`

	// The region and Availability Zone where the disk is located.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The name of the disk.
	Name *string `locationName:"name" type:"string"`

	// The disk path.
	Path *string `locationName:"path" type:"string"`

	// The resource type of the disk.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The size of the disk in GB.
	SizeInGb *int64 `locationName:"sizeInGb" type:"integer"`

	// The support code. Include this code in your email to support when you have
	// questions about an instance or another resource in Lightsail. This code enables
	// our support team to look up your Lightsail information more easily.
	SupportCode *string `locationName:"supportCode" type:"string"`
}

// String returns the string representation
func (s Disk) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Disk) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Disk) SetArn(v string) *Disk {
	s.Arn = &v
	return s
}

// SetAttachedTo sets the AttachedTo field's value.
func (s *Disk) SetAttachedTo(v string) *Disk {
	s.AttachedTo = &v
	return s
}

// SetAttachmentState sets the AttachmentState field's value.
func (s *Disk) SetAttachmentState(v string) *Disk {
	s.AttachmentState = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Disk) SetCreatedAt(v time.Time) *Disk {
	s.CreatedAt = &v
	return s
}

// SetGbInUse sets the GbInUse field's value.
func (s *Disk) SetGbInUse(v int64) *Disk {
	s.GbInUse = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *Disk) SetIops(v int64) *Disk {
	s.Iops = &v
	return s
}

// SetIsAttached sets the IsAttached field's value.
func (s *Disk) SetIsAttached(v bool) *Disk {
	s.IsAttached = &v
	return s
}

// SetIsSystemDisk sets the IsSystemDisk field's value.
func (s *Disk) SetIsSystemDisk(v bool) *Disk {
	s.IsSystemDisk = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *Disk) SetLocation(v *ResourceLocation) *Disk {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *Disk) SetName(v string) *Disk {
	s.Name = &v
	return s
}

// SetPath sets the Path field's value.
func (s *Disk) SetPath(v string) *Disk {
	s.Path = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Disk) SetResourceType(v string) *Disk {
	s.ResourceType = &v
	return s
}

// SetSizeInGb sets the SizeInGb field's value.
func (s *Disk) SetSizeInGb(v int64) *Disk {
	s.SizeInGb = &v
	return s
}

// SetSupportCode sets the SupportCode field's value.
func (s *Disk) SetSupportCode(v string) *Disk {
	s.SupportCode = &v
	return s
}

// Describes a domain where you are storing recordsets in Lightsail.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/Domain
type Domain struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the domain recordset (e.g., arn:aws:lightsail:global:123456789101:Domain/824cede0-abc7-4f84-8dbc-12345EXAMPLE).
	Arn *string `locationName:"arn" type:"string"`

	// The date when the domain recordset was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"unix"`

	// An array of key-value pairs containing information about the domain entries.
	DomainEntries []*DomainEntry `locationName:"domainEntries" type:"list"`

	// The AWS Region and Availability Zones where the domain recordset was created.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The name of the domain.
	Name *string `locationName:"name" type:"string"`

	// The resource type.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The support code. Include this code in your email to support when you have
	// questions about an instance or another resource in Lightsail. This code enables
	// our support team to look up your Lightsail information more easily.
	SupportCode *string `locationName:"supportCode" type:"string"`
}

// String returns the string representation
func (s Domain) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Domain) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Domain) SetArn(v string) *Domain {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Domain) SetCreatedAt(v time.Time) *Domain {
	s.CreatedAt = &v
	return s
}

// SetDomainEntries sets the DomainEntries field's value.
func (s *Domain) SetDomainEntries(v []*DomainEntry) *Domain {
	s.DomainEntries = v
	return s
}

// SetLocation sets the Location field's value.
func (s *Domain) SetLocation(v *ResourceLocation) *Domain {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *Domain) SetName(v string) *Domain {
	s.Name = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Domain) SetResourceType(v string) *Domain {
	s.ResourceType = &v
	return s
}

// SetSupportCode sets the SupportCode field's value.
func (s *Domain) SetSupportCode(v string) *Domain {
	s.SupportCode = &v
	return s
}

// Describes a domain recordset entry.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DomainEntry
type DomainEntry struct {
	_ struct{} `type:"structure"`

	// The ID of the domain recordset entry.
	Id *string `locationName:"id" type:"string"`

	// The name of the domain.
	Name *string `locationName:"name" type:"string"`

	// The options for the domain entry.
	Options map[string]*string `locationName:"options" type:"map"`

	// The target AWS name server (e.g., ns-111.awsdns-22.com.).
	Target *string `locationName:"target" type:"string"`

	// The type of domain entry (e.g., SOA or NS).
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s DomainEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainEntry) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *DomainEntry) SetId(v string) *DomainEntry {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *DomainEntry) SetName(v string) *DomainEntry {
	s.Name = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *DomainEntry) SetOptions(v map[string]*string) *DomainEntry {
	s.Options = v
	return s
}

// SetTarget sets the Target field's value.
func (s *DomainEntry) SetTarget(v string) *DomainEntry {
	s.Target = &v
	return s
}

// SetType sets the Type field's value.
func (s *DomainEntry) SetType(v string) *DomainEntry {
	s.Type = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DownloadDefaultKeyPairRequest
type DownloadDefaultKeyPairInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DownloadDefaultKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DownloadDefaultKeyPairInput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DownloadDefaultKeyPairResult
type DownloadDefaultKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// A base64-encoded RSA private key.
	PrivateKeyBase64 *string `locationName:"privateKeyBase64" type:"string"`

	// A base64-encoded public key of the ssh-rsa type.
	PublicKeyBase64 *string `locationName:"publicKeyBase64" type:"string"`
}

// String returns the string representation
func (s DownloadDefaultKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DownloadDefaultKeyPairOutput) GoString() string {
	return s.String()
}

// SetPrivateKeyBase64 sets the PrivateKeyBase64 field's value.
func (s *DownloadDefaultKeyPairOutput) SetPrivateKeyBase64(v string) *DownloadDefaultKeyPairOutput {
	s.PrivateKeyBase64 = &v
	return s
}

// SetPublicKeyBase64 sets the PublicKeyBase64 field's value.
func (s *DownloadDefaultKeyPairOutput) SetPublicKeyBase64(v string) *DownloadDefaultKeyPairOutput {
	s.PublicKeyBase64 = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetActiveNamesRequest
type GetActiveNamesInput struct {
	_ struct{} `type:"structure"`

	// A token used for paginating results from your get active names request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetActiveNamesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetActiveNamesInput) GoString() string {
	return s.String()
}

// SetPageToken sets the PageToken field's value.
func (s *GetActiveNamesInput) SetPageToken(v string) *GetActiveNamesInput {
	s.PageToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetActiveNamesResult
type GetActiveNamesOutput struct {
	_ struct{} `type:"structure"`

	// The list of active names returned by the get active names request.
	ActiveNames []*string `locationName:"activeNames" type:"list"`

	// A token used for advancing to the next page of results from your get active
	// names request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetActiveNamesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetActiveNamesOutput) GoString() string {
	return s.String()
}

// SetActiveNames sets the ActiveNames field's value.
func (s *GetActiveNamesOutput) SetActiveNames(v []*string) *GetActiveNamesOutput {
	s.ActiveNames = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetActiveNamesOutput) SetNextPageToken(v string) *GetActiveNamesOutput {
	s.NextPageToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBlueprintsRequest
type GetBlueprintsInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value indicating whether to include inactive results in your request.
	IncludeInactive *bool `locationName:"includeInactive" type:"boolean"`

	// A token used for advancing to the next page of results from your get blueprints
	// request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetBlueprintsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBlueprintsInput) GoString() string {
	return s.String()
}

// SetIncludeInactive sets the IncludeInactive field's value.
func (s *GetBlueprintsInput) SetIncludeInactive(v bool) *GetBlueprintsInput {
	s.IncludeInactive = &v
	return s
}

// SetPageToken sets the PageToken field's value.
func (s *GetBlueprintsInput) SetPageToken(v string) *GetBlueprintsInput {
	s.PageToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBlueprintsResult
type GetBlueprintsOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs that contains information about the available
	// blueprints.
	Blueprints []*Blueprint `locationName:"blueprints" type:"list"`

	// A token used for advancing to the next page of results from your get blueprints
	// request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetBlueprintsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBlueprintsOutput) GoString() string {
	return s.String()
}

// SetBlueprints sets the Blueprints field's value.
func (s *GetBlueprintsOutput) SetBlueprints(v []*Blueprint) *GetBlueprintsOutput {
	s.Blueprints = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetBlueprintsOutput) SetNextPageToken(v string) *GetBlueprintsOutput {
	s.NextPageToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBundlesRequest
type GetBundlesInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value that indicates whether to include inactive bundle results
	// in your request.
	IncludeInactive *bool `locationName:"includeInactive" type:"boolean"`

	// A token used for advancing to the next page of results from your get bundles
	// request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetBundlesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBundlesInput) GoString() string {
	return s.String()
}

// SetIncludeInactive sets the IncludeInactive field's value.
func (s *GetBundlesInput) SetIncludeInactive(v bool) *GetBundlesInput {
	s.IncludeInactive = &v
	return s
}

// SetPageToken sets the PageToken field's value.
func (s *GetBundlesInput) SetPageToken(v string) *GetBundlesInput {
	s.PageToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBundlesResult
type GetBundlesOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs that contains information about the available
	// bundles.
	Bundles []*Bundle `locationName:"bundles" type:"list"`

	// A token used for advancing to the next page of results from your get active
	// names request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetBundlesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBundlesOutput) GoString() string {
	return s.String()
}

// SetBundles sets the Bundles field's value.
func (s *GetBundlesOutput) SetBundles(v []*Bundle) *GetBundlesOutput {
	s.Bundles = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetBundlesOutput) SetNextPageToken(v string) *GetBundlesOutput {
	s.NextPageToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomainRequest
type GetDomainInput struct {
	_ struct{} `type:"structure"`

	// The domain name for which your want to return information about.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetDomainInput) SetDomainName(v string) *GetDomainInput {
	s.DomainName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomainResult
type GetDomainOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about your get domain
	// request.
	Domain *Domain `locationName:"domain" type:"structure"`
}

// String returns the string representation
func (s GetDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainOutput) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *GetDomainOutput) SetDomain(v *Domain) *GetDomainOutput {
	s.Domain = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomainsRequest
type GetDomainsInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get domains
	// request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainsInput) GoString() string {
	return s.String()
}

// SetPageToken sets the PageToken field's value.
func (s *GetDomainsInput) SetPageToken(v string) *GetDomainsInput {
	s.PageToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomainsResult
type GetDomainsOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about each of the domain
	// entries in the user's account.
	Domains []*Domain `locationName:"domains" type:"list"`

	// A token used for advancing to the next page of results from your get active
	// names request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainsOutput) GoString() string {
	return s.String()
}

// SetDomains sets the Domains field's value.
func (s *GetDomainsOutput) SetDomains(v []*Domain) *GetDomainsOutput {
	s.Domains = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetDomainsOutput) SetNextPageToken(v string) *GetDomainsOutput {
	s.NextPageToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceAccessDetailsRequest
type GetInstanceAccessDetailsInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance to access.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	// The protocol to use to connect to your instance. Defaults to ssh.
	Protocol *string `locationName:"protocol" type:"string" enum:"InstanceAccessProtocol"`
}

// String returns the string representation
func (s GetInstanceAccessDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceAccessDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstanceAccessDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInstanceAccessDetailsInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *GetInstanceAccessDetailsInput) SetInstanceName(v string) *GetInstanceAccessDetailsInput {
	s.InstanceName = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *GetInstanceAccessDetailsInput) SetProtocol(v string) *GetInstanceAccessDetailsInput {
	s.Protocol = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceAccessDetailsResult
type GetInstanceAccessDetailsOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about a get instance access
	// request.
	AccessDetails *InstanceAccessDetails `locationName:"accessDetails" type:"structure"`
}

// String returns the string representation
func (s GetInstanceAccessDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceAccessDetailsOutput) GoString() string {
	return s.String()
}

// SetAccessDetails sets the AccessDetails field's value.
func (s *GetInstanceAccessDetailsOutput) SetAccessDetails(v *InstanceAccessDetails) *GetInstanceAccessDetailsOutput {
	s.AccessDetails = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceRequest
type GetInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInstanceInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *GetInstanceInput) SetInstanceName(v string) *GetInstanceInput {
	s.InstanceName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceMetricDataRequest
type GetInstanceMetricDataInput struct {
	_ struct{} `type:"structure"`

	// The end time of the time period.
	//
	// EndTime is a required field
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"unix" required:"true"`

	// The name of the instance for which you want to get metrics data.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	// The metric name to get data about.
	//
	// MetricName is a required field
	MetricName *string `locationName:"metricName" type:"string" required:"true" enum:"InstanceMetricName"`

	// The time period for which you are requesting data.
	//
	// Period is a required field
	Period *int64 `locationName:"period" min:"60" type:"integer" required:"true"`

	// The start time of the time period.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"unix" required:"true"`

	// The instance statistics.
	//
	// Statistics is a required field
	Statistics []*string `locationName:"statistics" type:"list" required:"true"`

	// The unit. The list of valid values is below.
	//
	// Unit is a required field
	Unit *string `locationName:"unit" type:"string" required:"true" enum:"MetricUnit"`
}

// String returns the string representation
func (s GetInstanceMetricDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceMetricDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstanceMetricDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInstanceMetricDataInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.Period == nil {
		invalidParams.Add(request.NewErrParamRequired("Period"))
	}
	if s.Period != nil && *s.Period < 60 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 60))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.Statistics == nil {
		invalidParams.Add(request.NewErrParamRequired("Statistics"))
	}
	if s.Unit == nil {
		invalidParams.Add(request.NewErrParamRequired("Unit"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *GetInstanceMetricDataInput) SetEndTime(v time.Time) *GetInstanceMetricDataInput {
	s.EndTime = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *GetInstanceMetricDataInput) SetInstanceName(v string) *GetInstanceMetricDataInput {
	s.InstanceName = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *GetInstanceMetricDataInput) SetMetricName(v string) *GetInstanceMetricDataInput {
	s.MetricName = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *GetInstanceMetricDataInput) SetPeriod(v int64) *GetInstanceMetricDataInput {
	s.Period = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetInstanceMetricDataInput) SetStartTime(v time.Time) *GetInstanceMetricDataInput {
	s.StartTime = &v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *GetInstanceMetricDataInput) SetStatistics(v []*string) *GetInstanceMetricDataInput {
	s.Statistics = v
	return s
}

// SetUnit sets the Unit field's value.
func (s *GetInstanceMetricDataInput) SetUnit(v string) *GetInstanceMetricDataInput {
	s.Unit = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceMetricDataResult
type GetInstanceMetricDataOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// get instance metric data request.
	MetricData []*MetricDatapoint `locationName:"metricData" type:"list"`

	// The metric name to return data for.
	MetricName *string `locationName:"metricName" type:"string" enum:"InstanceMetricName"`
}

// String returns the string representation
func (s GetInstanceMetricDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceMetricDataOutput) GoString() string {
	return s.String()
}

// SetMetricData sets the MetricData field's value.
func (s *GetInstanceMetricDataOutput) SetMetricData(v []*MetricDatapoint) *GetInstanceMetricDataOutput {
	s.MetricData = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *GetInstanceMetricDataOutput) SetMetricName(v string) *GetInstanceMetricDataOutput {
	s.MetricName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceResult
type GetInstanceOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the specified instance.
	Instance *Instance `locationName:"instance" type:"structure"`
}

// String returns the string representation
func (s GetInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceOutput) GoString() string {
	return s.String()
}

// SetInstance sets the Instance field's value.
func (s *GetInstanceOutput) SetInstance(v *Instance) *GetInstanceOutput {
	s.Instance = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstancePortStatesRequest
type GetInstancePortStatesInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetInstancePortStatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstancePortStatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstancePortStatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInstancePortStatesInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *GetInstancePortStatesInput) SetInstanceName(v string) *GetInstancePortStatesInput {
	s.InstanceName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstancePortStatesResult
type GetInstancePortStatesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the port states resulting from your request.
	PortStates []*InstancePortState `locationName:"portStates" type:"list"`
}

// String returns the string representation
func (s GetInstancePortStatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstancePortStatesOutput) GoString() string {
	return s.String()
}

// SetPortStates sets the PortStates field's value.
func (s *GetInstancePortStatesOutput) SetPortStates(v []*InstancePortState) *GetInstancePortStatesOutput {
	s.PortStates = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshotRequest
type GetInstanceSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of the snapshot for which you are requesting information.
	//
	// InstanceSnapshotName is a required field
	InstanceSnapshotName *string `locationName:"instanceSnapshotName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetInstanceSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstanceSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInstanceSnapshotInput"}
	if s.InstanceSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceSnapshotName sets the InstanceSnapshotName field's value.
func (s *GetInstanceSnapshotInput) SetInstanceSnapshotName(v string) *GetInstanceSnapshotInput {
	s.InstanceSnapshotName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshotResult
type GetInstanceSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// get instance snapshot request.
	InstanceSnapshot *InstanceSnapshot `locationName:"instanceSnapshot" type:"structure"`
}

// String returns the string representation
func (s GetInstanceSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceSnapshotOutput) GoString() string {
	return s.String()
}

// SetInstanceSnapshot sets the InstanceSnapshot field's value.
func (s *GetInstanceSnapshotOutput) SetInstanceSnapshot(v *InstanceSnapshot) *GetInstanceSnapshotOutput {
	s.InstanceSnapshot = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshotsRequest
type GetInstanceSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get instance
	// snapshots request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetInstanceSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceSnapshotsInput) GoString() string {
	return s.String()
}

// SetPageToken sets the PageToken field's value.
func (s *GetInstanceSnapshotsInput) SetPageToken(v string) *GetInstanceSnapshotsInput {
	s.PageToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshotsResult
type GetInstanceSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// get instance snapshots request.
	InstanceSnapshots []*InstanceSnapshot `locationName:"instanceSnapshots" type:"list"`

	// A token used for advancing to the next page of results from your get instance
	// snapshots request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetInstanceSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceSnapshotsOutput) GoString() string {
	return s.String()
}

// SetInstanceSnapshots sets the InstanceSnapshots field's value.
func (s *GetInstanceSnapshotsOutput) SetInstanceSnapshots(v []*InstanceSnapshot) *GetInstanceSnapshotsOutput {
	s.InstanceSnapshots = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetInstanceSnapshotsOutput) SetNextPageToken(v string) *GetInstanceSnapshotsOutput {
	s.NextPageToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceStateRequest
type GetInstanceStateInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance to get state information about.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetInstanceStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstanceStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInstanceStateInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *GetInstanceStateInput) SetInstanceName(v string) *GetInstanceStateInput {
	s.InstanceName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceStateResult
type GetInstanceStateOutput struct {
	_ struct{} `type:"structure"`

	// The state of the instance.
	State *InstanceState `locationName:"state" type:"structure"`
}

// String returns the string representation
func (s GetInstanceStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceStateOutput) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *GetInstanceStateOutput) SetState(v *InstanceState) *GetInstanceStateOutput {
	s.State = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstancesRequest
type GetInstancesInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get instances
	// request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstancesInput) GoString() string {
	return s.String()
}

// SetPageToken sets the PageToken field's value.
func (s *GetInstancesInput) SetPageToken(v string) *GetInstancesInput {
	s.PageToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstancesResult
type GetInstancesOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about your instances.
	Instances []*Instance `locationName:"instances" type:"list"`

	// A token used for advancing to the next page of results from your get instances
	// request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstancesOutput) GoString() string {
	return s.String()
}

// SetInstances sets the Instances field's value.
func (s *GetInstancesOutput) SetInstances(v []*Instance) *GetInstancesOutput {
	s.Instances = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetInstancesOutput) SetNextPageToken(v string) *GetInstancesOutput {
	s.NextPageToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPairRequest
type GetKeyPairInput struct {
	_ struct{} `type:"structure"`

	// The name of the key pair for which you are requesting information.
	//
	// KeyPairName is a required field
	KeyPairName *string `locationName:"keyPairName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKeyPairInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKeyPairInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetKeyPairInput"}
	if s.KeyPairName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyPairName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyPairName sets the KeyPairName field's value.
func (s *GetKeyPairInput) SetKeyPairName(v string) *GetKeyPairInput {
	s.KeyPairName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPairResult
type GetKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the key pair.
	KeyPair *KeyPair `locationName:"keyPair" type:"structure"`
}

// String returns the string representation
func (s GetKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKeyPairOutput) GoString() string {
	return s.String()
}

// SetKeyPair sets the KeyPair field's value.
func (s *GetKeyPairOutput) SetKeyPair(v *KeyPair) *GetKeyPairOutput {
	s.KeyPair = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPairsRequest
type GetKeyPairsInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get key
	// pairs request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetKeyPairsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKeyPairsInput) GoString() string {
	return s.String()
}

// SetPageToken sets the PageToken field's value.
func (s *GetKeyPairsInput) SetPageToken(v string) *GetKeyPairsInput {
	s.PageToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPairsResult
type GetKeyPairsOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the key pairs.
	KeyPairs []*KeyPair `locationName:"keyPairs" type:"list"`

	// A token used for advancing to the next page of results from your get key
	// pairs request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetKeyPairsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKeyPairsOutput) GoString() string {
	return s.String()
}

// SetKeyPairs sets the KeyPairs field's value.
func (s *GetKeyPairsOutput) SetKeyPairs(v []*KeyPair) *GetKeyPairsOutput {
	s.KeyPairs = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetKeyPairsOutput) SetNextPageToken(v string) *GetKeyPairsOutput {
	s.NextPageToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperationRequest
type GetOperationInput struct {
	_ struct{} `type:"structure"`

	// A GUID used to identify the operation.
	//
	// OperationId is a required field
	OperationId *string `locationName:"operationId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetOperationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOperationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOperationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOperationInput"}
	if s.OperationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OperationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOperationId sets the OperationId field's value.
func (s *GetOperationInput) SetOperationId(v string) *GetOperationInput {
	s.OperationId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperationResult
type GetOperationOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// get operation request.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s GetOperationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOperationOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *GetOperationOutput) SetOperation(v *Operation) *GetOperationOutput {
	s.Operation = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperationsForResourceRequest
type GetOperationsForResourceInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get operations
	// for resource request.
	PageToken *string `locationName:"pageToken" type:"string"`

	// The name of the resource for which you are requesting information.
	//
	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetOperationsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOperationsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOperationsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOperationsForResourceInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPageToken sets the PageToken field's value.
func (s *GetOperationsForResourceInput) SetPageToken(v string) *GetOperationsForResourceInput {
	s.PageToken = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *GetOperationsForResourceInput) SetResourceName(v string) *GetOperationsForResourceInput {
	s.ResourceName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperationsForResourceResult
type GetOperationsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// (Deprecated) Returns the number of pages of results that remain.
	//
	// In releases prior to June 12, 2017, this parameter returned null by the API.
	// It is now deprecated, and the API returns the nextPageToken parameter instead.
	NextPageCount *string `locationName:"nextPageCount" deprecated:"true" type:"string"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// An array of key-value pairs containing information about the results of your
	// get operations for resource request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s GetOperationsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOperationsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextPageCount sets the NextPageCount field's value.
func (s *GetOperationsForResourceOutput) SetNextPageCount(v string) *GetOperationsForResourceOutput {
	s.NextPageCount = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetOperationsForResourceOutput) SetNextPageToken(v string) *GetOperationsForResourceOutput {
	s.NextPageToken = &v
	return s
}

// SetOperations sets the Operations field's value.
func (s *GetOperationsForResourceOutput) SetOperations(v []*Operation) *GetOperationsForResourceOutput {
	s.Operations = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperationsRequest
type GetOperationsInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get operations
	// request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetOperationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOperationsInput) GoString() string {
	return s.String()
}

// SetPageToken sets the PageToken field's value.
func (s *GetOperationsInput) SetPageToken(v string) *GetOperationsInput {
	s.PageToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperationsResult
type GetOperationsOutput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get operations
	// request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// An array of key-value pairs containing information about the results of your
	// get operations request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s GetOperationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOperationsOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetOperationsOutput) SetNextPageToken(v string) *GetOperationsOutput {
	s.NextPageToken = &v
	return s
}

// SetOperations sets the Operations field's value.
func (s *GetOperationsOutput) SetOperations(v []*Operation) *GetOperationsOutput {
	s.Operations = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRegionsRequest
type GetRegionsInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value indicating whether to also include Availability Zones in
	// your get regions request. Availability Zones are indicated with a letter:
	// e.g., us-east-1a.
	IncludeAvailabilityZones *bool `locationName:"includeAvailabilityZones" type:"boolean"`
}

// String returns the string representation
func (s GetRegionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRegionsInput) GoString() string {
	return s.String()
}

// SetIncludeAvailabilityZones sets the IncludeAvailabilityZones field's value.
func (s *GetRegionsInput) SetIncludeAvailabilityZones(v bool) *GetRegionsInput {
	s.IncludeAvailabilityZones = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRegionsResult
type GetRegionsOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about your get regions
	// request.
	Regions []*Region `locationName:"regions" type:"list"`
}

// String returns the string representation
func (s GetRegionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRegionsOutput) GoString() string {
	return s.String()
}

// SetRegions sets the Regions field's value.
func (s *GetRegionsOutput) SetRegions(v []*Region) *GetRegionsOutput {
	s.Regions = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIpRequest
type GetStaticIpInput struct {
	_ struct{} `type:"structure"`

	// The name of the static IP in Lightsail.
	//
	// StaticIpName is a required field
	StaticIpName *string `locationName:"staticIpName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetStaticIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStaticIpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStaticIpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStaticIpInput"}
	if s.StaticIpName == nil {
		invalidParams.Add(request.NewErrParamRequired("StaticIpName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStaticIpName sets the StaticIpName field's value.
func (s *GetStaticIpInput) SetStaticIpName(v string) *GetStaticIpInput {
	s.StaticIpName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIpResult
type GetStaticIpOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the requested static
	// IP.
	StaticIp *StaticIp `locationName:"staticIp" type:"structure"`
}

// String returns the string representation
func (s GetStaticIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStaticIpOutput) GoString() string {
	return s.String()
}

// SetStaticIp sets the StaticIp field's value.
func (s *GetStaticIpOutput) SetStaticIp(v *StaticIp) *GetStaticIpOutput {
	s.StaticIp = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIpsRequest
type GetStaticIpsInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get static
	// IPs request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetStaticIpsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStaticIpsInput) GoString() string {
	return s.String()
}

// SetPageToken sets the PageToken field's value.
func (s *GetStaticIpsInput) SetPageToken(v string) *GetStaticIpsInput {
	s.PageToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIpsResult
type GetStaticIpsOutput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get static
	// IPs request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// An array of key-value pairs containing information about your get static
	// IPs request.
	StaticIps []*StaticIp `locationName:"staticIps" type:"list"`
}

// String returns the string representation
func (s GetStaticIpsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStaticIpsOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetStaticIpsOutput) SetNextPageToken(v string) *GetStaticIpsOutput {
	s.NextPageToken = &v
	return s
}

// SetStaticIps sets the StaticIps field's value.
func (s *GetStaticIpsOutput) SetStaticIps(v []*StaticIp) *GetStaticIpsOutput {
	s.StaticIps = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ImportKeyPairRequest
type ImportKeyPairInput struct {
	_ struct{} `type:"structure"`

	// The name of the key pair for which you want to import the public key.
	//
	// KeyPairName is a required field
	KeyPairName *string `locationName:"keyPairName" type:"string" required:"true"`

	// A base64-encoded public key of the ssh-rsa type.
	//
	// PublicKeyBase64 is a required field
	PublicKeyBase64 *string `locationName:"publicKeyBase64" type:"string" required:"true"`
}

// String returns the string representation
func (s ImportKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportKeyPairInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportKeyPairInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportKeyPairInput"}
	if s.KeyPairName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyPairName"))
	}
	if s.PublicKeyBase64 == nil {
		invalidParams.Add(request.NewErrParamRequired("PublicKeyBase64"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyPairName sets the KeyPairName field's value.
func (s *ImportKeyPairInput) SetKeyPairName(v string) *ImportKeyPairInput {
	s.KeyPairName = &v
	return s
}

// SetPublicKeyBase64 sets the PublicKeyBase64 field's value.
func (s *ImportKeyPairInput) SetPublicKeyBase64(v string) *ImportKeyPairInput {
	s.PublicKeyBase64 = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ImportKeyPairResult
type ImportKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the request operation.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s ImportKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportKeyPairOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *ImportKeyPairOutput) SetOperation(v *Operation) *ImportKeyPairOutput {
	s.Operation = v
	return s
}

// Describes an instance (a virtual private server).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/Instance
type Instance struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the instance (e.g., arn:aws:lightsail:us-east-1:123456789101:Instance/244ad76f-8aad-4741-809f-12345EXAMPLE).
	Arn *string `locationName:"arn" type:"string"`

	// The blueprint ID (e.g., os_amlinux_2016_03).
	BlueprintId *string `locationName:"blueprintId" type:"string"`

	// The friendly name of the blueprint (e.g., Amazon Linux).
	BlueprintName *string `locationName:"blueprintName" type:"string"`

	// The bundle for the instance (e.g., micro_1_0).
	BundleId *string `locationName:"bundleId" type:"string"`

	// The timestamp when the instance was created (e.g., 1479734909.17).
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"unix"`

	// The size of the vCPU and the amount of RAM for the instance.
	Hardware *InstanceHardware `locationName:"hardware" type:"structure"`

	// The IPv6 address of the instance.
	Ipv6Address *string `locationName:"ipv6Address" type:"string"`

	// A Boolean value indicating whether this instance has a static IP assigned
	// to it.
	IsStaticIp *bool `locationName:"isStaticIp" type:"boolean"`

	// The region name and availability zone where the instance is located.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The name the user gave the instance (e.g., Amazon_Linux-1GB-Virginia-1).
	Name *string `locationName:"name" type:"string"`

	// Information about the public ports and monthly data transfer rates for the
	// instance.
	Networking *InstanceNetworking `locationName:"networking" type:"structure"`

	// The private IP address of the instance.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// The public IP address of the instance.
	PublicIpAddress *string `locationName:"publicIpAddress" type:"string"`

	// The type of resource (usually Instance).
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The name of the SSH key being used to connect to the instance (e.g., LightsailDefaultKeyPair).
	SshKeyName *string `locationName:"sshKeyName" type:"string"`

	// The status code and the state (e.g., running) for the instance.
	State *InstanceState `locationName:"state" type:"structure"`

	// The support code. Include this code in your email to support when you have
	// questions about an instance or another resource in Lightsail. This code enables
	// our support team to look up your Lightsail information more easily.
	SupportCode *string `locationName:"supportCode" type:"string"`

	// The user name for connecting to the instance (e.g., ec2-user).
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Instance) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Instance) SetArn(v string) *Instance {
	s.Arn = &v
	return s
}

// SetBlueprintId sets the BlueprintId field's value.
func (s *Instance) SetBlueprintId(v string) *Instance {
	s.BlueprintId = &v
	return s
}

// SetBlueprintName sets the BlueprintName field's value.
func (s *Instance) SetBlueprintName(v string) *Instance {
	s.BlueprintName = &v
	return s
}

// SetBundleId sets the BundleId field's value.
func (s *Instance) SetBundleId(v string) *Instance {
	s.BundleId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Instance) SetCreatedAt(v time.Time) *Instance {
	s.CreatedAt = &v
	return s
}

// SetHardware sets the Hardware field's value.
func (s *Instance) SetHardware(v *InstanceHardware) *Instance {
	s.Hardware = v
	return s
}

// SetIpv6Address sets the Ipv6Address field's value.
func (s *Instance) SetIpv6Address(v string) *Instance {
	s.Ipv6Address = &v
	return s
}

// SetIsStaticIp sets the IsStaticIp field's value.
func (s *Instance) SetIsStaticIp(v bool) *Instance {
	s.IsStaticIp = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *Instance) SetLocation(v *ResourceLocation) *Instance {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *Instance) SetName(v string) *Instance {
	s.Name = &v
	return s
}

// SetNetworking sets the Networking field's value.
func (s *Instance) SetNetworking(v *InstanceNetworking) *Instance {
	s.Networking = v
	return s
}

// SetPrivateIpAddress sets the PrivateIpAddress field's value.
func (s *Instance) SetPrivateIpAddress(v string) *Instance {
	s.PrivateIpAddress = &v
	return s
}

// SetPublicIpAddress sets the PublicIpAddress field's value.
func (s *Instance) SetPublicIpAddress(v string) *Instance {
	s.PublicIpAddress = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Instance) SetResourceType(v string) *Instance {
	s.ResourceType = &v
	return s
}

// SetSshKeyName sets the SshKeyName field's value.
func (s *Instance) SetSshKeyName(v string) *Instance {
	s.SshKeyName = &v
	return s
}

// SetState sets the State field's value.
func (s *Instance) SetState(v *InstanceState) *Instance {
	s.State = v
	return s
}

// SetSupportCode sets the SupportCode field's value.
func (s *Instance) SetSupportCode(v string) *Instance {
	s.SupportCode = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *Instance) SetUsername(v string) *Instance {
	s.Username = &v
	return s
}

// The parameters for gaining temporary access to one of your Amazon Lightsail
// instances.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/InstanceAccessDetails
type InstanceAccessDetails struct {
	_ struct{} `type:"structure"`

	// For SSH access, the public key to use when accessing your instance For OpenSSH
	// clients (e.g., command line SSH), you should save this value to tempkey-cert.pub.
	CertKey *string `locationName:"certKey" type:"string"`

	// For SSH access, the date on which the temporary keys expire.
	ExpiresAt *time.Time `locationName:"expiresAt" type:"timestamp" timestampFormat:"unix"`

	// The name of this Amazon Lightsail instance.
	InstanceName *string `locationName:"instanceName" type:"string"`

	// The public IP address of the Amazon Lightsail instance.
	IpAddress *string `locationName:"ipAddress" type:"string"`

	// For RDP access, the password for your Amazon Lightsail instance. Password
	// will be an empty string if the password for your new instance is not ready
	// yet. When you create an instance, it can take up to 15 minutes for the instance
	// to be ready.
	//
	// If you create an instance using any key pair other than the default (LightsailDefaultKeyPair),
	// password will always be an empty string.
	//
	// If you change the Administrator password on the instance, Lightsail will
	// continue to return the original password value. When accessing the instance
	// using RDP, you need to manually enter the Administrator password after changing
	// it from the default.
	Password *string `locationName:"password" type:"string"`

	// For a Windows Server-based instance, an object with the data you can use
	// to retrieve your password. This is only needed if password is empty and the
	// instance is not new (and therefore the password is not ready yet). When you
	// create an instance, it can take up to 15 minutes for the instance to be ready.
	PasswordData *PasswordData `locationName:"passwordData" type:"structure"`

	// For SSH access, the temporary private key. For OpenSSH clients (e.g., command
	// line SSH), you should save this value to tempkey).
	PrivateKey *string `locationName:"privateKey" type:"string"`

	// The protocol for these Amazon Lightsail instance access details.
	Protocol *string `locationName:"protocol" type:"string" enum:"InstanceAccessProtocol"`

	// The user name to use when logging in to the Amazon Lightsail instance.
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation
func (s InstanceAccessDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceAccessDetails) GoString() string {
	return s.String()
}

// SetCertKey sets the CertKey field's value.
func (s *InstanceAccessDetails) SetCertKey(v string) *InstanceAccessDetails {
	s.CertKey = &v
	return s
}

// SetExpiresAt sets the ExpiresAt field's value.
func (s *InstanceAccessDetails) SetExpiresAt(v time.Time) *InstanceAccessDetails {
	s.ExpiresAt = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *InstanceAccessDetails) SetInstanceName(v string) *InstanceAccessDetails {
	s.InstanceName = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *InstanceAccessDetails) SetIpAddress(v string) *InstanceAccessDetails {
	s.IpAddress = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *InstanceAccessDetails) SetPassword(v string) *InstanceAccessDetails {
	s.Password = &v
	return s
}

// SetPasswordData sets the PasswordData field's value.
func (s *InstanceAccessDetails) SetPasswordData(v *PasswordData) *InstanceAccessDetails {
	s.PasswordData = v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *InstanceAccessDetails) SetPrivateKey(v string) *InstanceAccessDetails {
	s.PrivateKey = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *InstanceAccessDetails) SetProtocol(v string) *InstanceAccessDetails {
	s.Protocol = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *InstanceAccessDetails) SetUsername(v string) *InstanceAccessDetails {
	s.Username = &v
	return s
}

// Describes the hardware for the instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/InstanceHardware
type InstanceHardware struct {
	_ struct{} `type:"structure"`

	// The number of vCPUs the instance has.
	CpuCount *int64 `locationName:"cpuCount" type:"integer"`

	// The disks attached to the instance.
	Disks []*Disk `locationName:"disks" type:"list"`

	// The amount of RAM in GB on the instance (e.g., 1.0).
	RamSizeInGb *float64 `locationName:"ramSizeInGb" type:"float"`
}

// String returns the string representation
func (s InstanceHardware) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceHardware) GoString() string {
	return s.String()
}

// SetCpuCount sets the CpuCount field's value.
func (s *InstanceHardware) SetCpuCount(v int64) *InstanceHardware {
	s.CpuCount = &v
	return s
}

// SetDisks sets the Disks field's value.
func (s *InstanceHardware) SetDisks(v []*Disk) *InstanceHardware {
	s.Disks = v
	return s
}

// SetRamSizeInGb sets the RamSizeInGb field's value.
func (s *InstanceHardware) SetRamSizeInGb(v float64) *InstanceHardware {
	s.RamSizeInGb = &v
	return s
}

// Describes monthly data transfer rates and port information for an instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/InstanceNetworking
type InstanceNetworking struct {
	_ struct{} `type:"structure"`

	// The amount of data in GB allocated for monthly data transfers.
	MonthlyTransfer *MonthlyTransfer `locationName:"monthlyTransfer" type:"structure"`

	// An array of key-value pairs containing information about the ports on the
	// instance.
	Ports []*InstancePortInfo `locationName:"ports" type:"list"`
}

// String returns the string representation
func (s InstanceNetworking) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceNetworking) GoString() string {
	return s.String()
}

// SetMonthlyTransfer sets the MonthlyTransfer field's value.
func (s *InstanceNetworking) SetMonthlyTransfer(v *MonthlyTransfer) *InstanceNetworking {
	s.MonthlyTransfer = v
	return s
}

// SetPorts sets the Ports field's value.
func (s *InstanceNetworking) SetPorts(v []*InstancePortInfo) *InstanceNetworking {
	s.Ports = v
	return s
}

// Describes information about the instance ports.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/InstancePortInfo
type InstancePortInfo struct {
	_ struct{} `type:"structure"`

	// The access direction (inbound or outbound).
	AccessDirection *string `locationName:"accessDirection" type:"string" enum:"AccessDirection"`

	// The location from which access is allowed (e.g., Anywhere (0.0.0.0/0)).
	AccessFrom *string `locationName:"accessFrom" type:"string"`

	// The type of access (Public or Private).
	AccessType *string `locationName:"accessType" type:"string" enum:"PortAccessType"`

	// The common name.
	CommonName *string `locationName:"commonName" type:"string"`

	// The first port in the range.
	FromPort *int64 `locationName:"fromPort" type:"integer"`

	// The protocol being used. Can be one of the following.
	//
	//    * tcp - Transmission Control Protocol (TCP) provides reliable, ordered,
	//    and error-checked delivery of streamed data between applications running
	//    on hosts communicating by an IP network. If you have an application that
	//    doesn't require reliable data stream service, use UDP instead.
	//
	//    * all - All transport layer protocol types. For more general information,
	//    see Transport layer (https://en.wikipedia.org/wiki/Transport_layer) on
	//    Wikipedia.
	//
	//    * udp - With User Datagram Protocol (UDP), computer applications can send
	//    messages (or datagrams) to other hosts on an Internet Protocol (IP) network.
	//    Prior communications are not required to set up transmission channels
	//    or data paths. Applications that don't require reliable data stream service
	//    can use UDP, which provides a connectionless datagram service that emphasizes
	//    reduced latency over reliability. If you do require reliable data stream
	//    service, use TCP instead.
	Protocol *string `locationName:"protocol" type:"string" enum:"NetworkProtocol"`

	// The last port in the range.
	ToPort *int64 `locationName:"toPort" type:"integer"`
}

// String returns the string representation
func (s InstancePortInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstancePortInfo) GoString() string {
	return s.String()
}

// SetAccessDirection sets the AccessDirection field's value.
func (s *InstancePortInfo) SetAccessDirection(v string) *InstancePortInfo {
	s.AccessDirection = &v
	return s
}

// SetAccessFrom sets the AccessFrom field's value.
func (s *InstancePortInfo) SetAccessFrom(v string) *InstancePortInfo {
	s.AccessFrom = &v
	return s
}

// SetAccessType sets the AccessType field's value.
func (s *InstancePortInfo) SetAccessType(v string) *InstancePortInfo {
	s.AccessType = &v
	return s
}

// SetCommonName sets the CommonName field's value.
func (s *InstancePortInfo) SetCommonName(v string) *InstancePortInfo {
	s.CommonName = &v
	return s
}

// SetFromPort sets the FromPort field's value.
func (s *InstancePortInfo) SetFromPort(v int64) *InstancePortInfo {
	s.FromPort = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *InstancePortInfo) SetProtocol(v string) *InstancePortInfo {
	s.Protocol = &v
	return s
}

// SetToPort sets the ToPort field's value.
func (s *InstancePortInfo) SetToPort(v int64) *InstancePortInfo {
	s.ToPort = &v
	return s
}

// Describes the port state.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/InstancePortState
type InstancePortState struct {
	_ struct{} `type:"structure"`

	// The first port in the range.
	FromPort *int64 `locationName:"fromPort" type:"integer"`

	// The protocol being used. Can be one of the following.
	//
	//    * tcp - Transmission Control Protocol (TCP) provides reliable, ordered,
	//    and error-checked delivery of streamed data between applications running
	//    on hosts communicating by an IP network. If you have an application that
	//    doesn't require reliable data stream service, use UDP instead.
	//
	//    * all - All transport layer protocol types. For more general information,
	//    see Transport layer (https://en.wikipedia.org/wiki/Transport_layer) on
	//    Wikipedia.
	//
	//    * udp - With User Datagram Protocol (UDP), computer applications can send
	//    messages (or datagrams) to other hosts on an Internet Protocol (IP) network.
	//    Prior communications are not required to set up transmission channels
	//    or data paths. Applications that don't require reliable data stream service
	//    can use UDP, which provides a connectionless datagram service that emphasizes
	//    reduced latency over reliability. If you do require reliable data stream
	//    service, use TCP instead.
	Protocol *string `locationName:"protocol" type:"string" enum:"NetworkProtocol"`

	// Specifies whether the instance port is open or closed.
	State *string `locationName:"state" type:"string" enum:"PortState"`

	// The last port in the range.
	ToPort *int64 `locationName:"toPort" type:"integer"`
}

// String returns the string representation
func (s InstancePortState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstancePortState) GoString() string {
	return s.String()
}

// SetFromPort sets the FromPort field's value.
func (s *InstancePortState) SetFromPort(v int64) *InstancePortState {
	s.FromPort = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *InstancePortState) SetProtocol(v string) *InstancePortState {
	s.Protocol = &v
	return s
}

// SetState sets the State field's value.
func (s *InstancePortState) SetState(v string) *InstancePortState {
	s.State = &v
	return s
}

// SetToPort sets the ToPort field's value.
func (s *InstancePortState) SetToPort(v int64) *InstancePortState {
	s.ToPort = &v
	return s
}

// Describes the snapshot of the virtual private server, or instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/InstanceSnapshot
type InstanceSnapshot struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the snapshot (e.g., arn:aws:lightsail:us-east-1:123456789101:InstanceSnapshot/d23b5706-3322-4d83-81e5-12345EXAMPLE).
	Arn *string `locationName:"arn" type:"string"`

	// The timestamp when the snapshot was created (e.g., 1479907467.024).
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"unix"`

	// The blueprint ID from which you created the snapshot (e.g., os_debian_8_3).
	// A blueprint is a virtual private server (or instance) image used to create
	// instances quickly.
	FromBlueprintId *string `locationName:"fromBlueprintId" type:"string"`

	// The bundle ID from which you created the snapshot (e.g., micro_1_0).
	FromBundleId *string `locationName:"fromBundleId" type:"string"`

	// The Amazon Resource Name (ARN) of the instance from which the snapshot was
	// created (e.g., arn:aws:lightsail:us-east-1:123456789101:Instance/64b8404c-ccb1-430b-8daf-12345EXAMPLE).
	FromInstanceArn *string `locationName:"fromInstanceArn" type:"string"`

	// The instance from which the snapshot was created.
	FromInstanceName *string `locationName:"fromInstanceName" type:"string"`

	// The region name and availability zone where you created the snapshot.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The name of the snapshot.
	Name *string `locationName:"name" type:"string"`

	// The progress of the snapshot.
	Progress *string `locationName:"progress" type:"string"`

	// The type of resource (usually InstanceSnapshot).
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The size in GB of the SSD.
	SizeInGb *int64 `locationName:"sizeInGb" type:"integer"`

	// The state the snapshot is in.
	State *string `locationName:"state" type:"string" enum:"InstanceSnapshotState"`

	// The support code. Include this code in your email to support when you have
	// questions about an instance or another resource in Lightsail. This code enables
	// our support team to look up your Lightsail information more easily.
	SupportCode *string `locationName:"supportCode" type:"string"`
}

// String returns the string representation
func (s InstanceSnapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceSnapshot) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *InstanceSnapshot) SetArn(v string) *InstanceSnapshot {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *InstanceSnapshot) SetCreatedAt(v time.Time) *InstanceSnapshot {
	s.CreatedAt = &v
	return s
}

// SetFromBlueprintId sets the FromBlueprintId field's value.
func (s *InstanceSnapshot) SetFromBlueprintId(v string) *InstanceSnapshot {
	s.FromBlueprintId = &v
	return s
}

// SetFromBundleId sets the FromBundleId field's value.
func (s *InstanceSnapshot) SetFromBundleId(v string) *InstanceSnapshot {
	s.FromBundleId = &v
	return s
}

// SetFromInstanceArn sets the FromInstanceArn field's value.
func (s *InstanceSnapshot) SetFromInstanceArn(v string) *InstanceSnapshot {
	s.FromInstanceArn = &v
	return s
}

// SetFromInstanceName sets the FromInstanceName field's value.
func (s *InstanceSnapshot) SetFromInstanceName(v string) *InstanceSnapshot {
	s.FromInstanceName = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *InstanceSnapshot) SetLocation(v *ResourceLocation) *InstanceSnapshot {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *InstanceSnapshot) SetName(v string) *InstanceSnapshot {
	s.Name = &v
	return s
}

// SetProgress sets the Progress field's value.
func (s *InstanceSnapshot) SetProgress(v string) *InstanceSnapshot {
	s.Progress = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *InstanceSnapshot) SetResourceType(v string) *InstanceSnapshot {
	s.ResourceType = &v
	return s
}

// SetSizeInGb sets the SizeInGb field's value.
func (s *InstanceSnapshot) SetSizeInGb(v int64) *InstanceSnapshot {
	s.SizeInGb = &v
	return s
}

// SetState sets the State field's value.
func (s *InstanceSnapshot) SetState(v string) *InstanceSnapshot {
	s.State = &v
	return s
}

// SetSupportCode sets the SupportCode field's value.
func (s *InstanceSnapshot) SetSupportCode(v string) *InstanceSnapshot {
	s.SupportCode = &v
	return s
}

// Describes the virtual private server (or instance) status.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/InstanceState
type InstanceState struct {
	_ struct{} `type:"structure"`

	// The status code for the instance.
	Code *int64 `locationName:"code" type:"integer"`

	// The state of the instance (e.g., running or pending).
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s InstanceState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceState) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *InstanceState) SetCode(v int64) *InstanceState {
	s.Code = &v
	return s
}

// SetName sets the Name field's value.
func (s *InstanceState) SetName(v string) *InstanceState {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/IsVpcPeeredRequest
type IsVpcPeeredInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s IsVpcPeeredInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IsVpcPeeredInput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/IsVpcPeeredResult
type IsVpcPeeredOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the Lightsail VPC is peered; otherwise, false.
	IsPeered *bool `locationName:"isPeered" type:"boolean"`
}

// String returns the string representation
func (s IsVpcPeeredOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IsVpcPeeredOutput) GoString() string {
	return s.String()
}

// SetIsPeered sets the IsPeered field's value.
func (s *IsVpcPeeredOutput) SetIsPeered(v bool) *IsVpcPeeredOutput {
	s.IsPeered = &v
	return s
}

// Describes the SSH key pair.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/KeyPair
type KeyPair struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the key pair (e.g., arn:aws:lightsail:us-east-1:123456789101:KeyPair/05859e3d-331d-48ba-9034-12345EXAMPLE).
	Arn *string `locationName:"arn" type:"string"`

	// The timestamp when the key pair was created (e.g., 1479816991.349).
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"unix"`

	// The RSA fingerprint of the key pair.
	Fingerprint *string `locationName:"fingerprint" type:"string"`

	// The region name and Availability Zone where the key pair was created.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The friendly name of the SSH key pair.
	Name *string `locationName:"name" type:"string"`

	// The resource type (usually KeyPair).
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The support code. Include this code in your email to support when you have
	// questions about an instance or another resource in Lightsail. This code enables
	// our support team to look up your Lightsail information more easily.
	SupportCode *string `locationName:"supportCode" type:"string"`
}

// String returns the string representation
func (s KeyPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyPair) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *KeyPair) SetArn(v string) *KeyPair {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *KeyPair) SetCreatedAt(v time.Time) *KeyPair {
	s.CreatedAt = &v
	return s
}

// SetFingerprint sets the Fingerprint field's value.
func (s *KeyPair) SetFingerprint(v string) *KeyPair {
	s.Fingerprint = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *KeyPair) SetLocation(v *ResourceLocation) *KeyPair {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *KeyPair) SetName(v string) *KeyPair {
	s.Name = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *KeyPair) SetResourceType(v string) *KeyPair {
	s.ResourceType = &v
	return s
}

// SetSupportCode sets the SupportCode field's value.
func (s *KeyPair) SetSupportCode(v string) *KeyPair {
	s.SupportCode = &v
	return s
}

// Describes the metric data point.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/MetricDatapoint
type MetricDatapoint struct {
	_ struct{} `type:"structure"`

	// The average.
	Average *float64 `locationName:"average" type:"double"`

	// The maximum.
	Maximum *float64 `locationName:"maximum" type:"double"`

	// The minimum.
	Minimum *float64 `locationName:"minimum" type:"double"`

	// The sample count.
	SampleCount *float64 `locationName:"sampleCount" type:"double"`

	// The sum.
	Sum *float64 `locationName:"sum" type:"double"`

	// The timestamp (e.g., 1479816991.349).
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp" timestampFormat:"unix"`

	// The unit.
	Unit *string `locationName:"unit" type:"string" enum:"MetricUnit"`
}

// String returns the string representation
func (s MetricDatapoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricDatapoint) GoString() string {
	return s.String()
}

// SetAverage sets the Average field's value.
func (s *MetricDatapoint) SetAverage(v float64) *MetricDatapoint {
	s.Average = &v
	return s
}

// SetMaximum sets the Maximum field's value.
func (s *MetricDatapoint) SetMaximum(v float64) *MetricDatapoint {
	s.Maximum = &v
	return s
}

// SetMinimum sets the Minimum field's value.
func (s *MetricDatapoint) SetMinimum(v float64) *MetricDatapoint {
	s.Minimum = &v
	return s
}

// SetSampleCount sets the SampleCount field's value.
func (s *MetricDatapoint) SetSampleCount(v float64) *MetricDatapoint {
	s.SampleCount = &v
	return s
}

// SetSum sets the Sum field's value.
func (s *MetricDatapoint) SetSum(v float64) *MetricDatapoint {
	s.Sum = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *MetricDatapoint) SetTimestamp(v time.Time) *MetricDatapoint {
	s.Timestamp = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *MetricDatapoint) SetUnit(v string) *MetricDatapoint {
	s.Unit = &v
	return s
}

// Describes the monthly data transfer in and out of your virtual private server
// (or instance).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/MonthlyTransfer
type MonthlyTransfer struct {
	_ struct{} `type:"structure"`

	// The amount allocated per month (in GB).
	GbPerMonthAllocated *int64 `locationName:"gbPerMonthAllocated" type:"integer"`
}

// String returns the string representation
func (s MonthlyTransfer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MonthlyTransfer) GoString() string {
	return s.String()
}

// SetGbPerMonthAllocated sets the GbPerMonthAllocated field's value.
func (s *MonthlyTransfer) SetGbPerMonthAllocated(v int64) *MonthlyTransfer {
	s.GbPerMonthAllocated = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/OpenInstancePublicPortsRequest
type OpenInstancePublicPortsInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance for which you want to open the public ports.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	// An array of key-value pairs containing information about the port mappings.
	//
	// PortInfo is a required field
	PortInfo *PortInfo `locationName:"portInfo" type:"structure" required:"true"`
}

// String returns the string representation
func (s OpenInstancePublicPortsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OpenInstancePublicPortsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OpenInstancePublicPortsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OpenInstancePublicPortsInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}
	if s.PortInfo == nil {
		invalidParams.Add(request.NewErrParamRequired("PortInfo"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *OpenInstancePublicPortsInput) SetInstanceName(v string) *OpenInstancePublicPortsInput {
	s.InstanceName = &v
	return s
}

// SetPortInfo sets the PortInfo field's value.
func (s *OpenInstancePublicPortsInput) SetPortInfo(v *PortInfo) *OpenInstancePublicPortsInput {
	s.PortInfo = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/OpenInstancePublicPortsResult
type OpenInstancePublicPortsOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the request operation.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s OpenInstancePublicPortsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OpenInstancePublicPortsOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *OpenInstancePublicPortsOutput) SetOperation(v *Operation) *OpenInstancePublicPortsOutput {
	s.Operation = v
	return s
}

// Describes the API operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/Operation
type Operation struct {
	_ struct{} `type:"structure"`

	// The timestamp when the operation was initialized (e.g., 1479816991.349).
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"unix"`

	// The error code.
	ErrorCode *string `locationName:"errorCode" type:"string"`

	// The error details.
	ErrorDetails *string `locationName:"errorDetails" type:"string"`

	// The ID of the operation.
	Id *string `locationName:"id" type:"string"`

	// A Boolean value indicating whether the operation is terminal.
	IsTerminal *bool `locationName:"isTerminal" type:"boolean"`

	// The region and Availability Zone.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// Details about the operation (e.g., Debian-1GB-Virginia-1).
	OperationDetails *string `locationName:"operationDetails" type:"string"`

	// The type of operation.
	OperationType *string `locationName:"operationType" type:"string" enum:"OperationType"`

	// The resource name.
	ResourceName *string `locationName:"resourceName" type:"string"`

	// The resource type.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The status of the operation.
	Status *string `locationName:"status" type:"string" enum:"OperationStatus"`

	// The timestamp when the status was changed (e.g., 1479816991.349).
	StatusChangedAt *time.Time `locationName:"statusChangedAt" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s Operation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Operation) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Operation) SetCreatedAt(v time.Time) *Operation {
	s.CreatedAt = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *Operation) SetErrorCode(v string) *Operation {
	s.ErrorCode = &v
	return s
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *Operation) SetErrorDetails(v string) *Operation {
	s.ErrorDetails = &v
	return s
}

// SetId sets the Id field's value.
func (s *Operation) SetId(v string) *Operation {
	s.Id = &v
	return s
}

// SetIsTerminal sets the IsTerminal field's value.
func (s *Operation) SetIsTerminal(v bool) *Operation {
	s.IsTerminal = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *Operation) SetLocation(v *ResourceLocation) *Operation {
	s.Location = v
	return s
}

// SetOperationDetails sets the OperationDetails field's value.
func (s *Operation) SetOperationDetails(v string) *Operation {
	s.OperationDetails = &v
	return s
}

// SetOperationType sets the OperationType field's value.
func (s *Operation) SetOperationType(v string) *Operation {
	s.OperationType = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *Operation) SetResourceName(v string) *Operation {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Operation) SetResourceType(v string) *Operation {
	s.ResourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Operation) SetStatus(v string) *Operation {
	s.Status = &v
	return s
}

// SetStatusChangedAt sets the StatusChangedAt field's value.
func (s *Operation) SetStatusChangedAt(v time.Time) *Operation {
	s.StatusChangedAt = &v
	return s
}

// The password data for the Windows Server-based instance, including the ciphertext
// and the key pair name.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PasswordData
type PasswordData struct {
	_ struct{} `type:"structure"`

	// The encrypted password. Ciphertext will be an empty string if access to your
	// new instance is not ready yet. When you create an instance, it can take up
	// to 15 minutes for the instance to be ready.
	//
	// If you use the default key pair (LightsailDefaultKeyPair), the decrypted
	// password will be available in the password field.
	//
	// If you are using a custom key pair, you need to use your own means of decryption.
	//
	// If you change the Administrator password on the instance, Lightsail will
	// continue to return the original ciphertext value. When accessing the instance
	// using RDP, you need to manually enter the Administrator password after changing
	// it from the default.
	Ciphertext *string `locationName:"ciphertext" type:"string"`

	// The name of the key pair that you used when creating your instance. If no
	// key pair name was specified when creating the instance, Lightsail uses the
	// default key pair (LightsailDefaultKeyPair).
	//
	// If you are using a custom key pair, you need to use your own means of decrypting
	// your password using the ciphertext. Lightsail creates the ciphertext by encrypting
	// your password with the public key part of this key pair.
	KeyPairName *string `locationName:"keyPairName" type:"string"`
}

// String returns the string representation
func (s PasswordData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PasswordData) GoString() string {
	return s.String()
}

// SetCiphertext sets the Ciphertext field's value.
func (s *PasswordData) SetCiphertext(v string) *PasswordData {
	s.Ciphertext = &v
	return s
}

// SetKeyPairName sets the KeyPairName field's value.
func (s *PasswordData) SetKeyPairName(v string) *PasswordData {
	s.KeyPairName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PeerVpcRequest
type PeerVpcInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PeerVpcInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PeerVpcInput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PeerVpcResult
type PeerVpcOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the request operation.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s PeerVpcOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PeerVpcOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *PeerVpcOutput) SetOperation(v *Operation) *PeerVpcOutput {
	s.Operation = v
	return s
}

// Describes information about the ports on your virtual private server (or
// instance).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PortInfo
type PortInfo struct {
	_ struct{} `type:"structure"`

	// The first port in the range.
	FromPort *int64 `locationName:"fromPort" type:"integer"`

	// The protocol.
	Protocol *string `locationName:"protocol" type:"string" enum:"NetworkProtocol"`

	// The last port in the range.
	ToPort *int64 `locationName:"toPort" type:"integer"`
}

// String returns the string representation
func (s PortInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PortInfo) GoString() string {
	return s.String()
}

// SetFromPort sets the FromPort field's value.
func (s *PortInfo) SetFromPort(v int64) *PortInfo {
	s.FromPort = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *PortInfo) SetProtocol(v string) *PortInfo {
	s.Protocol = &v
	return s
}

// SetToPort sets the ToPort field's value.
func (s *PortInfo) SetToPort(v int64) *PortInfo {
	s.ToPort = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutInstancePublicPortsRequest
type PutInstancePublicPortsInput struct {
	_ struct{} `type:"structure"`

	// The Lightsail instance name of the public port(s) you are setting.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	// Specifies information about the public port(s).
	//
	// PortInfos is a required field
	PortInfos []*PortInfo `locationName:"portInfos" type:"list" required:"true"`
}

// String returns the string representation
func (s PutInstancePublicPortsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutInstancePublicPortsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutInstancePublicPortsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutInstancePublicPortsInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}
	if s.PortInfos == nil {
		invalidParams.Add(request.NewErrParamRequired("PortInfos"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *PutInstancePublicPortsInput) SetInstanceName(v string) *PutInstancePublicPortsInput {
	s.InstanceName = &v
	return s
}

// SetPortInfos sets the PortInfos field's value.
func (s *PutInstancePublicPortsInput) SetPortInfos(v []*PortInfo) *PutInstancePublicPortsInput {
	s.PortInfos = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutInstancePublicPortsResult
type PutInstancePublicPortsOutput struct {
	_ struct{} `type:"structure"`

	// Describes metadata about the operation you just executed.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s PutInstancePublicPortsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutInstancePublicPortsOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *PutInstancePublicPortsOutput) SetOperation(v *Operation) *PutInstancePublicPortsOutput {
	s.Operation = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootInstanceRequest
type RebootInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance to reboot.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s RebootInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootInstanceInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *RebootInstanceInput) SetInstanceName(v string) *RebootInstanceInput {
	s.InstanceName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootInstanceResult
type RebootInstanceOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the request operation.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s RebootInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootInstanceOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *RebootInstanceOutput) SetOperations(v []*Operation) *RebootInstanceOutput {
	s.Operations = v
	return s
}

// Describes the AWS Region.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/Region
type Region struct {
	_ struct{} `type:"structure"`

	// The Availability Zones. Follows the format us-east-1a (case-sensitive).
	AvailabilityZones []*AvailabilityZone `locationName:"availabilityZones" type:"list"`

	// The continent code (e.g., NA, meaning North America).
	ContinentCode *string `locationName:"continentCode" type:"string"`

	// The description of the AWS Region (e.g., This region is recommended to serve
	// users in the eastern United States and eastern Canada).
	Description *string `locationName:"description" type:"string"`

	// The display name (e.g., Virginia).
	DisplayName *string `locationName:"displayName" type:"string"`

	// The region name (e.g., us-east-1).
	Name *string `locationName:"name" type:"string" enum:"RegionName"`
}

// String returns the string representation
func (s Region) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Region) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *Region) SetAvailabilityZones(v []*AvailabilityZone) *Region {
	s.AvailabilityZones = v
	return s
}

// SetContinentCode sets the ContinentCode field's value.
func (s *Region) SetContinentCode(v string) *Region {
	s.ContinentCode = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Region) SetDescription(v string) *Region {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Region) SetDisplayName(v string) *Region {
	s.DisplayName = &v
	return s
}

// SetName sets the Name field's value.
func (s *Region) SetName(v string) *Region {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ReleaseStaticIpRequest
type ReleaseStaticIpInput struct {
	_ struct{} `type:"structure"`

	// The name of the static IP to delete.
	//
	// StaticIpName is a required field
	StaticIpName *string `locationName:"staticIpName" type:"string" required:"true"`
}

// String returns the string representation
func (s ReleaseStaticIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReleaseStaticIpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReleaseStaticIpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReleaseStaticIpInput"}
	if s.StaticIpName == nil {
		invalidParams.Add(request.NewErrParamRequired("StaticIpName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStaticIpName sets the StaticIpName field's value.
func (s *ReleaseStaticIpInput) SetStaticIpName(v string) *ReleaseStaticIpInput {
	s.StaticIpName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ReleaseStaticIpResult
type ReleaseStaticIpOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the request operation.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s ReleaseStaticIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReleaseStaticIpOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *ReleaseStaticIpOutput) SetOperations(v []*Operation) *ReleaseStaticIpOutput {
	s.Operations = v
	return s
}

// Describes the resource location.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ResourceLocation
type ResourceLocation struct {
	_ struct{} `type:"structure"`

	// The Availability Zone. Follows the format us-east-1a (case-sensitive).
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The AWS Region name.
	RegionName *string `locationName:"regionName" type:"string" enum:"RegionName"`
}

// String returns the string representation
func (s ResourceLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceLocation) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *ResourceLocation) SetAvailabilityZone(v string) *ResourceLocation {
	s.AvailabilityZone = &v
	return s
}

// SetRegionName sets the RegionName field's value.
func (s *ResourceLocation) SetRegionName(v string) *ResourceLocation {
	s.RegionName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartInstanceRequest
type StartInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance (a virtual private server) to start.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s StartInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartInstanceInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *StartInstanceInput) SetInstanceName(v string) *StartInstanceInput {
	s.InstanceName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartInstanceResult
type StartInstanceOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the request operation.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s StartInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartInstanceOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *StartInstanceOutput) SetOperations(v []*Operation) *StartInstanceOutput {
	s.Operations = v
	return s
}

// Describes the static IP.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StaticIp
type StaticIp struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the static IP (e.g., arn:aws:lightsail:us-east-1:123456789101:StaticIp/9cbb4a9e-f8e3-4dfe-b57e-12345EXAMPLE).
	Arn *string `locationName:"arn" type:"string"`

	// The instance where the static IP is attached (e.g., Amazon_Linux-1GB-Virginia-1).
	AttachedTo *string `locationName:"attachedTo" type:"string"`

	// The timestamp when the static IP was created (e.g., 1479735304.222).
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"unix"`

	// The static IP address.
	IpAddress *string `locationName:"ipAddress" type:"string"`

	// A Boolean value indicating whether the static IP is attached.
	IsAttached *bool `locationName:"isAttached" type:"boolean"`

	// The region and Availability Zone where the static IP was created.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The name of the static IP (e.g., StaticIP-Virginia-EXAMPLE).
	Name *string `locationName:"name" type:"string"`

	// The resource type (usually StaticIp).
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The support code. Include this code in your email to support when you have
	// questions about an instance or another resource in Lightsail. This code enables
	// our support team to look up your Lightsail information more easily.
	SupportCode *string `locationName:"supportCode" type:"string"`
}

// String returns the string representation
func (s StaticIp) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StaticIp) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StaticIp) SetArn(v string) *StaticIp {
	s.Arn = &v
	return s
}

// SetAttachedTo sets the AttachedTo field's value.
func (s *StaticIp) SetAttachedTo(v string) *StaticIp {
	s.AttachedTo = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *StaticIp) SetCreatedAt(v time.Time) *StaticIp {
	s.CreatedAt = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *StaticIp) SetIpAddress(v string) *StaticIp {
	s.IpAddress = &v
	return s
}

// SetIsAttached sets the IsAttached field's value.
func (s *StaticIp) SetIsAttached(v bool) *StaticIp {
	s.IsAttached = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *StaticIp) SetLocation(v *ResourceLocation) *StaticIp {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *StaticIp) SetName(v string) *StaticIp {
	s.Name = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *StaticIp) SetResourceType(v string) *StaticIp {
	s.ResourceType = &v
	return s
}

// SetSupportCode sets the SupportCode field's value.
func (s *StaticIp) SetSupportCode(v string) *StaticIp {
	s.SupportCode = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopInstanceRequest
type StopInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance (a virtual private server) to stop.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s StopInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopInstanceInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *StopInstanceInput) SetInstanceName(v string) *StopInstanceInput {
	s.InstanceName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopInstanceResult
type StopInstanceOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the request operation.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s StopInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopInstanceOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *StopInstanceOutput) SetOperations(v []*Operation) *StopInstanceOutput {
	s.Operations = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UnpeerVpcRequest
type UnpeerVpcInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UnpeerVpcInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnpeerVpcInput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UnpeerVpcResult
type UnpeerVpcOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the request operation.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s UnpeerVpcOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnpeerVpcOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *UnpeerVpcOutput) SetOperation(v *Operation) *UnpeerVpcOutput {
	s.Operation = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDomainEntryRequest
type UpdateDomainEntryInput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the domain entry.
	//
	// DomainEntry is a required field
	DomainEntry *DomainEntry `locationName:"domainEntry" type:"structure" required:"true"`

	// The name of the domain recordset to update.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDomainEntryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainEntryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDomainEntryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDomainEntryInput"}
	if s.DomainEntry == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainEntry"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainEntry sets the DomainEntry field's value.
func (s *UpdateDomainEntryInput) SetDomainEntry(v *DomainEntry) *UpdateDomainEntryInput {
	s.DomainEntry = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpdateDomainEntryInput) SetDomainName(v string) *UpdateDomainEntryInput {
	s.DomainName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDomainEntryResult
type UpdateDomainEntryOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the request operation.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s UpdateDomainEntryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainEntryOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *UpdateDomainEntryOutput) SetOperations(v []*Operation) *UpdateDomainEntryOutput {
	s.Operations = v
	return s
}

const (
	// AccessDirectionInbound is a AccessDirection enum value
	AccessDirectionInbound = "inbound"

	// AccessDirectionOutbound is a AccessDirection enum value
	AccessDirectionOutbound = "outbound"
)

const (
	// BlueprintTypeOs is a BlueprintType enum value
	BlueprintTypeOs = "os"

	// BlueprintTypeApp is a BlueprintType enum value
	BlueprintTypeApp = "app"
)

const (
	// InstanceAccessProtocolSsh is a InstanceAccessProtocol enum value
	InstanceAccessProtocolSsh = "ssh"

	// InstanceAccessProtocolRdp is a InstanceAccessProtocol enum value
	InstanceAccessProtocolRdp = "rdp"
)

const (
	// InstanceMetricNameCpuutilization is a InstanceMetricName enum value
	InstanceMetricNameCpuutilization = "CPUUtilization"

	// InstanceMetricNameNetworkIn is a InstanceMetricName enum value
	InstanceMetricNameNetworkIn = "NetworkIn"

	// InstanceMetricNameNetworkOut is a InstanceMetricName enum value
	InstanceMetricNameNetworkOut = "NetworkOut"

	// InstanceMetricNameStatusCheckFailed is a InstanceMetricName enum value
	InstanceMetricNameStatusCheckFailed = "StatusCheckFailed"

	// InstanceMetricNameStatusCheckFailedInstance is a InstanceMetricName enum value
	InstanceMetricNameStatusCheckFailedInstance = "StatusCheckFailed_Instance"

	// InstanceMetricNameStatusCheckFailedSystem is a InstanceMetricName enum value
	InstanceMetricNameStatusCheckFailedSystem = "StatusCheckFailed_System"
)

const (
	// InstancePlatformLinuxUnix is a InstancePlatform enum value
	InstancePlatformLinuxUnix = "LINUX_UNIX"

	// InstancePlatformWindows is a InstancePlatform enum value
	InstancePlatformWindows = "WINDOWS"
)

const (
	// InstanceSnapshotStatePending is a InstanceSnapshotState enum value
	InstanceSnapshotStatePending = "pending"

	// InstanceSnapshotStateError is a InstanceSnapshotState enum value
	InstanceSnapshotStateError = "error"

	// InstanceSnapshotStateAvailable is a InstanceSnapshotState enum value
	InstanceSnapshotStateAvailable = "available"
)

const (
	// MetricStatisticMinimum is a MetricStatistic enum value
	MetricStatisticMinimum = "Minimum"

	// MetricStatisticMaximum is a MetricStatistic enum value
	MetricStatisticMaximum = "Maximum"

	// MetricStatisticSum is a MetricStatistic enum value
	MetricStatisticSum = "Sum"

	// MetricStatisticAverage is a MetricStatistic enum value
	MetricStatisticAverage = "Average"

	// MetricStatisticSampleCount is a MetricStatistic enum value
	MetricStatisticSampleCount = "SampleCount"
)

const (
	// MetricUnitSeconds is a MetricUnit enum value
	MetricUnitSeconds = "Seconds"

	// MetricUnitMicroseconds is a MetricUnit enum value
	MetricUnitMicroseconds = "Microseconds"

	// MetricUnitMilliseconds is a MetricUnit enum value
	MetricUnitMilliseconds = "Milliseconds"

	// MetricUnitBytes is a MetricUnit enum value
	MetricUnitBytes = "Bytes"

	// MetricUnitKilobytes is a MetricUnit enum value
	MetricUnitKilobytes = "Kilobytes"

	// MetricUnitMegabytes is a MetricUnit enum value
	MetricUnitMegabytes = "Megabytes"

	// MetricUnitGigabytes is a MetricUnit enum value
	MetricUnitGigabytes = "Gigabytes"

	// MetricUnitTerabytes is a MetricUnit enum value
	MetricUnitTerabytes = "Terabytes"

	// MetricUnitBits is a MetricUnit enum value
	MetricUnitBits = "Bits"

	// MetricUnitKilobits is a MetricUnit enum value
	MetricUnitKilobits = "Kilobits"

	// MetricUnitMegabits is a MetricUnit enum value
	MetricUnitMegabits = "Megabits"

	// MetricUnitGigabits is a MetricUnit enum value
	MetricUnitGigabits = "Gigabits"

	// MetricUnitTerabits is a MetricUnit enum value
	MetricUnitTerabits = "Terabits"

	// MetricUnitPercent is a MetricUnit enum value
	MetricUnitPercent = "Percent"

	// MetricUnitCount is a MetricUnit enum value
	MetricUnitCount = "Count"

	// MetricUnitBytesSecond is a MetricUnit enum value
	MetricUnitBytesSecond = "Bytes/Second"

	// MetricUnitKilobytesSecond is a MetricUnit enum value
	MetricUnitKilobytesSecond = "Kilobytes/Second"

	// MetricUnitMegabytesSecond is a MetricUnit enum value
	MetricUnitMegabytesSecond = "Megabytes/Second"

	// MetricUnitGigabytesSecond is a MetricUnit enum value
	MetricUnitGigabytesSecond = "Gigabytes/Second"

	// MetricUnitTerabytesSecond is a MetricUnit enum value
	MetricUnitTerabytesSecond = "Terabytes/Second"

	// MetricUnitBitsSecond is a MetricUnit enum value
	MetricUnitBitsSecond = "Bits/Second"

	// MetricUnitKilobitsSecond is a MetricUnit enum value
	MetricUnitKilobitsSecond = "Kilobits/Second"

	// MetricUnitMegabitsSecond is a MetricUnit enum value
	MetricUnitMegabitsSecond = "Megabits/Second"

	// MetricUnitGigabitsSecond is a MetricUnit enum value
	MetricUnitGigabitsSecond = "Gigabits/Second"

	// MetricUnitTerabitsSecond is a MetricUnit enum value
	MetricUnitTerabitsSecond = "Terabits/Second"

	// MetricUnitCountSecond is a MetricUnit enum value
	MetricUnitCountSecond = "Count/Second"

	// MetricUnitNone is a MetricUnit enum value
	MetricUnitNone = "None"
)

const (
	// NetworkProtocolTcp is a NetworkProtocol enum value
	NetworkProtocolTcp = "tcp"

	// NetworkProtocolAll is a NetworkProtocol enum value
	NetworkProtocolAll = "all"

	// NetworkProtocolUdp is a NetworkProtocol enum value
	NetworkProtocolUdp = "udp"
)

const (
	// OperationStatusNotStarted is a OperationStatus enum value
	OperationStatusNotStarted = "NotStarted"

	// OperationStatusStarted is a OperationStatus enum value
	OperationStatusStarted = "Started"

	// OperationStatusFailed is a OperationStatus enum value
	OperationStatusFailed = "Failed"

	// OperationStatusCompleted is a OperationStatus enum value
	OperationStatusCompleted = "Completed"
)

const (
	// OperationTypeDeleteInstance is a OperationType enum value
	OperationTypeDeleteInstance = "DeleteInstance"

	// OperationTypeCreateInstance is a OperationType enum value
	OperationTypeCreateInstance = "CreateInstance"

	// OperationTypeStopInstance is a OperationType enum value
	OperationTypeStopInstance = "StopInstance"

	// OperationTypeStartInstance is a OperationType enum value
	OperationTypeStartInstance = "StartInstance"

	// OperationTypeRebootInstance is a OperationType enum value
	OperationTypeRebootInstance = "RebootInstance"

	// OperationTypeOpenInstancePublicPorts is a OperationType enum value
	OperationTypeOpenInstancePublicPorts = "OpenInstancePublicPorts"

	// OperationTypePutInstancePublicPorts is a OperationType enum value
	OperationTypePutInstancePublicPorts = "PutInstancePublicPorts"

	// OperationTypeCloseInstancePublicPorts is a OperationType enum value
	OperationTypeCloseInstancePublicPorts = "CloseInstancePublicPorts"

	// OperationTypeAllocateStaticIp is a OperationType enum value
	OperationTypeAllocateStaticIp = "AllocateStaticIp"

	// OperationTypeReleaseStaticIp is a OperationType enum value
	OperationTypeReleaseStaticIp = "ReleaseStaticIp"

	// OperationTypeAttachStaticIp is a OperationType enum value
	OperationTypeAttachStaticIp = "AttachStaticIp"

	// OperationTypeDetachStaticIp is a OperationType enum value
	OperationTypeDetachStaticIp = "DetachStaticIp"

	// OperationTypeUpdateDomainEntry is a OperationType enum value
	OperationTypeUpdateDomainEntry = "UpdateDomainEntry"

	// OperationTypeDeleteDomainEntry is a OperationType enum value
	OperationTypeDeleteDomainEntry = "DeleteDomainEntry"

	// OperationTypeCreateDomain is a OperationType enum value
	OperationTypeCreateDomain = "CreateDomain"

	// OperationTypeDeleteDomain is a OperationType enum value
	OperationTypeDeleteDomain = "DeleteDomain"

	// OperationTypeCreateInstanceSnapshot is a OperationType enum value
	OperationTypeCreateInstanceSnapshot = "CreateInstanceSnapshot"

	// OperationTypeDeleteInstanceSnapshot is a OperationType enum value
	OperationTypeDeleteInstanceSnapshot = "DeleteInstanceSnapshot"

	// OperationTypeCreateInstancesFromSnapshot is a OperationType enum value
	OperationTypeCreateInstancesFromSnapshot = "CreateInstancesFromSnapshot"
)

const (
	// PortAccessTypePublic is a PortAccessType enum value
	PortAccessTypePublic = "Public"

	// PortAccessTypePrivate is a PortAccessType enum value
	PortAccessTypePrivate = "Private"
)

const (
	// PortStateOpen is a PortState enum value
	PortStateOpen = "open"

	// PortStateClosed is a PortState enum value
	PortStateClosed = "closed"
)

const (
	// RegionNameUsEast1 is a RegionName enum value
	RegionNameUsEast1 = "us-east-1"

	// RegionNameUsEast2 is a RegionName enum value
	RegionNameUsEast2 = "us-east-2"

	// RegionNameUsWest1 is a RegionName enum value
	RegionNameUsWest1 = "us-west-1"

	// RegionNameUsWest2 is a RegionName enum value
	RegionNameUsWest2 = "us-west-2"

	// RegionNameEuWest1 is a RegionName enum value
	RegionNameEuWest1 = "eu-west-1"

	// RegionNameEuCentral1 is a RegionName enum value
	RegionNameEuCentral1 = "eu-central-1"

	// RegionNameApSouth1 is a RegionName enum value
	RegionNameApSouth1 = "ap-south-1"

	// RegionNameApSoutheast1 is a RegionName enum value
	RegionNameApSoutheast1 = "ap-southeast-1"

	// RegionNameApSoutheast2 is a RegionName enum value
	RegionNameApSoutheast2 = "ap-southeast-2"

	// RegionNameApNortheast1 is a RegionName enum value
	RegionNameApNortheast1 = "ap-northeast-1"

	// RegionNameApNortheast2 is a RegionName enum value
	RegionNameApNortheast2 = "ap-northeast-2"
)

const (
	// ResourceTypeInstance is a ResourceType enum value
	ResourceTypeInstance = "Instance"

	// ResourceTypeStaticIp is a ResourceType enum value
	ResourceTypeStaticIp = "StaticIp"

	// ResourceTypeKeyPair is a ResourceType enum value
	ResourceTypeKeyPair = "KeyPair"

	// ResourceTypeInstanceSnapshot is a ResourceType enum value
	ResourceTypeInstanceSnapshot = "InstanceSnapshot"

	// ResourceTypeDomain is a ResourceType enum value
	ResourceTypeDomain = "Domain"

	// ResourceTypePeeredVpc is a ResourceType enum value
	ResourceTypePeeredVpc = "PeeredVpc"
)
