# Twitch SOA Bootcamp

## Goal
The purpose of this exercise is to get hands on experience working with the data provided by Twitch's services

## Prerequisites
Before we begin, please ensure you have the following set up:
* Go version 1.8 or higher
* LDAP
* A connection to JTV-SFO-WPA2

To download this repo: ```go get -u code.justin.tv/bootcamp/services```

## Services
These are the services you’ll be working with today:

[Jax](https://git-aws.internal.justin.tv/web/jax) - Manages live stream data  
[Following Service](https://git-aws.internal.justin.tv/feeds/following-service) - Manages follower data  
[Users Service](https://git-aws.internal.justin.tv/web/users-service) - Manages user data  
[Clips](https://git-aws.internal.justin.tv/video/clips-upload) - Manages Clips data  

## Twitch Command Line Tool
In this exercise, we'll build a command line tool for Twitch.

At Twitch, service teams develop clients for other engineers to interface with their services.  These clients can then be imported by other teams to make requests and fetch the data they need. The definition for these clients live under clients/ of the project they belong to.

We’ve given you a bare bones implementation of the CLI and have implemented **get-user-by-login <username>** . Your task is to implement the rest of the commands.

## What you will implement
1. **get-user-by-login <username>**  [This is already implemented as an example]
Fetch the info for a given user, including the user_id. You can use this to supply the user id for other commands that you’ll be implementing today
2. **get-user-by-id <user id>**  [There is a placeholder for this, fill in the gaps!]
Fetch the info for a given user
3. **live-streams**  
List the top 10 live streams from Twitch  
4. **follows-by-id <user id>**
List up to 10 people that the given user is following
5. **followed-clips <user id>**  
List the top clip for each broadcaster that the given user is following, limited to 10 results

Each command is implemented under [cmd](https://git-aws.internal.justin.tv/bootcamp/services/tree/master/cmd) and wired up in [main.go](https://git-aws.internal.justin.tv/bootcamp/services/blob/master/main.go)

## Example

We've implemented the first command that fetches user information given a user's login
```
go run main.go get-user-by-login zombiechou
```
