package backend

import (
	"context"
	"fmt"

	"github.com/afex/hystrix-go/hystrix"

	"code.justin.tv/bootcamp/services/clients"
	usermodels "code.justin.tv/web/users-service/models"
)

var ctx = context.Background()

func init() {
	hystrix.ConfigureCommand("fetch_user_by_id", hystrix.CommandConfig{
		Timeout:               2000,
		MaxConcurrentRequests: 1,
		ErrorPercentThreshold: 25,
	})

	hystrix.ConfigureCommand("fetch_user_by_login", hystrix.CommandConfig{
		Timeout:               2000,
		MaxConcurrentRequests: 1,
		ErrorPercentThreshold: 25,
	})
}

type Backender interface {
	FetchUserByID(userID string) (*usermodels.Properties, error)
	FetchUserByLogin(userID string) (*usermodels.Properties, error)
}

type Backend struct {
	Downstreams *clients.Clients
}

func (b *Backend) FetchUserByID(userID string) (*usermodels.Properties, error) {
	var output *usermodels.Properties
	hystrixErr := hystrix.Do("fetch_user_by_id", func() error {
		/*
			TASK ONE:
			Implement the call to the Users-Service here to fetch the correct User.
		*/
		return fmt.Errorf("Not yet implemented")
	}, nil) // This is where we define fallback behavior if we want

	if hystrixErr != nil {
		return nil, hystrixErr
	}

	return output, nil
}

func (b *Backend) FetchUserByLogin(login string) (*usermodels.Properties, error) {
	var output *usermodels.Properties
	hystrixErr := hystrix.Do("fetch_user_by_login", func() error {
		user, err := b.Downstreams.Users.GetUserByLogin(ctx, login, nil)
		if err != nil {
			return err
		}
		output = user
		return nil
	}, nil)

	if hystrixErr != nil {
		return nil, hystrixErr
	}

	return output, nil
}
