package clients

import (
	"log"

	"code.justin.tv/common/twitchhttp"
	"code.justin.tv/foundation/twitchclient"

	follows "code.justin.tv/feeds/following-service/client/follows"
	clips "code.justin.tv/video/clips-upload/client/clipsv2"
	vinyl "code.justin.tv/vod/vinyl/client"
	jax "code.justin.tv/web/jax/client"
	users "code.justin.tv/web/users-service/client"
)

type Clients struct {
	Users   users.Client
	Vinyl   vinyl.Client
	Jax     jax.Client
	Follows follows.Client
	Clips   clips.Client
}

func Initialize() *Clients {
	usersConf := twitchhttp.ClientConf{
		Host: "https://web-users-service.dev.us-west2.justin.tv",
	}
	usersClient, err := users.NewClient(usersConf)
	if err != nil {
		log.Fatalf("failed to create users client: %v", err)
	}

	vinylConf := twitchclient.ClientConf{
		Host: "http://vinyl-internal.staging.us-west2.twitch.tv",
	}
	vinylClient, err := vinyl.NewClient(vinylConf)
	if err != nil {
		log.Fatalf("failed to create vinyl client: %v", err)
	}

	jaxConf := twitchclient.ClientConf{
		Host: "http://jax-internal-staging.us-west2.justin.tv/",
	}
	jaxClient, err := jax.NewClient(jaxConf)
	if err != nil {
		log.Fatalf("failed to create jax client: %v", err)
	}

	followsConf := twitchhttp.ClientConf{
		Host: "http://internal-following-service-staging-app-2022864404.us-west-2.elb.amazonaws.com",
	}
	followsClient, err := follows.NewClient(followsConf)
	if err != nil {
		log.Fatalf("failed to create follows client: %v", err)
	}

	clipsConf := twitchhttp.ClientConf{
		Host: "https://clips.twitch.tv",
	}
	clipsClient, err := clips.NewClient(clipsConf)
	if err != nil {
		log.Fatalf("failed to create clips client: %v", err)
	}

	return &Clients{
		Users:   usersClient,
		Vinyl:   vinylClient,
		Jax:     jaxClient,
		Follows: followsClient,
		Clips:   clipsClient,
	}
}
