package cmd

import (
	"encoding/json"
	"fmt"

	"github.com/urfave/cli"

	"code.justin.tv/bootcamp/services/backend"
	users "code.justin.tv/web/users-service/client"
	usermodels "code.justin.tv/web/users-service/models"
)

func GetUserByID(c *cli.Context, b backend.Backender) error {
	id := c.Args().Get(0)
	if id == "" {
		return fmt.Errorf("You must specify a user!")
	}

	user, err := b.FetchUserByID(id)
	if err != nil {
		switch err.(type) {
		case *users.UserNotFoundError:
			return fmt.Errorf("That user is in another castle!")
		default:
			return fmt.Errorf("Failed to fetch user: %v", err)
		}
	}

	fmt.Println(formatUserResult(user))
	return nil
}

func GetUserByLogin(c *cli.Context, b backend.Backender) error {
	id := c.Args().Get(0)
	if id == "" {
		return fmt.Errorf("You must specify a user!")
	}

	user, err := b.FetchUserByLogin(id)
	if err != nil {
		switch err.(type) {
		case *users.UserNotFoundError:
			return fmt.Errorf("That user is in another castle!")
		default:
			return fmt.Errorf("Failed to fetch user: %v", err)
		}
	}

	fmt.Println(formatUserResult(user))
	return nil
}

func formatUserResult(user *usermodels.Properties) (string, error) {
	formattedUser, err := json.MarshalIndent(user, "", "\t")
	return string(formattedUser), err
}
