package main

import (
	"fmt"
	"os"

	"github.com/urfave/cli"

	"code.justin.tv/bootcamp/services/backend"
	"code.justin.tv/bootcamp/services/clients"
	"code.justin.tv/bootcamp/services/cmd"
)

func main() {
	app := cli.NewApp()

	backend := &backend.Backend{Downstreams: clients.Initialize()}

	app.Commands = []cli.Command{
		{
			Name:  "get-user-by-id",
			Usage: "get a Twitch user",
			Action: func(c *cli.Context) error {
				err := cmd.GetUserByID(c, backend)
				fmt.Println(err)
				return err
			},
		},
		{
			Name:  "get-user-by-login",
			Usage: "get a Twitch user",
			Action: func(c *cli.Context) error {
				err := cmd.GetUserByLogin(c, backend)
				fmt.Println(err)
				return err
			},
		},
	}

	app.Run(os.Args)
}
