package models

import (
	"fmt"
)

type ErrorResponse struct {
	Status     int    `json:"status"`
	Message    string `json:"message"`
	StatusText string `json:"error"`
	ErrorCode  string `json:"error_code"`
}

func (T ErrorResponse) Error() string {
	return fmt.Sprintf("Error (%d): %s", T.Status, T.Message)
}

func (T ErrorResponse) StatusCode() int {
	return T.Status
}
