# Vinyl

VOD Metadata API

## Environments

Example GET requests in different environments

Production: http://vinyl-internal.production.us-west2.twitch.tv/v1/vods?ids=17714623

Staging: http://vinyl-internal.staging.us-west2.twitch.tv/v1/vods?ids=17714623

## Development

The [Development](docs/development/) document has guides for setting up and running vinyl locally.

## Go Dependencies (Glide)

Vinyl's dependencies are managed with [Glide](https://glide.sh/).

When adding or updating a dependency, upload any of your changes to origin, then add or edit the entry in `glide.yaml`
while setting `version` to the commit SHA of your change. Then run `make upgrade` in the Vinyl repo to pull in your
changes.

## Tests

A guide for setting up and running tests can be found in [Development](docs/development#tests)

## Vod Data Fields

[Vod Data Fields](datastore/README.md)

## Migration Policy

A guide for our migration policy and how to run migrations can be found in [Development](docs/development#migrations)

# [Docs and Guides](docs/)

* **[Development](docs/development/) - How to setup and run Vinyl**
* **[Operations](docs/operations/) - Overview of Vinyl's infrastructure setup**
* **[SearchIndexer Auditing](docs/searchindexer-auditing/)**
