// Code generated by protoc-gen-go.
// source: topodata.proto
// DO NOT EDIT!

/*
Package topodata is a generated protocol buffer package.

It is generated from these files:
	topodata.proto

It has these top-level messages:
	KeyRange
	TabletAlias
	Tablet
	Shard
	Keyspace
	ShardReplication
	EndPoint
	EndPoints
	SrvShard
	ShardReference
	SrvKeyspace
*/
package topodata

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
const _ = proto.ProtoPackageIsVersion1

// KeyspaceIdType describes the type of the sharding key for a
// range-based sharded keyspace.
type KeyspaceIdType int32

const (
	// UNSET is the default value, when range-based sharding is not used.
	KeyspaceIdType_UNSET KeyspaceIdType = 0
	// UINT64 is when uint64 value is used.
	// This is represented as 'unsigned bigint' in mysql
	KeyspaceIdType_UINT64 KeyspaceIdType = 1
	// BYTES is when an array of bytes is used.
	// This is represented as 'varbinary' in mysql
	KeyspaceIdType_BYTES KeyspaceIdType = 2
)

var KeyspaceIdType_name = map[int32]string{
	0: "UNSET",
	1: "UINT64",
	2: "BYTES",
}
var KeyspaceIdType_value = map[string]int32{
	"UNSET":  0,
	"UINT64": 1,
	"BYTES":  2,
}

func (x KeyspaceIdType) String() string {
	return proto.EnumName(KeyspaceIdType_name, int32(x))
}
func (KeyspaceIdType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// TabletType represents the type of a given tablet.
type TabletType int32

const (
	TabletType_UNKNOWN      TabletType = 0
	TabletType_MASTER       TabletType = 1
	TabletType_REPLICA      TabletType = 2
	TabletType_RDONLY       TabletType = 3
	TabletType_BATCH        TabletType = 3
	TabletType_SPARE        TabletType = 4
	TabletType_EXPERIMENTAL TabletType = 5
	TabletType_BACKUP       TabletType = 6
	TabletType_RESTORE      TabletType = 7
	TabletType_WORKER       TabletType = 8
)

var TabletType_name = map[int32]string{
	0: "UNKNOWN",
	1: "MASTER",
	2: "REPLICA",
	3: "RDONLY",
	// Duplicate value: 3: "BATCH",
	4: "SPARE",
	5: "EXPERIMENTAL",
	6: "BACKUP",
	7: "RESTORE",
	8: "WORKER",
}
var TabletType_value = map[string]int32{
	"UNKNOWN":      0,
	"MASTER":       1,
	"REPLICA":      2,
	"RDONLY":       3,
	"BATCH":        3,
	"SPARE":        4,
	"EXPERIMENTAL": 5,
	"BACKUP":       6,
	"RESTORE":      7,
	"WORKER":       8,
}

func (x TabletType) String() string {
	return proto.EnumName(TabletType_name, int32(x))
}
func (TabletType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// KeyRange describes a range of sharding keys, when range-based
// sharding is used.
type KeyRange struct {
	Start []byte `protobuf:"bytes,1,opt,name=start,proto3" json:"start,omitempty"`
	End   []byte `protobuf:"bytes,2,opt,name=end,proto3" json:"end,omitempty"`
}

func (m *KeyRange) Reset()                    { *m = KeyRange{} }
func (m *KeyRange) String() string            { return proto.CompactTextString(m) }
func (*KeyRange) ProtoMessage()               {}
func (*KeyRange) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// TabletAlias is a globally unique tablet identifier.
type TabletAlias struct {
	// cell is the cell (or datacenter) the tablet is in
	Cell string `protobuf:"bytes,1,opt,name=cell" json:"cell,omitempty"`
	// uid is a unique id for this tablet within the shard
	// (this is the MySQL server id as well).
	Uid uint32 `protobuf:"varint,2,opt,name=uid" json:"uid,omitempty"`
}

func (m *TabletAlias) Reset()                    { *m = TabletAlias{} }
func (m *TabletAlias) String() string            { return proto.CompactTextString(m) }
func (*TabletAlias) ProtoMessage()               {}
func (*TabletAlias) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// Tablet represents information about a running instance of vttablet.
type Tablet struct {
	// alias is the unique name of the tablet.
	Alias *TabletAlias `protobuf:"bytes,1,opt,name=alias" json:"alias,omitempty"`
	// Fully qualified domain name of the host.
	Hostname string `protobuf:"bytes,2,opt,name=hostname" json:"hostname,omitempty"`
	// IP address, stored as a string.
	Ip string `protobuf:"bytes,3,opt,name=ip" json:"ip,omitempty"`
	// Map of named ports. Normally this should include vt, grpc, and mysql.
	PortMap map[string]int32 `protobuf:"bytes,4,rep,name=port_map" json:"port_map,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	// Keyspace name.
	Keyspace string `protobuf:"bytes,5,opt,name=keyspace" json:"keyspace,omitempty"`
	// Shard name. If range based sharding is used, it should match
	// key_range.
	Shard string `protobuf:"bytes,6,opt,name=shard" json:"shard,omitempty"`
	// If range based sharding is used, range for the tablet's shard.
	KeyRange *KeyRange `protobuf:"bytes,7,opt,name=key_range" json:"key_range,omitempty"`
	// type is the current type of the tablet.
	Type TabletType `protobuf:"varint,8,opt,name=type,enum=topodata.TabletType" json:"type,omitempty"`
	// It this is set, it is used as the database name instead of the
	// normal "vt_" + keyspace.
	DbNameOverride string `protobuf:"bytes,9,opt,name=db_name_override" json:"db_name_override,omitempty"`
	// tablet tags
	Tags map[string]string `protobuf:"bytes,10,rep,name=tags" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// tablet health information
	HealthMap map[string]string `protobuf:"bytes,11,rep,name=health_map" json:"health_map,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *Tablet) Reset()                    { *m = Tablet{} }
func (m *Tablet) String() string            { return proto.CompactTextString(m) }
func (*Tablet) ProtoMessage()               {}
func (*Tablet) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *Tablet) GetAlias() *TabletAlias {
	if m != nil {
		return m.Alias
	}
	return nil
}

func (m *Tablet) GetPortMap() map[string]int32 {
	if m != nil {
		return m.PortMap
	}
	return nil
}

func (m *Tablet) GetKeyRange() *KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

func (m *Tablet) GetTags() map[string]string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Tablet) GetHealthMap() map[string]string {
	if m != nil {
		return m.HealthMap
	}
	return nil
}

// A Shard contains data about a subset of the data whithin a keyspace.
type Shard struct {
	// master_alias is the tablet alias of the master for the shard.
	// If it is unset, then there is no master in this shard yet.
	MasterAlias *TabletAlias `protobuf:"bytes,1,opt,name=master_alias" json:"master_alias,omitempty"`
	// key_range is the KeyRange for this shard. It can be unset if:
	// - we are not using range-based sharding in this shard.
	// - the shard covers the entire keyrange.
	// This must match the shard name based on our other conventions, but
	// helpful to have it decomposed here.
	KeyRange *KeyRange `protobuf:"bytes,2,opt,name=key_range" json:"key_range,omitempty"`
	// served_types has at most one entry per TabletType
	ServedTypes []*Shard_ServedType `protobuf:"bytes,3,rep,name=served_types" json:"served_types,omitempty"`
	// SourceShards is the list of shards we're replicating from,
	// using filtered replication.
	SourceShards []*Shard_SourceShard `protobuf:"bytes,4,rep,name=source_shards" json:"source_shards,omitempty"`
	// Cells is the list of cells that contain tablets for this shard.
	Cells []string `protobuf:"bytes,5,rep,name=cells" json:"cells,omitempty"`
	// tablet_controls has at most one entry per TabletType
	TabletControls []*Shard_TabletControl `protobuf:"bytes,6,rep,name=tablet_controls" json:"tablet_controls,omitempty"`
}

func (m *Shard) Reset()                    { *m = Shard{} }
func (m *Shard) String() string            { return proto.CompactTextString(m) }
func (*Shard) ProtoMessage()               {}
func (*Shard) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *Shard) GetMasterAlias() *TabletAlias {
	if m != nil {
		return m.MasterAlias
	}
	return nil
}

func (m *Shard) GetKeyRange() *KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

func (m *Shard) GetServedTypes() []*Shard_ServedType {
	if m != nil {
		return m.ServedTypes
	}
	return nil
}

func (m *Shard) GetSourceShards() []*Shard_SourceShard {
	if m != nil {
		return m.SourceShards
	}
	return nil
}

func (m *Shard) GetTabletControls() []*Shard_TabletControl {
	if m != nil {
		return m.TabletControls
	}
	return nil
}

// ServedType is an entry in the served_types
type Shard_ServedType struct {
	TabletType TabletType `protobuf:"varint,1,opt,name=tablet_type,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	Cells      []string   `protobuf:"bytes,2,rep,name=cells" json:"cells,omitempty"`
}

func (m *Shard_ServedType) Reset()                    { *m = Shard_ServedType{} }
func (m *Shard_ServedType) String() string            { return proto.CompactTextString(m) }
func (*Shard_ServedType) ProtoMessage()               {}
func (*Shard_ServedType) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3, 0} }

// SourceShard represents a data source for filtered replication
// accross shards. When this is used in a destination shard, the master
// of that shard will run filtered replication.
type Shard_SourceShard struct {
	// Uid is the unique ID for this SourceShard object.
	Uid uint32 `protobuf:"varint,1,opt,name=uid" json:"uid,omitempty"`
	// the source keyspace
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace" json:"keyspace,omitempty"`
	// the source shard
	Shard string `protobuf:"bytes,3,opt,name=shard" json:"shard,omitempty"`
	// the source shard keyrange
	KeyRange *KeyRange `protobuf:"bytes,4,opt,name=key_range" json:"key_range,omitempty"`
	// the source table list to replicate
	Tables []string `protobuf:"bytes,5,rep,name=tables" json:"tables,omitempty"`
}

func (m *Shard_SourceShard) Reset()                    { *m = Shard_SourceShard{} }
func (m *Shard_SourceShard) String() string            { return proto.CompactTextString(m) }
func (*Shard_SourceShard) ProtoMessage()               {}
func (*Shard_SourceShard) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3, 1} }

func (m *Shard_SourceShard) GetKeyRange() *KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

// TabletControl controls tablet's behavior
type Shard_TabletControl struct {
	// which tablet type is affected
	TabletType TabletType `protobuf:"varint,1,opt,name=tablet_type,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	Cells      []string   `protobuf:"bytes,2,rep,name=cells" json:"cells,omitempty"`
	// what to do
	DisableQueryService bool     `protobuf:"varint,3,opt,name=disable_query_service" json:"disable_query_service,omitempty"`
	BlacklistedTables   []string `protobuf:"bytes,4,rep,name=blacklisted_tables" json:"blacklisted_tables,omitempty"`
}

func (m *Shard_TabletControl) Reset()                    { *m = Shard_TabletControl{} }
func (m *Shard_TabletControl) String() string            { return proto.CompactTextString(m) }
func (*Shard_TabletControl) ProtoMessage()               {}
func (*Shard_TabletControl) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3, 2} }

// A Keyspace contains data about a keyspace.
type Keyspace struct {
	// name of the column used for sharding
	// empty if the keyspace is not sharded
	ShardingColumnName string `protobuf:"bytes,1,opt,name=sharding_column_name" json:"sharding_column_name,omitempty"`
	// type of the column used for sharding
	// UNSET if the keyspace is not sharded
	ShardingColumnType KeyspaceIdType `protobuf:"varint,2,opt,name=sharding_column_type,enum=topodata.KeyspaceIdType" json:"sharding_column_type,omitempty"`
	// SplitShardCount stores the number of jobs to run to be sure to
	// always have at most one job per shard (used during resharding).
	SplitShardCount int32 `protobuf:"varint,3,opt,name=split_shard_count" json:"split_shard_count,omitempty"`
	// ServedFrom will redirect the appropriate traffic to
	// another keyspace.
	ServedFroms []*Keyspace_ServedFrom `protobuf:"bytes,4,rep,name=served_froms" json:"served_froms,omitempty"`
}

func (m *Keyspace) Reset()                    { *m = Keyspace{} }
func (m *Keyspace) String() string            { return proto.CompactTextString(m) }
func (*Keyspace) ProtoMessage()               {}
func (*Keyspace) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *Keyspace) GetServedFroms() []*Keyspace_ServedFrom {
	if m != nil {
		return m.ServedFroms
	}
	return nil
}

// ServedFrom indicates a relationship between a TabletType and the
// keyspace name that's serving it.
type Keyspace_ServedFrom struct {
	// the tablet type (key for the map)
	TabletType TabletType `protobuf:"varint,1,opt,name=tablet_type,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// the cells to limit this to
	Cells []string `protobuf:"bytes,2,rep,name=cells" json:"cells,omitempty"`
	// the keyspace name that's serving it
	Keyspace string `protobuf:"bytes,3,opt,name=keyspace" json:"keyspace,omitempty"`
}

func (m *Keyspace_ServedFrom) Reset()                    { *m = Keyspace_ServedFrom{} }
func (m *Keyspace_ServedFrom) String() string            { return proto.CompactTextString(m) }
func (*Keyspace_ServedFrom) ProtoMessage()               {}
func (*Keyspace_ServedFrom) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4, 0} }

// ShardReplication describes the MySQL replication relationships
// whithin a cell.
type ShardReplication struct {
	// Note there can be only one Node in this array
	// for a given tablet.
	Nodes []*ShardReplication_Node `protobuf:"bytes,1,rep,name=nodes" json:"nodes,omitempty"`
}

func (m *ShardReplication) Reset()                    { *m = ShardReplication{} }
func (m *ShardReplication) String() string            { return proto.CompactTextString(m) }
func (*ShardReplication) ProtoMessage()               {}
func (*ShardReplication) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *ShardReplication) GetNodes() []*ShardReplication_Node {
	if m != nil {
		return m.Nodes
	}
	return nil
}

// Node describes a tablet instance within the cell
type ShardReplication_Node struct {
	TabletAlias *TabletAlias `protobuf:"bytes,1,opt,name=tablet_alias" json:"tablet_alias,omitempty"`
}

func (m *ShardReplication_Node) Reset()                    { *m = ShardReplication_Node{} }
func (m *ShardReplication_Node) String() string            { return proto.CompactTextString(m) }
func (*ShardReplication_Node) ProtoMessage()               {}
func (*ShardReplication_Node) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5, 0} }

func (m *ShardReplication_Node) GetTabletAlias() *TabletAlias {
	if m != nil {
		return m.TabletAlias
	}
	return nil
}

// EndPoint corresponds to a single tablet.
type EndPoint struct {
	// The uid of the tablet.
	Uid uint32 `protobuf:"varint,1,opt,name=uid" json:"uid,omitempty"`
	// The host the tablet is running on (FQDN).
	Host string `protobuf:"bytes,2,opt,name=host" json:"host,omitempty"`
	// The ports opened for service.
	PortMap map[string]int32 `protobuf:"bytes,3,rep,name=port_map" json:"port_map,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	// The health entries.
	HealthMap map[string]string `protobuf:"bytes,4,rep,name=health_map" json:"health_map,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *EndPoint) Reset()                    { *m = EndPoint{} }
func (m *EndPoint) String() string            { return proto.CompactTextString(m) }
func (*EndPoint) ProtoMessage()               {}
func (*EndPoint) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *EndPoint) GetPortMap() map[string]int32 {
	if m != nil {
		return m.PortMap
	}
	return nil
}

func (m *EndPoint) GetHealthMap() map[string]string {
	if m != nil {
		return m.HealthMap
	}
	return nil
}

// EndPoints corresponds to a list of tablets.
type EndPoints struct {
	Entries []*EndPoint `protobuf:"bytes,1,rep,name=entries" json:"entries,omitempty"`
}

func (m *EndPoints) Reset()                    { *m = EndPoints{} }
func (m *EndPoints) String() string            { return proto.CompactTextString(m) }
func (*EndPoints) ProtoMessage()               {}
func (*EndPoints) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *EndPoints) GetEntries() []*EndPoint {
	if m != nil {
		return m.Entries
	}
	return nil
}

// SrvShard is a rollup node for the shard itself.
type SrvShard struct {
	// Copied from Shard.
	Name     string    `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	KeyRange *KeyRange `protobuf:"bytes,2,opt,name=key_range" json:"key_range,omitempty"`
	// The cell that master tablet resides in.
	MasterCell string `protobuf:"bytes,3,opt,name=master_cell" json:"master_cell,omitempty"`
}

func (m *SrvShard) Reset()                    { *m = SrvShard{} }
func (m *SrvShard) String() string            { return proto.CompactTextString(m) }
func (*SrvShard) ProtoMessage()               {}
func (*SrvShard) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *SrvShard) GetKeyRange() *KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

// ShardReference is used as a pointer from a SrvKeyspace to a SrvShard
type ShardReference struct {
	// Copied from Shard.
	Name     string    `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	KeyRange *KeyRange `protobuf:"bytes,2,opt,name=key_range" json:"key_range,omitempty"`
}

func (m *ShardReference) Reset()                    { *m = ShardReference{} }
func (m *ShardReference) String() string            { return proto.CompactTextString(m) }
func (*ShardReference) ProtoMessage()               {}
func (*ShardReference) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *ShardReference) GetKeyRange() *KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

// SrvKeyspace is a rollup node for the keyspace itself.
type SrvKeyspace struct {
	// The partitions this keyspace is serving, per tablet type.
	Partitions []*SrvKeyspace_KeyspacePartition `protobuf:"bytes,1,rep,name=partitions" json:"partitions,omitempty"`
	// copied from Keyspace
	ShardingColumnName string                    `protobuf:"bytes,2,opt,name=sharding_column_name" json:"sharding_column_name,omitempty"`
	ShardingColumnType KeyspaceIdType            `protobuf:"varint,3,opt,name=sharding_column_type,enum=topodata.KeyspaceIdType" json:"sharding_column_type,omitempty"`
	ServedFrom         []*SrvKeyspace_ServedFrom `protobuf:"bytes,4,rep,name=served_from" json:"served_from,omitempty"`
	SplitShardCount    int32                     `protobuf:"varint,5,opt,name=split_shard_count" json:"split_shard_count,omitempty"`
}

func (m *SrvKeyspace) Reset()                    { *m = SrvKeyspace{} }
func (m *SrvKeyspace) String() string            { return proto.CompactTextString(m) }
func (*SrvKeyspace) ProtoMessage()               {}
func (*SrvKeyspace) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *SrvKeyspace) GetPartitions() []*SrvKeyspace_KeyspacePartition {
	if m != nil {
		return m.Partitions
	}
	return nil
}

func (m *SrvKeyspace) GetServedFrom() []*SrvKeyspace_ServedFrom {
	if m != nil {
		return m.ServedFrom
	}
	return nil
}

type SrvKeyspace_KeyspacePartition struct {
	// The type this partition applies to.
	ServedType TabletType `protobuf:"varint,1,opt,name=served_type,enum=topodata.TabletType" json:"served_type,omitempty"`
	// List of non-overlapping continuous shards sorted by range.
	ShardReferences []*ShardReference `protobuf:"bytes,2,rep,name=shard_references" json:"shard_references,omitempty"`
}

func (m *SrvKeyspace_KeyspacePartition) Reset()         { *m = SrvKeyspace_KeyspacePartition{} }
func (m *SrvKeyspace_KeyspacePartition) String() string { return proto.CompactTextString(m) }
func (*SrvKeyspace_KeyspacePartition) ProtoMessage()    {}
func (*SrvKeyspace_KeyspacePartition) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{10, 0}
}

func (m *SrvKeyspace_KeyspacePartition) GetShardReferences() []*ShardReference {
	if m != nil {
		return m.ShardReferences
	}
	return nil
}

// ServedFrom indicates a relationship between a TabletType and the
// keyspace name that's serving it.
type SrvKeyspace_ServedFrom struct {
	// the tablet type
	TabletType TabletType `protobuf:"varint,1,opt,name=tablet_type,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// the keyspace name that's serving it
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace" json:"keyspace,omitempty"`
}

func (m *SrvKeyspace_ServedFrom) Reset()                    { *m = SrvKeyspace_ServedFrom{} }
func (m *SrvKeyspace_ServedFrom) String() string            { return proto.CompactTextString(m) }
func (*SrvKeyspace_ServedFrom) ProtoMessage()               {}
func (*SrvKeyspace_ServedFrom) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10, 1} }

func init() {
	proto.RegisterType((*KeyRange)(nil), "topodata.KeyRange")
	proto.RegisterType((*TabletAlias)(nil), "topodata.TabletAlias")
	proto.RegisterType((*Tablet)(nil), "topodata.Tablet")
	proto.RegisterType((*Shard)(nil), "topodata.Shard")
	proto.RegisterType((*Shard_ServedType)(nil), "topodata.Shard.ServedType")
	proto.RegisterType((*Shard_SourceShard)(nil), "topodata.Shard.SourceShard")
	proto.RegisterType((*Shard_TabletControl)(nil), "topodata.Shard.TabletControl")
	proto.RegisterType((*Keyspace)(nil), "topodata.Keyspace")
	proto.RegisterType((*Keyspace_ServedFrom)(nil), "topodata.Keyspace.ServedFrom")
	proto.RegisterType((*ShardReplication)(nil), "topodata.ShardReplication")
	proto.RegisterType((*ShardReplication_Node)(nil), "topodata.ShardReplication.Node")
	proto.RegisterType((*EndPoint)(nil), "topodata.EndPoint")
	proto.RegisterType((*EndPoints)(nil), "topodata.EndPoints")
	proto.RegisterType((*SrvShard)(nil), "topodata.SrvShard")
	proto.RegisterType((*ShardReference)(nil), "topodata.ShardReference")
	proto.RegisterType((*SrvKeyspace)(nil), "topodata.SrvKeyspace")
	proto.RegisterType((*SrvKeyspace_KeyspacePartition)(nil), "topodata.SrvKeyspace.KeyspacePartition")
	proto.RegisterType((*SrvKeyspace_ServedFrom)(nil), "topodata.SrvKeyspace.ServedFrom")
	proto.RegisterEnum("topodata.KeyspaceIdType", KeyspaceIdType_name, KeyspaceIdType_value)
	proto.RegisterEnum("topodata.TabletType", TabletType_name, TabletType_value)
}

var fileDescriptor0 = []byte{
	// 1033 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xa4, 0x56, 0xdd, 0x72, 0xda, 0x56,
	0x10, 0x2e, 0x12, 0xc2, 0xb0, 0xc2, 0x54, 0x51, 0x93, 0x19, 0x55, 0x6d, 0xa6, 0xae, 0xfa, 0xe7,
	0x24, 0x33, 0xd4, 0xc5, 0x8d, 0xa7, 0xd3, 0x5e, 0x61, 0x57, 0x99, 0x30, 0xb6, 0x31, 0x03, 0xf2,
	0x24, 0xb9, 0xd2, 0x08, 0x38, 0xb1, 0x35, 0x11, 0x92, 0x2a, 0x1d, 0xe8, 0x70, 0xdf, 0xab, 0xde,
	0xf4, 0x59, 0xfa, 0x1c, 0x7d, 0x9a, 0xbc, 0x41, 0xf7, 0x9c, 0x23, 0x61, 0x09, 0xec, 0x38, 0x71,
	0xae, 0x40, 0x9c, 0xef, 0xec, 0x7e, 0xbb, 0xdf, 0xb7, 0x2b, 0xa0, 0x45, 0xa3, 0x38, 0x9a, 0x7a,
	0xd4, 0x6b, 0xc7, 0x49, 0x44, 0x23, 0xbd, 0x9e, 0x3f, 0x5b, 0xdf, 0x43, 0xfd, 0x98, 0x2c, 0x87,
	0x5e, 0x78, 0x41, 0xf4, 0x6d, 0x50, 0x52, 0xea, 0x25, 0xd4, 0xa8, 0xec, 0x54, 0x76, 0x9b, 0xba,
	0x0a, 0x32, 0x09, 0xa7, 0x86, 0xc4, 0x1e, 0xac, 0x5d, 0x50, 0x1d, 0x6f, 0x1c, 0x10, 0xda, 0x0d,
	0x7c, 0x2f, 0xd5, 0x9b, 0x50, 0x9d, 0x90, 0x20, 0xe0, 0xc8, 0x06, 0x43, 0xce, 0x7d, 0x81, 0xdc,
	0xb6, 0xde, 0xca, 0x50, 0x13, 0x50, 0xfd, 0x5b, 0x50, 0x3c, 0x06, 0xe7, 0x30, 0xb5, 0xf3, 0xa0,
	0xbd, 0xa2, 0x51, 0x8c, 0xa5, 0x41, 0xfd, 0x32, 0x4a, 0x69, 0xe8, 0xcd, 0x08, 0x0f, 0xd1, 0xd0,
	0x01, 0x24, 0x3f, 0x36, 0x64, 0xfe, 0xfd, 0x47, 0xa8, 0xc7, 0x51, 0x42, 0xdd, 0x99, 0x17, 0x1b,
	0xd5, 0x1d, 0x19, 0xc3, 0x3c, 0x5c, 0x0f, 0xd3, 0x1e, 0x20, 0xe0, 0xd4, 0x8b, 0xed, 0x90, 0x26,
	0x4b, 0x16, 0xee, 0x0d, 0x59, 0xa6, 0xb1, 0x37, 0x21, 0x86, 0xc2, 0x43, 0xb0, 0xba, 0x2e, 0xbd,
	0x64, 0x6a, 0xd4, 0xf8, 0xe3, 0x77, 0xd0, 0x40, 0x80, 0x9b, 0xb0, 0x9a, 0x8d, 0x2d, 0xce, 0x4c,
	0xbf, 0x0a, 0xb9, 0xea, 0x86, 0x05, 0x55, 0xba, 0x8c, 0x89, 0x51, 0x47, 0x44, 0xab, 0x73, 0x7f,
	0x3d, 0xa9, 0x83, 0x67, 0xba, 0x01, 0xda, 0x74, 0xec, 0x32, 0xe6, 0x6e, 0xb4, 0x20, 0x49, 0xe2,
	0x4f, 0x89, 0xd1, 0xe0, 0x49, 0x76, 0xf1, 0xb6, 0x77, 0x91, 0x1a, 0xc0, 0x29, 0x9b, 0x1b, 0x94,
	0x1d, 0x3c, 0x14, 0x7c, 0xf7, 0x01, 0x2e, 0x89, 0x17, 0xd0, 0x4b, 0x5e, 0xa2, 0xca, 0xf1, 0x5f,
	0x6d, 0xe0, 0x9f, 0x73, 0x48, 0x5e, 0xa4, 0xd9, 0x86, 0x66, 0xa9, 0x68, 0x54, 0x00, 0x6b, 0xca,
	0xe4, 0xc0, 0x7a, 0x17, 0x5e, 0x30, 0x17, 0xdd, 0x54, 0x7e, 0x95, 0x7e, 0xa9, 0x98, 0x4f, 0xa0,
	0x71, 0x95, 0xf1, 0x66, 0x70, 0x83, 0x83, 0xf7, 0xa0, 0x55, 0x4e, 0x77, 0xdb, 0x0d, 0xeb, 0xbf,
	0x2a, 0x28, 0x23, 0xd6, 0x62, 0xfd, 0x09, 0x34, 0x67, 0x5e, 0x4a, 0x49, 0xe2, 0xbe, 0x87, 0xf2,
	0x25, 0x25, 0xa4, 0x1b, 0x95, 0xd8, 0x83, 0x66, 0x4a, 0x92, 0x05, 0x99, 0xba, 0x4c, 0x90, 0x14,
	0x8d, 0xb1, 0xd6, 0x53, 0x9e, 0xba, 0x3d, 0xe2, 0x18, 0xae, 0x4b, 0x07, 0xb6, 0xd3, 0x68, 0x9e,
	0x4c, 0x88, 0xcb, 0x85, 0x4f, 0x33, 0xe7, 0x7c, 0xb1, 0x71, 0x85, 0x83, 0x04, 0x73, 0x2c, 0x8b,
	0x59, 0x3a, 0x45, 0xd3, 0xc8, 0x58, 0xe5, 0x01, 0x7c, 0x4a, 0x39, 0x55, 0x77, 0x12, 0x61, 0x0f,
	0x22, 0x3c, 0xa8, 0xad, 0xdb, 0x4f, 0x04, 0x11, 0x15, 0x1d, 0x09, 0x94, 0xf9, 0x0c, 0xa0, 0x40,
	0xe4, 0x11, 0xa8, 0x59, 0x14, 0xee, 0xa5, 0xca, 0x3b, 0xbc, 0xb4, 0xca, 0x2f, 0xb1, 0xfc, 0x66,
	0x02, 0x6a, 0x91, 0x5d, 0x36, 0x62, 0x2c, 0xc0, 0x76, 0xc9, 0xe2, 0x52, 0xd9, 0xe2, 0xf2, 0xa6,
	0xc5, 0xab, 0x37, 0x36, 0xb6, 0x05, 0x35, 0xce, 0x2e, 0xab, 0xd9, 0xfc, 0xab, 0x02, 0xdb, 0xa5,
	0x6a, 0xee, 0xce, 0x5f, 0x7f, 0x08, 0x0f, 0xa6, 0x7e, 0xca, 0x8e, 0xdd, 0x3f, 0xe6, 0x24, 0x59,
	0xba, 0x4c, 0x42, 0x1f, 0x09, 0x33, 0x86, 0x75, 0xdd, 0x04, 0x7d, 0x1c, 0x78, 0x93, 0x37, 0x81,
	0x8f, 0x66, 0x41, 0x61, 0x05, 0x0d, 0x26, 0x53, 0xc3, 0xfa, 0x5b, 0xe2, 0x4b, 0x89, 0xd7, 0xa7,
	0x7f, 0x09, 0xf7, 0x79, 0x65, 0x7e, 0x78, 0x81, 0x4a, 0x04, 0xf3, 0x59, 0xc8, 0xe7, 0x2d, 0xf3,
	0xe2, 0xc1, 0xe6, 0x29, 0x27, 0x2a, 0x71, 0xa2, 0x46, 0xa9, 0x66, 0x1e, 0xaf, 0x27, 0x74, 0xf9,
	0x1c, 0xee, 0xa5, 0x71, 0xe0, 0x53, 0xe1, 0x0f, 0xbc, 0x3a, 0x0f, 0x29, 0x67, 0xa6, 0xe0, 0x3c,
	0xe6, 0x6e, 0x7b, 0x9d, 0x44, 0xb3, 0x74, 0x73, 0xe9, 0xe4, 0xa1, 0x32, 0xc3, 0x3d, 0x43, 0x94,
	0xf9, 0x32, 0x57, 0x9d, 0x3d, 0x7d, 0x44, 0xd7, 0x8a, 0xca, 0x72, 0x29, 0xad, 0x3f, 0x41, 0xe3,
	0x0e, 0x18, 0x12, 0xe4, 0x3b, 0xf1, 0xa8, 0x1f, 0x85, 0x7a, 0x1b, 0x94, 0x30, 0x9a, 0x12, 0x36,
	0x5d, 0x6b, 0xdb, 0x62, 0x1d, 0xda, 0xee, 0x23, 0xce, 0xdc, 0x87, 0x2a, 0xfb, 0x64, 0xc3, 0x99,
	0xf1, 0xba, 0x7d, 0x38, 0xad, 0xb7, 0x15, 0xa8, 0xdb, 0xe1, 0x74, 0x10, 0xf9, 0x21, 0x2d, 0xdb,
	0x0f, 0x97, 0x3f, 0x5b, 0xd8, 0x99, 0xf5, 0x7e, 0x2a, 0x2c, 0x68, 0x79, 0x9d, 0x4f, 0x1e, 0xa0,
	0xbc, 0xa2, 0x9f, 0x96, 0x56, 0x9e, 0x68, 0xf0, 0xd7, 0xd7, 0x5c, 0xfa, 0xc8, 0xa5, 0xf7, 0xe1,
	0x7b, 0x6c, 0x0f, 0x1a, 0x79, 0xf2, 0x54, 0xff, 0x06, 0xb6, 0x08, 0xde, 0xf2, 0x57, 0x7d, 0xd6,
	0x37, 0x29, 0x5a, 0x0e, 0xd4, 0x47, 0xc9, 0x42, 0xcc, 0x28, 0xf6, 0xa5, 0x60, 0xcd, 0xf7, 0x5c,
	0x6e, 0x9f, 0x81, 0x9a, 0x2d, 0x4c, 0xfe, 0x42, 0x15, 0xa2, 0xdb, 0xd0, 0xca, 0x94, 0x7c, 0x4d,
	0x12, 0x12, 0xe2, 0x18, 0xdc, 0x25, 0xb6, 0xf5, 0xaf, 0x8c, 0x4b, 0x24, 0x59, 0xac, 0x66, 0xe9,
	0x37, 0x80, 0x18, 0xdf, 0xef, 0x3e, 0x73, 0x46, 0x5e, 0xd4, 0x0f, 0x05, 0xf3, 0x5c, 0x41, 0x57,
	0x26, 0x1f, 0xe4, 0xf8, 0x1b, 0x07, 0x51, 0x7a, 0xe7, 0x20, 0xca, 0xb7, 0x0c, 0xe2, 0x53, 0x50,
	0x0b, 0xd3, 0x96, 0x79, 0x61, 0xe7, 0x7a, 0x4e, 0x85, 0x09, 0xbb, 0x76, 0x7e, 0xd9, 0xdb, 0x5e,
	0xc1, 0xc5, 0x79, 0x6f, 0x93, 0xfc, 0xa3, 0x55, 0x9a, 0x5b, 0x27, 0xb2, 0x03, 0x9a, 0x08, 0x9a,
	0xe4, 0xcd, 0x17, 0xc3, 0xa9, 0x16, 0xab, 0x28, 0xab, 0x63, 0xf6, 0xee, 0x3a, 0xfe, 0x1b, 0x9b,
	0xfc, 0x71, 0x07, 0x5a, 0x6b, 0x2d, 0x6a, 0x80, 0x72, 0xde, 0x1f, 0xd9, 0x8e, 0xf6, 0x09, 0xfe,
	0x31, 0xaa, 0x9d, 0xf7, 0xfa, 0xce, 0xc1, 0xcf, 0x5a, 0x85, 0xfd, 0x7c, 0xf8, 0xca, 0xb1, 0x47,
	0x9a, 0xf4, 0xf8, 0x9f, 0x0a, 0x40, 0x21, 0xa8, 0x0a, 0x5b, 0xe7, 0xfd, 0xe3, 0xfe, 0xd9, 0x8b,
	0xbe, 0xb8, 0x72, 0xda, 0x1d, 0x39, 0xf6, 0x10, 0xaf, 0xe0, 0xc1, 0xd0, 0x1e, 0x9c, 0xf4, 0x8e,
	0xba, 0x9a, 0xc4, 0x0e, 0x86, 0xbf, 0x9f, 0xf5, 0x4f, 0x5e, 0x69, 0x32, 0x8f, 0xd5, 0x75, 0x8e,
	0x9e, 0x8b, 0xaf, 0xa3, 0x41, 0x77, 0x68, 0x6b, 0x55, 0x24, 0xd7, 0xb4, 0x5f, 0x0e, 0xec, 0x61,
	0xef, 0xd4, 0xee, 0x3b, 0xdd, 0x13, 0x4d, 0x61, 0x77, 0x0e, 0xbb, 0x47, 0xc7, 0xe7, 0x03, 0xad,
	0x26, 0x82, 0x8d, 0x9c, 0x33, 0x84, 0x6e, 0xb1, 0x83, 0x17, 0x67, 0xc3, 0x63, 0xcc, 0x52, 0x37,
	0x25, 0xad, 0x72, 0x68, 0x82, 0x31, 0x89, 0x66, 0xed, 0x65, 0x34, 0xa7, 0xf3, 0x31, 0x69, 0x2f,
	0x7c, 0x4a, 0xd2, 0x54, 0xfc, 0xf9, 0x1c, 0xd7, 0xf8, 0xc7, 0xfe, 0xff, 0x01, 0x00, 0x00, 0xff,
	0xff, 0x86, 0x99, 0x6c, 0xb1, 0x95, 0x0a, 0x00, 0x00,
}
