package api

import (
	"net/http"

	"golang.org/x/net/context"
)

// AcceptUnmoderatedVods updates vods to status `recorded` if their status has been unchanged for an hour
func (s *Server) AcceptUnmoderatedVods(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	err := s.Backend.AcceptUnmoderatedVods(ctx)
	if err != nil {
		s.serveError(ctx, w, r, err)
		return
	}
	w.WriteHeader(http.StatusNoContent)
}
