package api

import (
	"fmt"
	"net/http"
	"net/http/httptest"
	"testing"

	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func performAcceptUnmoderatedVods(router *Server) *httptest.ResponseRecorder {
	w := httptest.NewRecorder()
	r, err := http.NewRequest("POST", "http://localhost/v1/vods/accept", nil)
	So(err, ShouldBeNil)

	router.ServeHTTP(w, r)
	return w
}

func TestAcceptUnmoderatedVods(t *testing.T) {
	Convey("AcceptUnmoderatedVods", t, func() {
		Convey("should fail with a 500", func() {
			router := mockServer()
			mockBackend.On("AcceptUnmoderatedVods", mock.Anything).Return(fmt.Errorf("what"))
			w := performAcceptUnmoderatedVods(router)
			So(w.Code, ShouldEqual, http.StatusInternalServerError)
		})
		Convey("should succeed with a 204", func() {
			router := mockServer()
			mockBackend.On("AcceptUnmoderatedVods", mock.Anything).Return(nil)
			w := performAcceptUnmoderatedVods(router)
			So(w.Code, ShouldEqual, http.StatusNoContent)
		})
	})
}
