package api

import (
	"net/http"
	"strconv"

	"code.justin.tv/vod/vinyl/errors"

	"golang.org/x/net/context"
)

// GetAMRsForVod fetches all the audible magic responses associated with a VOD ID.
func (s *Server) GetAMRsForVod(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	queryValues := r.URL.Query()

	vodID := queryValues.Get("vod_id")
	if vodID == "" {
		s.serveError(ctx, w, r, errors.MissingParamError{ParamName: "vod_id"})
		return
	}

	vod, err := strconv.Atoi(vodID)
	if err != nil {
		s.serveError(ctx, w, r, errors.IntegerParseError{ParamName: "vod_id", ParamValue: vodID})
		return
	}

	amrs, err := s.Backend.GetAMRsForVod(ctx, vod)
	if err != nil {
		s.serveError(ctx, w, r, err)
		return
	}

	s.serveJSON(w, r, amrs)
}
