package api

import (
	"github.com/cactus/go-statsd-client/statsd"
	. "github.com/smartystreets/goconvey/convey"

	"code.justin.tv/common/config"
	"code.justin.tv/vod/vinyl/api/mocks"
	"code.justin.tv/vod/vinyl/auth"
)

var mockBackend *mocks.Backend

func mockServer() *Server {
	stats, err := statsd.NewNoopClient()
	So(err, ShouldBeNil)
	logger := config.RollbarErrorLogger()

	mockBackend = &mocks.Backend{}
	server, err := NewServer(stats, logger, mockBackend, auth.NewFakeHandler(true))
	So(err, ShouldBeNil)
	return server
}
