package api

import (
	"encoding/json"
	"io/ioutil"
	"net/http"

	"code.justin.tv/vod/vinyl/errors"
	"code.justin.tv/vod/vinyl/models"

	"golang.org/x/net/context"
)

// CreatePastBroadcast creates a database entry in the corresponding table.
func (s *Server) CreatePastBroadcast(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	bodyBytes, err := ioutil.ReadAll(r.Body)
	if err != nil {
		s.serveError(ctx, w, r, errors.RequestBodyError{ErrorString: "Could not read body: " + err.Error()})
		return
	}

	defer func() {
		closeErr := r.Body.Close()
		if closeErr != nil {
		}
	}()

	vodMap := map[string]*models.Vod{}
	err = json.Unmarshal(bodyBytes, &vodMap)
	if err != nil {
		s.serveError(ctx, w, r, errors.RequestBodyError{ErrorString: "Invalid body: " + err.Error()})
		return
	}

	pastBroadcast, ok := vodMap["past_broadcast"]
	if !ok {
		s.serveError(ctx, w, r, errors.MissingParamError{ParamName: "past_broadcast"})
		return
	}

	if pastBroadcast.URI == "" {
		s.serveError(ctx, w, r, errors.MissingParamError{ParamName: "uri"})
		return
	}

	if pastBroadcast.BroadcastID == 0 {
		s.serveError(ctx, w, r, errors.MissingParamError{ParamName: "broadcast_id"})
		return
	}

	createdVods, err := s.Backend.CreatePastBroadcast(ctx, r, pastBroadcast)
	if err != nil {
		s.serveError(ctx, w, r, err)
		return
	}

	ret := map[string]*models.Vod{
		"past_broadcast": createdVods,
	}

	s.serveJSON(w, r, ret)

}
