package api

import (
	"io/ioutil"
	"net/http"
	"strconv"

	"goji.io/pat"

	"code.justin.tv/vod/vinyl/errors"
	"code.justin.tv/vod/vinyl/models"
	"code.justin.tv/vod/vinyl/utils"

	"golang.org/x/net/context"
)

// CreateThumbnails creates thumbnails for the given vod
func (s *Server) CreateThumbnails(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	vodIDParam := pat.Param(ctx, "vod_id")
	if vodIDParam == "" {
		s.serveError(ctx, w, r, errors.MissingParamError{ParamName: "vod_id"})
		return
	}
	vodID, err := strconv.ParseInt(vodIDParam, 10, 64)
	if err != nil {
		s.serveError(ctx, w, r, errors.IntegerParseError{ParamName: "vod_id", ParamValue: vodIDParam})
		return
	}

	bodyBytes, err := ioutil.ReadAll(r.Body)
	if err != nil {
		s.serveError(ctx, w, r, errors.RequestBodyError{ErrorString: "Could not read body: " + err.Error()})
		return
	}
	defer func() {
		closeErr := r.Body.Close()
		if closeErr != nil {
		}
	}()

	thumbnailsMap := map[string]models.Thumbnails{}
	dec := utils.JSONDecoderWithNumbers(bodyBytes)
	err = dec.Decode(&thumbnailsMap)
	if err != nil {
		s.serveError(ctx, w, r, errors.RequestBodyError{ErrorString: "Invalid body: " + err.Error()})
		return
	}

	params, ok := thumbnailsMap["thumbnails"]
	if !ok {
		s.serveError(ctx, w, r, errors.MissingParamError{ParamName: "thumbnails"})
		return
	}
	createdThumbnails, err := s.Backend.CreateThumbnails(ctx, vodID, params)
	if err != nil {
		s.serveError(ctx, w, r, err)
		return
	}

	response := map[string]models.Thumbnails{
		"thumbnails": createdThumbnails,
	}

	s.serveJSON(w, r, response)
}
