package api

import (
	"io/ioutil"
	"net/http"

	"code.justin.tv/vod/vinyl/errors"
	"code.justin.tv/vod/vinyl/models"
	"code.justin.tv/vod/vinyl/utils"

	"golang.org/x/net/context"
)

// CreateVod endpoint to create a vod
func (s *Server) CreateVod(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	bodyBytes, err := ioutil.ReadAll(r.Body)
	if err != nil {
		s.serveError(ctx, w, r, errors.RequestBodyError{ErrorString: "Could not read body: " + err.Error()})
		return
	}
	defer func() {
		closeErr := r.Body.Close()
		if closeErr != nil {
		}
	}()

	vodMap := map[string]*models.Vod{}
	dec := utils.JSONDecoderWithNumbers(bodyBytes)
	err = dec.Decode(&vodMap)
	if err != nil {
		s.serveError(ctx, w, r, errors.RequestBodyError{ErrorString: "Invalid body: " + err.Error()})
		return
	}

	vod, ok := vodMap["vod"]
	if !ok {
		s.serveError(ctx, w, r, errors.MissingParamError{ParamName: "vod"})
		return
	}
	createdVod, err := s.Backend.CreateVod(ctx, r, vod)
	if err != nil {
		s.serveError(ctx, w, r, err)
		return
	}

	ret := map[string]*models.Vod{
		"vod": createdVod,
	}

	s.serveJSON(w, r, ret)
}
