package api

import (
	"net/http"
	"strconv"

	"goji.io/pat"

	"code.justin.tv/vod/vinyl/errors"

	"golang.org/x/net/context"
)

// DeleteThumbnail deletes a thumbnail using its vodID and path as an identifier
func (s *Server) DeleteThumbnail(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	vodIDParam := pat.Param(ctx, "vod_id")
	if vodIDParam == "" {
		s.serveError(ctx, w, r, errors.MissingParamError{ParamName: "vod_id"})
		return
	}
	vodID, err := strconv.ParseInt(vodIDParam, 10, 64)
	if err != nil {
		s.serveError(ctx, w, r, errors.IntegerParseError{ParamName: "vod_id"})
		return
	}

	query := r.URL.Query()
	pathParam := query.Get("path")
	if pathParam == "" {
		s.serveError(ctx, w, r, errors.MissingParamError{ParamName: "path"})
		return
	}

	err = s.Backend.DeleteThumbnail(ctx, vodID, pathParam)
	if err != nil {
		s.serveError(ctx, w, r, err)
		return
	}

	w.WriteHeader(http.StatusNoContent)
}
