package api

import (
	"fmt"
	"net/http"
	"net/http/httptest"
	"testing"

	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func deleteThumbnailRequest(router *Server, path string) *httptest.ResponseRecorder {
	w := httptest.NewRecorder()
	r, err := http.NewRequest("DELETE", "http://0.0.0.0/v1/vods/1234/thumbnails?path="+path, nil)
	So(err, ShouldBeNil)

	router.ServeHTTP(w, r)

	return w
}

func TestDeleteThumbnail(t *testing.T) {
	Convey("DeleteThumbnail", t, func() {
		Convey("Fails when path is missing", func() {
			router := mockServer()
			w := deleteThumbnailRequest(router, "")
			So(w.Code, ShouldEqual, http.StatusBadRequest)
		})
		Convey("fails when backend error", func() {
			router := mockServer()
			path := "some_image.jpg"
			mockBackend.On("DeleteThumbnail", mock.Anything, int64(1234), path).Return(fmt.Errorf("sdfd"))
			w := deleteThumbnailRequest(router, path)
			So(w.Code, ShouldEqual, http.StatusInternalServerError)
		})
		Convey("Succeeds when given a valid path", func() {
			router := mockServer()
			path := "some_image.jpg"
			mockBackend.On("DeleteThumbnail", mock.Anything, int64(1234), path).Return(nil)
			w := deleteThumbnailRequest(router, path)
			So(w.Code, ShouldEqual, http.StatusNoContent)
		})
	})
}
