package api

import (
	"net/http"
	"strconv"

	"goji.io/pat"

	"code.justin.tv/vod/vinyl/errors"

	"golang.org/x/net/context"
)

// DeleteThumbnails deletes a vod's generated thumbnails using its vodID
func (s *Server) DeleteThumbnails(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	vodIDParam := pat.Param(ctx, "vod_id")
	if vodIDParam == "" {
		s.serveError(ctx, w, r, errors.MissingParamError{ParamName: "vod_id"})
		return
	}
	vodID, err := strconv.ParseInt(vodIDParam, 10, 64)
	if err != nil {
		s.serveError(ctx, w, r, errors.IntegerParseError{ParamName: "vod_id"})
		return
	}

	err = s.Backend.DeleteThumbnails(ctx, vodID)
	if err != nil {
		s.serveError(ctx, w, r, err)
		return
	}

	w.WriteHeader(http.StatusNoContent)
}
