package api

import (
	"fmt"
	"net/http"
	"net/http/httptest"
	"testing"

	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func deleteThumbnailsRequest(router *Server, path string) *httptest.ResponseRecorder {
	w := httptest.NewRecorder()
	r, err := http.NewRequest("DELETE", "http://0.0.0.0/v1/vods/1234/thumbnails/generated", nil)
	So(err, ShouldBeNil)

	router.ServeHTTP(w, r)

	return w
}

func TestDeleteThumbnails(t *testing.T) {
	Convey("DeleteThumbnails", t, func() {
		Convey("fails when backend error", func() {
			router := mockServer()
			path := "some_image.jpg"
			mockBackend.On("DeleteThumbnails", mock.Anything, int64(1234)).Return(fmt.Errorf("sdfd"))
			w := deleteThumbnailsRequest(router, path)
			So(w.Code, ShouldEqual, http.StatusInternalServerError)
		})
		Convey("Succeeds when given a valid path", func() {
			router := mockServer()
			path := "some_image.jpg"
			mockBackend.On("DeleteThumbnails", mock.Anything, int64(1234)).Return(nil)
			w := deleteThumbnailsRequest(router, path)
			So(w.Code, ShouldEqual, http.StatusNoContent)
		})
	})
}
