package api

import (
	"fmt"
	"net/http"
	"strconv"

	"code.justin.tv/vod/vinyl/errors"
	"goji.io/pat"
	"golang.org/x/net/context"
)

// DeleteUserVods deletes all vods belonging to the given user
func (s *Server) DeleteUserVods(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	userIDParam := pat.Param(ctx, "user_id")
	if userIDParam == "" {
		s.serveError(ctx, w, r, errors.MissingParamError{ParamName: "user_id"})
		return
	}
	userID, err := strconv.ParseInt(userIDParam, 10, 64)
	if err != nil {
		s.serveError(ctx, w, r, errors.IntegerParseError{ParamName: "user_id", ParamValue: userIDParam})
		return
	}

	go func() {
		err = s.Backend.DeleteUserVods(context.Background(), userID)
		if err != nil {
			s.ErrorLogger.Error(fmt.Errorf("failed to delete user %v's vods: %v", userID, err))
		}
	}()

	w.WriteHeader(http.StatusNoContent)
}
