package api

import (
	"net/http"
	"net/http/httptest"
	"strconv"
	"testing"

	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func performDeleteUserVodsRequest(router *Server, userID string) *httptest.ResponseRecorder {
	w := httptest.NewRecorder()
	r, err := http.NewRequest("DELETE", "http://0.0.0.0/v1/users/"+userID+"/vods", nil)
	So(err, ShouldBeNil)

	router.ServeHTTP(w, r)

	return w
}

func TestDeleteUserVods(t *testing.T) {
	Convey("DeleteUserVods", t, func() {
		Convey("Fails when user_id is missing", func() {
			router := mockServer()
			w := performDeleteUserVodsRequest(router, "")
			So(w.Code, ShouldEqual, http.StatusNotFound)
		})
		Convey("Fails when given invalid ids", func() {
			router := mockServer()
			w := performDeleteUserVodsRequest(router, "23fasef23r")
			So(w.Code, ShouldEqual, http.StatusBadRequest)
			So(w.Body.String(), ShouldContainSubstring, "user_id is not a number:")
		})
		Convey("Succeeds when given a valid vod id", func() {
			router := mockServer()
			userID := int64(1234)
			mockBackend.On("DeleteUserVods", mock.Anything, userID).Return(nil)
			w := performDeleteUserVodsRequest(router, strconv.FormatInt(userID, 10))
			So(w.Code, ShouldEqual, http.StatusNoContent)
		})
	})
}
