package api

import (
	"net/http"
	"strconv"

	"code.justin.tv/vod/vinyl/errors"
	"code.justin.tv/vod/vinyl/models"
	"goji.io/pat"
	"golang.org/x/net/context"
)

// GetUserVideoPrivacyProperties gets video privacy properties for a user
func (s *Server) GetUserVideoPrivacyProperties(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	userID := pat.Param(ctx, "user_id")
	if userID == "" {
		s.serveError(ctx, w, r, errors.MissingParamError{ParamName: "user_id"})
		return
	}

	user, err := strconv.ParseInt(userID, 10, 64)
	if err != nil {
		s.serveError(ctx, w, r, errors.IntegerParseError{ParamName: "user_id", ParamValue: userID})
		return
	}

	p, err := s.Backend.GetUserVideoPrivacyProperties(ctx, user)
	if err != nil {
		s.serveError(ctx, w, r, err)
		return
	}

	ret := map[string]*models.UserVideoPrivacyProperties{
		"properties": p,
	}
	s.serveJSON(w, r, ret)
}
