package api

import (
	"net/http"

	"code.justin.tv/vod/vinyl/errors"
	"code.justin.tv/vod/vinyl/models"

	"golang.org/x/net/context"
)

// GetVodsAggregationByID supports fetching VOD information by VOD ID
func (s *Server) GetVodsAggregationByID(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	queryValues := r.URL.Query()

	vodIDsStr := queryValues.Get("ids")
	if vodIDsStr == "" {
		s.serveError(ctx, w, r, errors.MissingParamError{ParamName: "ids"})
		return
	}

	filters, err := models.ParseFilters(queryValues)
	if err != nil {
		s.serveError(ctx, w, r, err)
		return
	}

	vodIDs, err := toInt64List(vodIDsStr)
	if err != nil {
		s.serveError(ctx, w, r, errors.IntegerParseError{ParamName: "ids", ParamValue: vodIDsStr})
		return
	}

	aggregation, err := s.Backend.GetVodsAggregationByID(ctx, vodIDs, filters)
	if err != nil {
		s.serveError(ctx, w, r, err)
		return
	}

	s.serveJSON(w, r, aggregation)
}
