package mocks

import context "golang.org/x/net/context"
import http "net/http"
import mock "github.com/stretchr/testify/mock"
import models "code.justin.tv/vod/vinyl/models"
import time "time"
import warnings "code.justin.tv/vod/vinyl/warnings"

// Backend is an autogenerated mock type for the Backend type
type Backend struct {
	mock.Mock
}

// AcceptUnmoderatedVods provides a mock function with given fields: ctx
func (_m *Backend) AcceptUnmoderatedVods(ctx context.Context) error {
	ret := _m.Called(ctx)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context) error); ok {
		r0 = rf(ctx)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// CreateAMRs provides a mock function with given fields: ctx, vodID, amrs
func (_m *Backend) CreateAMRs(ctx context.Context, vodID int64, amrs []*models.AMR) ([]*models.AMR, error) {
	ret := _m.Called(ctx, vodID, amrs)

	var r0 []*models.AMR
	if rf, ok := ret.Get(0).(func(context.Context, int64, []*models.AMR) []*models.AMR); ok {
		r0 = rf(ctx, vodID, amrs)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*models.AMR)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int64, []*models.AMR) error); ok {
		r1 = rf(ctx, vodID, amrs)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateAppeals provides a mock function with given fields: ctx, vodAppeal, trackAppeals
func (_m *Backend) CreateAppeals(ctx context.Context, vodAppeal *models.VodAppeal, trackAppeals []*models.TrackAppeal) (map[string]interface{}, error) {
	ret := _m.Called(ctx, vodAppeal, trackAppeals)

	var r0 map[string]interface{}
	if rf, ok := ret.Get(0).(func(context.Context, *models.VodAppeal, []*models.TrackAppeal) map[string]interface{}); ok {
		r0 = rf(ctx, vodAppeal, trackAppeals)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]interface{})
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *models.VodAppeal, []*models.TrackAppeal) error); ok {
		r1 = rf(ctx, vodAppeal, trackAppeals)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateHighlight provides a mock function with given fields: ctx, r, highlightInfo
func (_m *Backend) CreateHighlight(ctx context.Context, r *http.Request, highlightInfo *models.HighlightInput) (*models.Vod, error) {
	ret := _m.Called(ctx, r, highlightInfo)

	var r0 *models.Vod
	if rf, ok := ret.Get(0).(func(context.Context, *http.Request, *models.HighlightInput) *models.Vod); ok {
		r0 = rf(ctx, r, highlightInfo)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.Vod)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *http.Request, *models.HighlightInput) error); ok {
		r1 = rf(ctx, r, highlightInfo)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreatePastBroadcast provides a mock function with given fields: ctx, r, vod
func (_m *Backend) CreatePastBroadcast(ctx context.Context, r *http.Request, vod *models.Vod) (*models.Vod, error) {
	ret := _m.Called(ctx, r, vod)

	var r0 *models.Vod
	if rf, ok := ret.Get(0).(func(context.Context, *http.Request, *models.Vod) *models.Vod); ok {
		r0 = rf(ctx, r, vod)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.Vod)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *http.Request, *models.Vod) error); ok {
		r1 = rf(ctx, r, vod)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateThumbnails provides a mock function with given fields: ctx, vodID, params
func (_m *Backend) CreateThumbnails(ctx context.Context, vodID int64, params models.Thumbnails) (models.Thumbnails, error) {
	ret := _m.Called(ctx, vodID, params)

	var r0 models.Thumbnails
	if rf, ok := ret.Get(0).(func(context.Context, int64, models.Thumbnails) models.Thumbnails); ok {
		r0 = rf(ctx, vodID, params)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(models.Thumbnails)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int64, models.Thumbnails) error); ok {
		r1 = rf(ctx, vodID, params)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateVod provides a mock function with given fields: ctx, r, vod
func (_m *Backend) CreateVod(ctx context.Context, r *http.Request, vod *models.Vod) (*models.Vod, error) {
	ret := _m.Called(ctx, r, vod)

	var r0 *models.Vod
	if rf, ok := ret.Get(0).(func(context.Context, *http.Request, *models.Vod) *models.Vod); ok {
		r0 = rf(ctx, r, vod)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.Vod)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *http.Request, *models.Vod) error); ok {
		r1 = rf(ctx, r, vod)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DeleteThumbnail provides a mock function with given fields: ctx, vodID, path
func (_m *Backend) DeleteThumbnail(ctx context.Context, vodID int64, path string) error {
	ret := _m.Called(ctx, vodID, path)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, int64, string) error); ok {
		r0 = rf(ctx, vodID, path)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteThumbnails provides a mock function with given fields: ctx, vodID
func (_m *Backend) DeleteThumbnails(ctx context.Context, vodID int64) error {
	ret := _m.Called(ctx, vodID)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, int64) error); ok {
		r0 = rf(ctx, vodID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteUserVods provides a mock function with given fields: ctx, userID
func (_m *Backend) DeleteUserVods(ctx context.Context, userID int64) error {
	ret := _m.Called(ctx, userID)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, int64) error); ok {
		r0 = rf(ctx, userID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteVods provides a mock function with given fields: ctx, vodIDs
func (_m *Backend) DeleteVods(ctx context.Context, vodIDs []int64) error {
	ret := _m.Called(ctx, vodIDs)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, []int64) error); ok {
		r0 = rf(ctx, vodIDs)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteVodsInterval provides a mock function with given fields: ctx, startTime, endTime
func (_m *Backend) DeleteVodsInterval(ctx context.Context, startTime time.Time, endTime time.Time) (int, error) {
	ret := _m.Called(ctx, startTime, endTime)

	var r0 int
	if rf, ok := ret.Get(0).(func(context.Context, time.Time, time.Time) int); ok {
		r0 = rf(ctx, startTime, endTime)
	} else {
		r0 = ret.Get(0).(int)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, time.Time, time.Time) error); ok {
		r1 = rf(ctx, startTime, endTime)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Followed provides a mock function with given fields: ctx, followedIDs, broacastType, language, status, sort, limit, offset
func (_m *Backend) Followed(ctx context.Context, followedIDs []int, broacastType []string, language []string, status []string, sort string, limit int, offset int) ([]*models.Vod, error) {
	ret := _m.Called(ctx, followedIDs, broacastType, language, status, sort, limit, offset)

	var r0 []*models.Vod
	if rf, ok := ret.Get(0).(func(context.Context, []int, []string, []string, []string, string, int, int) []*models.Vod); ok {
		r0 = rf(ctx, followedIDs, broacastType, language, status, sort, limit, offset)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*models.Vod)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, []int, []string, []string, []string, string, int, int) error); ok {
		r1 = rf(ctx, followedIDs, broacastType, language, status, sort, limit, offset)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetAMRsForVod provides a mock function with given fields: ctx, vodID
func (_m *Backend) GetAMRsForVod(ctx context.Context, vodID int) ([]*models.AMR, error) {
	ret := _m.Called(ctx, vodID)

	var r0 []*models.AMR
	if rf, ok := ret.Get(0).(func(context.Context, int) []*models.AMR); ok {
		r0 = rf(ctx, vodID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*models.AMR)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int) error); ok {
		r1 = rf(ctx, vodID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUserVODProperties provides a mock function with given fields: ctx, userID
func (_m *Backend) GetUserVODProperties(ctx context.Context, userID int64) (*models.UserVODProperties, error) {
	ret := _m.Called(ctx, userID)

	var r0 *models.UserVODProperties
	if rf, ok := ret.Get(0).(func(context.Context, int64) *models.UserVODProperties); ok {
		r0 = rf(ctx, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.UserVODProperties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int64) error); ok {
		r1 = rf(ctx, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUserVideoPrivacyProperties provides a mock function with given fields: ctx, userID
func (_m *Backend) GetUserVideoPrivacyProperties(ctx context.Context, userID int64) (*models.UserVideoPrivacyProperties, error) {
	ret := _m.Called(ctx, userID)

	var r0 *models.UserVideoPrivacyProperties
	if rf, ok := ret.Get(0).(func(context.Context, int64) *models.UserVideoPrivacyProperties); ok {
		r0 = rf(ctx, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.UserVideoPrivacyProperties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int64) error); ok {
		r1 = rf(ctx, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUserVideoPrivacyPropertiesBatch provides a mock function with given fields: ctx, userIDs
func (_m *Backend) GetUserVideoPrivacyPropertiesBatch(ctx context.Context, userIDs []int64) (map[int64]models.UserVideoPrivacyProperties, error) {
	ret := _m.Called(ctx, userIDs)

	var r0 map[int64]models.UserVideoPrivacyProperties
	if rf, ok := ret.Get(0).(func(context.Context, []int64) map[int64]models.UserVideoPrivacyProperties); ok {
		r0 = rf(ctx, userIDs)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[int64]models.UserVideoPrivacyProperties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, []int64) error); ok {
		r1 = rf(ctx, userIDs)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetVodAppeals provides a mock function with given fields: ctx, priority, resolved, userInfo, vodID, limit, offset
func (_m *Backend) GetVodAppeals(ctx context.Context, priority models.NullBool, resolved models.NullBool, userInfo string, vodID models.NullInt64, limit int, offset int) ([]*models.VodAppeal, error) {
	ret := _m.Called(ctx, priority, resolved, userInfo, vodID, limit, offset)

	var r0 []*models.VodAppeal
	if rf, ok := ret.Get(0).(func(context.Context, models.NullBool, models.NullBool, string, models.NullInt64, int, int) []*models.VodAppeal); ok {
		r0 = rf(ctx, priority, resolved, userInfo, vodID, limit, offset)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*models.VodAppeal)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, models.NullBool, models.NullBool, string, models.NullInt64, int, int) error); ok {
		r1 = rf(ctx, priority, resolved, userInfo, vodID, limit, offset)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetVodAppealsCount provides a mock function with given fields: ctx, priority, resolved, userInfo, vodID
func (_m *Backend) GetVodAppealsCount(ctx context.Context, priority models.NullBool, resolved models.NullBool, userInfo string, vodID models.NullInt64) (int64, error) {
	ret := _m.Called(ctx, priority, resolved, userInfo, vodID)

	var r0 int64
	if rf, ok := ret.Get(0).(func(context.Context, models.NullBool, models.NullBool, string, models.NullInt64) int64); ok {
		r0 = rf(ctx, priority, resolved, userInfo, vodID)
	} else {
		r0 = ret.Get(0).(int64)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, models.NullBool, models.NullBool, string, models.NullInt64) error); ok {
		r1 = rf(ctx, priority, resolved, userInfo, vodID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetVodsAggregationByID provides a mock function with given fields: ctx, vodIds, filters
func (_m *Backend) GetVodsAggregationByID(ctx context.Context, vodIds []int64, filters *models.VodFilters) (*models.VodsAggregation, error) {
	ret := _m.Called(ctx, vodIds, filters)

	var r0 *models.VodsAggregation
	if rf, ok := ret.Get(0).(func(context.Context, []int64, *models.VodFilters) *models.VodsAggregation); ok {
		r0 = rf(ctx, vodIds, filters)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.VodsAggregation)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, []int64, *models.VodFilters) error); ok {
		r1 = rf(ctx, vodIds, filters)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetVodsByID provides a mock function with given fields: ctx, vodIds, appealsAndAMRs, notificationSettings, filters
func (_m *Backend) GetVodsByID(ctx context.Context, vodIds []int64, appealsAndAMRs bool, notificationSettings bool, filters *models.VodFilters) ([]*models.Vod, error) {
	ret := _m.Called(ctx, vodIds, appealsAndAMRs, notificationSettings, filters)

	var r0 []*models.Vod
	if rf, ok := ret.Get(0).(func(context.Context, []int64, bool, bool, *models.VodFilters) []*models.Vod); ok {
		r0 = rf(ctx, vodIds, appealsAndAMRs, notificationSettings, filters)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*models.Vod)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, []int64, bool, bool, *models.VodFilters) error); ok {
		r1 = rf(ctx, vodIds, appealsAndAMRs, notificationSettings, filters)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetVodsByStatus provides a mock function with given fields: ctx, status, broadcastType, startTime, endTime
func (_m *Backend) GetVodsByStatus(ctx context.Context, status string, broadcastType []string, startTime time.Time, endTime time.Time) ([]*models.Vod, error) {
	ret := _m.Called(ctx, status, broadcastType, startTime, endTime)

	var r0 []*models.Vod
	if rf, ok := ret.Get(0).(func(context.Context, string, []string, time.Time, time.Time) []*models.Vod); ok {
		r0 = rf(ctx, status, broadcastType, startTime, endTime)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*models.Vod)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, []string, time.Time, time.Time) error); ok {
		r1 = rf(ctx, status, broadcastType, startTime, endTime)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetVodsByUser provides a mock function with given fields: ctx, userID, broadcastType, language, status, appealsAndAMRs, notificationSettings, filters, sort, limit, offset
func (_m *Backend) GetVodsByUser(ctx context.Context, userID int, broadcastType []string, language []string, status []string, appealsAndAMRs bool, notificationSettings bool, filters *models.VodFilters, sort string, limit int, offset int) ([]*models.Vod, error) {
	ret := _m.Called(ctx, userID, broadcastType, language, status, appealsAndAMRs, notificationSettings, filters, sort, limit, offset)

	var r0 []*models.Vod
	if rf, ok := ret.Get(0).(func(context.Context, int, []string, []string, []string, bool, bool, *models.VodFilters, string, int, int) []*models.Vod); ok {
		r0 = rf(ctx, userID, broadcastType, language, status, appealsAndAMRs, notificationSettings, filters, sort, limit, offset)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*models.Vod)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int, []string, []string, []string, bool, bool, *models.VodFilters, string, int, int) error); ok {
		r1 = rf(ctx, userID, broadcastType, language, status, appealsAndAMRs, notificationSettings, filters, sort, limit, offset)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetVodsCountByUser provides a mock function with given fields: ctx, userID, broadcastType, language, status, filters
func (_m *Backend) GetVodsCountByUser(ctx context.Context, userID int, broadcastType []string, language []string, status []string, filters *models.VodFilters) (int64, error) {
	ret := _m.Called(ctx, userID, broadcastType, language, status, filters)

	var r0 int64
	if rf, ok := ret.Get(0).(func(context.Context, int, []string, []string, []string, *models.VodFilters) int64); ok {
		r0 = rf(ctx, userID, broadcastType, language, status, filters)
	} else {
		r0 = ret.Get(0).(int64)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int, []string, []string, []string, *models.VodFilters) error); ok {
		r1 = rf(ctx, userID, broadcastType, language, status, filters)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Moderation provides a mock function with given fields: ctx, vodID, statusCode
func (_m *Backend) Moderation(ctx context.Context, vodID int64, statusCode int) error {
	ret := _m.Called(ctx, vodID, statusCode)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, int64, int) error); ok {
		r0 = rf(ctx, vodID, statusCode)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// OwnerForRechat provides a mock function with given fields: ctx, vodID
func (_m *Backend) OwnerForRechat(ctx context.Context, vodID int64) (*models.VodOwner, error) {
	ret := _m.Called(ctx, vodID)

	var r0 *models.VodOwner
	if rf, ok := ret.Get(0).(func(context.Context, int64) *models.VodOwner); ok {
		r0 = rf(ctx, vodID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.VodOwner)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int64) error); ok {
		r1 = rf(ctx, vodID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// PublishScheduledVods provides a mock function with given fields: ctx
func (_m *Backend) PublishScheduledVods(ctx context.Context) error {
	ret := _m.Called(ctx)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context) error); ok {
		r0 = rf(ctx)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Rebroadcast provides a mock function with given fields: ctx, vodIDs, ownerID, streamKey
func (_m *Backend) Rebroadcast(ctx context.Context, vodIDs []int64, ownerID int64, streamKey string) error {
	ret := _m.Called(ctx, vodIDs, ownerID, streamKey)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, []int64, int64, string) error); ok {
		r0 = rf(ctx, vodIDs, ownerID, streamKey)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Related provides a mock function with given fields: ctx, userID, vodID
func (_m *Backend) Related(ctx context.Context, userID int, vodID int) ([]*models.Vod, error) {
	ret := _m.Called(ctx, userID, vodID)

	var r0 []*models.Vod
	if rf, ok := ret.Get(0).(func(context.Context, int, int) []*models.Vod); ok {
		r0 = rf(ctx, userID, vodID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*models.Vod)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int, int) error); ok {
		r1 = rf(ctx, userID, vodID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ResolveTrackAppeal provides a mock function with given fields: ctx, appealID, approve
func (_m *Backend) ResolveTrackAppeal(ctx context.Context, appealID int64, approve bool) error {
	ret := _m.Called(ctx, appealID, approve)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, int64, bool) error); ok {
		r0 = rf(ctx, appealID, approve)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ResolveVodAppeal provides a mock function with given fields: ctx, appealID
func (_m *Backend) ResolveVodAppeal(ctx context.Context, appealID int64) (warnings.Warning, error) {
	ret := _m.Called(ctx, appealID)

	var r0 warnings.Warning
	if rf, ok := ret.Get(0).(func(context.Context, int64) warnings.Warning); ok {
		r0 = rf(ctx, appealID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(warnings.Warning)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int64) error); ok {
		r1 = rf(ctx, appealID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SetUserVODProperties provides a mock function with given fields: ctx, userID, u
func (_m *Backend) SetUserVODProperties(ctx context.Context, userID int64, u *models.UserVODPropertiesInput) (*models.UserVODProperties, error) {
	ret := _m.Called(ctx, userID, u)

	var r0 *models.UserVODProperties
	if rf, ok := ret.Get(0).(func(context.Context, int64, *models.UserVODPropertiesInput) *models.UserVODProperties); ok {
		r0 = rf(ctx, userID, u)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.UserVODProperties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int64, *models.UserVODPropertiesInput) error); ok {
		r1 = rf(ctx, userID, u)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SetUserVideoPrivacyProperties provides a mock function with given fields: ctx, userID, u
func (_m *Backend) SetUserVideoPrivacyProperties(ctx context.Context, userID int64, u *models.UserVideoPrivacyPropertiesInput) (*models.UserVideoPrivacyProperties, error) {
	ret := _m.Called(ctx, userID, u)

	var r0 *models.UserVideoPrivacyProperties
	if rf, ok := ret.Get(0).(func(context.Context, int64, *models.UserVideoPrivacyPropertiesInput) *models.UserVideoPrivacyProperties); ok {
		r0 = rf(ctx, userID, u)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.UserVideoPrivacyProperties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int64, *models.UserVideoPrivacyPropertiesInput) error); ok {
		r1 = rf(ctx, userID, u)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SetViewcounts provides a mock function with given fields: ctx, counts
func (_m *Backend) SetViewcounts(ctx context.Context, counts map[int]int64) error {
	ret := _m.Called(ctx, counts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, map[int]int64) error); ok {
		r0 = rf(ctx, counts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Top provides a mock function with given fields: ctx, broadcastType, language, game, period, sort, limit, offset
func (_m *Backend) Top(ctx context.Context, broadcastType []string, language []string, game string, period string, sort string, limit int, offset int) ([]*models.Vod, error) {
	ret := _m.Called(ctx, broadcastType, language, game, period, sort, limit, offset)

	var r0 []*models.Vod
	if rf, ok := ret.Get(0).(func(context.Context, []string, []string, string, string, string, int, int) []*models.Vod); ok {
		r0 = rf(ctx, broadcastType, language, game, period, sort, limit, offset)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*models.Vod)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, []string, []string, string, string, string, int, int) error); ok {
		r1 = rf(ctx, broadcastType, language, game, period, sort, limit, offset)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateAMR provides a mock function with given fields: ctx, amrID, updateFields
func (_m *Backend) UpdateAMR(ctx context.Context, amrID int, updateFields map[string]interface{}) (*models.AMR, error) {
	ret := _m.Called(ctx, amrID, updateFields)

	var r0 *models.AMR
	if rf, ok := ret.Get(0).(func(context.Context, int, map[string]interface{}) *models.AMR); ok {
		r0 = rf(ctx, amrID, updateFields)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.AMR)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int, map[string]interface{}) error); ok {
		r1 = rf(ctx, amrID, updateFields)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateVod provides a mock function with given fields: ctx, r, vodID, u
func (_m *Backend) UpdateVod(ctx context.Context, r *http.Request, vodID int64, u models.VodUpdateInput) (*models.Vod, error) {
	ret := _m.Called(ctx, r, vodID, u)

	var r0 *models.Vod
	if rf, ok := ret.Get(0).(func(context.Context, *http.Request, int64, models.VodUpdateInput) *models.Vod); ok {
		r0 = rf(ctx, r, vodID, u)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.Vod)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *http.Request, int64, models.VodUpdateInput) error); ok {
		r1 = rf(ctx, r, vodID, u)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// YoutubeExport provides a mock function with given fields: ctx, exportInput
func (_m *Backend) YoutubeExport(ctx context.Context, exportInput *models.YoutubeExportInput) error {
	ret := _m.Called(ctx, exportInput)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, *models.YoutubeExportInput) error); ok {
		r0 = rf(ctx, exportInput)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}
