package api

import (
	"net/http"
	"strconv"

	"code.justin.tv/vod/vinyl/errors"
	"goji.io/pat"
	"golang.org/x/net/context"
)

//Moderation updates the VOD as published or deleted according to status
func (s *Server) Moderation(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	vodIDStr := pat.Param(ctx, "vod_id")
	if vodIDStr == "" {
		s.serveError(ctx, w, r, errors.MissingParamError{ParamName: "vod_id"})
		return
	}
	var vodID int64
	vodID, err := strconv.ParseInt(vodIDStr, 10, 64)
	if err != nil {
		s.serveError(ctx, w, r, errors.IntegerParseError{ParamName: "vod_id", ParamValue: vodIDStr})
		return
	}

	queryValues := r.URL.Query()
	returnStatus := queryValues.Get("status")
	if returnStatus == "" {
		s.serveError(ctx, w, r, errors.MissingParamError{ParamName: "status"})
		return
	}

	var status int
	status, err = strconv.Atoi(returnStatus)
	if err != nil {
		s.serveError(ctx, w, r, errors.IntegerParseError{ParamName: "status", ParamValue: returnStatus})
		return
	}
	if status < 1 || status > 4 {
		s.serveError(ctx, w, r, errors.InvalidValueError{ParamName: "status", Value: returnStatus})
		return
	}

	err = s.Backend.Moderation(ctx, vodID, status)
	if err != nil {
		s.serveError(ctx, w, r, err)
		return
	}

	w.WriteHeader(http.StatusNoContent)
}
