package api

import (
	"net/http"
	"strconv"

	"goji.io/pat"

	"code.justin.tv/vod/vinyl/errors"

	"golang.org/x/net/context"
)

// OwnerForRechat get VOD info to be only used by rechat
func (s *Server) OwnerForRechat(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	// Validate vod_id
	vodIDStr := pat.Param(ctx, "vod_id")
	if vodIDStr == "" {
		s.serveError(ctx, w, r, errors.MissingParamError{ParamName: "vod_id"})
		return
	}
	var vodID int64
	vodID, err := strconv.ParseInt(vodIDStr, 10, 64)
	if err != nil {
		s.serveError(ctx, w, r, errors.IntegerParseError{ParamName: "vod_id", ParamValue: vodIDStr})
		return
	}

	// Load Owner from backend
	owner, err := s.Backend.OwnerForRechat(ctx, vodID)
	if err != nil {
		s.serveError(ctx, w, r, err)
		return
	}

	// Respond JSON
	s.serveJSON(w, r, owner)
}
