package api

import (
	"strconv"

	"code.justin.tv/vod/vinyl/errors"
)

// The default limits for retreiving entries and pagination.
const (
	DefaultLimit = 10
	MaxLimit     = 100
)

func pagination(limitQueryValue, offsetQueryValue string, maxOffset int) (limit int, offset int, err error) {
	if limitQueryValue == "" {
		limitQueryValue = "0"
	}
	limit, err = strconv.Atoi(limitQueryValue)
	if err != nil {
		return 0, 0, errors.IntegerParseError{ParamName: "limit", ParamValue: limitQueryValue}
	}
	if limit < 0 || limit > MaxLimit {
		return 0, 0, errors.InvalidValueError{ParamName: "limit", Value: limit}
	}
	if limit == 0 {
		limit = DefaultLimit
	}

	if offsetQueryValue == "" {
		offsetQueryValue = "0"
	}
	offset, err = strconv.Atoi(offsetQueryValue)
	if err != nil {
		return 0, 0, errors.IntegerParseError{ParamName: "offset", ParamValue: offsetQueryValue}
	}
	if offset < 0 || (maxOffset > 0 && offset > maxOffset) {
		// TODO: maybe use cursors to speed this query up and avoid needing this check.
		// But before we can do that we must figure out how to properly handle keying off view counts
		return 0, 0, errors.InvalidValueError{ParamName: "offset", Value: offset}
	}
	return limit, offset, nil
}
