package api

import (
	"net/http"

	"golang.org/x/net/context"
)

// PublishScheduledVods updates vods to viewable `published` if their viewable_at is in the past
func (s *Server) PublishScheduledVods(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	err := s.Backend.PublishScheduledVods(ctx)
	if err != nil {
		s.serveError(ctx, w, r, err)
		return
	}
	w.WriteHeader(http.StatusOK)
}
