package api

import (
	"net/http"
	"strconv"

	"code.justin.tv/common/goauthorization"
	"code.justin.tv/vod/vinyl/errors"

	"golang.org/x/net/context"
)

// Rebroadcast rebroadcasts a list of vods for a vod owner
func (s *Server) Rebroadcast(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	queryValues := r.URL.Query()
	vodIDsStr := queryValues.Get("ids")
	vodIDs, err := toInt64List(vodIDsStr)
	if err != nil {
		s.serveError(ctx, w, r, errors.IntegerParseError{ParamName: "ids", ParamValue: vodIDsStr})
		return
	}

	ownerIDStr := queryValues.Get("owner_id")
	ownerID, err := strconv.ParseInt(ownerIDStr, 10, 64)
	if err != nil {
		s.serveError(ctx, w, r, errors.InvalidValueError{ParamName: "owner_id", Value: ownerIDStr})
		return
	}

	err = s.authHandler.AuthorizeJWT(r, goauthorization.CapabilityClaims{
		"rebroadcast_vods": goauthorization.CapabilityClaim{
			"channel_id": ownerIDStr,
		},
	})
	if err != nil {
		s.serveError(ctx, w, r, errors.UnauthorizedError{})
		return
	}

	err = s.Backend.Rebroadcast(ctx, vodIDs, ownerID, queryValues.Get("stream_key"))
	if err != nil {
		s.serveError(ctx, w, r, err)
		return
	}

	w.WriteHeader(http.StatusNoContent)
}
