package api

import (
	"net/http"
	"strconv"

	"code.justin.tv/vod/vinyl/errors"

	"golang.org/x/net/context"
)

// Related returns a set of VODs related to a vod.
func (s *Server) Related(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	queryValues := r.URL.Query()
	userID := queryValues.Get("user_id")
	if userID == "" {
		s.serveError(ctx, w, r, errors.MissingParamError{ParamName: "user_id"})
		return
	}
	user, err := strconv.Atoi(userID)
	if err != nil {
		s.serveError(ctx, w, r, errors.IntegerParseError{ParamName: "user_id", ParamValue: userID})
		return
	}

	vodID := queryValues.Get("vod_id")
	var vod int
	if vodID != "" {
		vod, err = strconv.Atoi(vodID)
		if err != nil {
			s.serveError(ctx, w, r, errors.IntegerParseError{ParamName: "vod_id", ParamValue: vodID})
			return
		}
	}

	vods, err := s.Backend.Related(ctx, user, vod)
	if err != nil {
		s.serveError(ctx, w, r, err)
		return
	}

	s.serveJSON(w, r, vods)
}
