package api

import (
	"net/http"
	"strconv"

	"code.justin.tv/vod/vinyl/errors"

	"goji.io/pat"
	"golang.org/x/net/context"
)

// ResolveTrackAppeal marks track appeals as resolved and unmutes the corresponding audible magic response if it is approved.
func (s *Server) ResolveTrackAppeal(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	trackAppealID := pat.Param(ctx, "appeal_id")
	if trackAppealID == "" {
		s.serveError(ctx, w, r, errors.MissingParamError{ParamName: "appeal_id"})
		return
	}

	appealID, err := strconv.Atoi(trackAppealID)
	if err != nil {
		s.serveError(ctx, w, r, errors.IntegerParseError{ParamName: "appeal_id", ParamValue: trackAppealID})
		return
	}

	queryValues := r.URL.Query()
	action := queryValues.Get("action")
	if action != "accept" && action != "reject" {
		s.serveError(ctx, w, r, errors.InvalidValueError{ParamName: "action", Value: action})
		return
	}

	approve := action == "accept"

	err = s.Backend.ResolveTrackAppeal(ctx, int64(appealID), approve)
	if err != nil {
		s.serveError(ctx, w, r, err)
		return
	}

	w.WriteHeader(http.StatusNoContent)
}
