package api

import (
	"net/http"
	"strconv"

	"code.justin.tv/vod/vinyl/errors"

	"goji.io/pat"
	"golang.org/x/net/context"
)

// ResolveVodAppeal marks vods appeals as resolved and sends a corresponding email to the user.
func (s *Server) ResolveVodAppeal(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	trackAppealID := pat.Param(ctx, "appeal_id")
	if trackAppealID == "" {
		s.serveError(ctx, w, r, errors.MissingParamError{ParamName: "appeal_id"})
		return
	}

	appealID, err := strconv.ParseInt(trackAppealID, 10, 64)
	if err != nil {
		s.serveError(ctx, w, r, errors.IntegerParseError{ParamName: "appeal_id", ParamValue: trackAppealID})
		return
	}

	emailDeliveryWarning, err := s.Backend.ResolveVodAppeal(ctx, appealID)
	if err != nil {
		s.serveError(ctx, w, r, err)
		return
	}
	if emailDeliveryWarning != nil {
		warningResp := map[string]interface{}{
			"warning": "Vod appeal was resolved. " + emailDeliveryWarning.Message(),
		}
		s.serveJSON(w, r, warningResp)
		return
	}

	w.WriteHeader(http.StatusNoContent)
}
