package api

import (
	"fmt"
	"net/http"
	"net/http/httptest"
	"testing"

	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func performResolveVodAppealTest(router *Server, appealID interface{}) *httptest.ResponseRecorder {
	w := httptest.NewRecorder()
	r, err := http.NewRequest("POST", fmt.Sprintf("http://localhost/v1/vod_appeal/%v", appealID), nil)
	So(err, ShouldBeNil)

	router.ServeHTTP(w, r)
	return w
}

func TestResolveVodAppeal(t *testing.T) {
	Convey("When resolving vod appeals", t, func() {
		Convey("request should fail without an integer appeal ID", func() {
			router := mockServer()
			w := performResolveVodAppealTest(router, "cow")
			So(w.Code, ShouldEqual, http.StatusBadRequest)
			So(w.Body.String(), ShouldContainSubstring, "appeal_id is not a number")
		})

		Convey(" a valid appeal ID", func() {
			router := mockServer()
			mockBackend.On("ResolveVodAppeal", mock.Anything, int64(123)).Return(nil, fmt.Errorf("what"))
			w := performResolveVodAppealTest(router, 123)
			So(w.Code, ShouldEqual, http.StatusInternalServerError)
		})

		Convey("request should succeed with a valid appeal ID", func() {
			router := mockServer()
			mockBackend.On("ResolveVodAppeal", mock.Anything, int64(123)).Return(nil, nil)
			w := performResolveVodAppealTest(router, 123)
			So(w.Code, ShouldEqual, http.StatusNoContent)
		})
	})
}
