package api

import (
	"io/ioutil"
	"net/http"
	"strconv"

	"goji.io/pat"

	"code.justin.tv/vod/vinyl/errors"
	"code.justin.tv/vod/vinyl/models"
	"code.justin.tv/vod/vinyl/utils"

	"golang.org/x/net/context"
)

// UpdateVod updates a vod.
func (s *Server) UpdateVod(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	vod := pat.Param(ctx, "vod_id")
	if vod == "" {
		s.serveError(ctx, w, r, errors.MissingParamError{ParamName: "vod_id"})
		return
	}
	vodID, err := strconv.ParseInt(vod, 10, 64)
	if err != nil {
		s.serveError(ctx, w, r, errors.IntegerParseError{ParamName: "vod_id", ParamValue: vod})
		return
	}

	bodyBytes, err := ioutil.ReadAll(r.Body)
	if err != nil {
		s.serveError(ctx, w, r, errors.RequestBodyError{ErrorString: "Could not read body: " + err.Error()})
		return
	}

	defer func() {
		closeErr := r.Body.Close()
		if closeErr != nil {
		}
	}()

	err = AllowBodyFields(bodyBytes, models.VodUpdateFields)
	if err != nil {
		s.serveError(ctx, w, r, err)
		return
	}

	u := models.VodUpdateInput{}
	dec := utils.JSONDecoderWithNumbers(bodyBytes)
	err = dec.Decode(&u)
	if err != nil {
		s.serveError(ctx, w, r, errors.RequestBodyError{ErrorString: "Invalid body: " + err.Error()})
		return
	}

	for k := range u.ShowFormats {
		u.ShowFormats[k] = utils.NormalizeJSONMap(u.ShowFormats[k])
	}

	// TODO: Why does this endpoint not take *models.VodUpdateInput{} ?
	updatedVod, err := s.Backend.UpdateVod(ctx, r, vodID, u)
	if err != nil {
		s.serveError(ctx, w, r, err)
		return
	}

	ret := map[string]*models.Vod{
		"vod": updatedVod,
	}

	s.serveJSON(w, r, ret)
}
