package api

import (
	"encoding/json"
	"io/ioutil"
	"net/http"

	"code.justin.tv/common/goauthorization"
	"code.justin.tv/vod/vinyl/errors"
	"code.justin.tv/vod/vinyl/models"

	"golang.org/x/net/context"
)

// YoutubeExport exports a vod to youtube.
func (s *Server) YoutubeExport(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	bodyBytes, err := ioutil.ReadAll(r.Body)
	if err != nil {
		s.serveError(ctx, w, r, errors.RequestBodyError{ErrorString: "Could not read body: " + err.Error()})
		return
	}

	defer func() {
		closeErr := r.Body.Close()
		if closeErr != nil {
		}
	}()

	u := &models.YoutubeExportInput{}
	err = json.Unmarshal(bodyBytes, &u)
	if err != nil {
		s.serveError(ctx, w, r, errors.RequestBodyError{ErrorString: "Invalid body: " + err.Error()})
		return
	}

	err = s.authHandler.AuthorizeJWT(r, goauthorization.CapabilityClaims{
		"export_vod": goauthorization.CapabilityClaim{
			"vod_id": u.VodID,
		},
	})
	if err != nil {
		s.serveError(ctx, w, r, errors.UnauthorizedError{})
		return
	}

	err = s.Backend.YoutubeExport(ctx, u)
	if err != nil {
		s.serveError(ctx, w, r, err)
		return
	}

	w.WriteHeader(http.StatusNoContent)
}
