package backend

import (
	"code.justin.tv/vod/vinyl/models"
	"golang.org/x/net/context"
)

// AcceptUnmoderatedVods updates the status of Vods in moderation review for over an hour to `recorded`
func (b *Backend) AcceptUnmoderatedVods(ctx context.Context) error {
	dbVods, err := b.Reader.GetStaleUnmoderatedVods(ctx)
	if err != nil {
		return err
	}

	if len(dbVods) == 0 {
		return nil
	}

	u := models.VodUpdateInput{
		Status: models.NullString{String: models.StatusRecorded, Valid: true},
	}

	for _, dbVod := range dbVods {
		vod, err := dbVod.AsVinylVod()
		if err != nil {
			return err
		}

		_, err = b.UpdateVod(ctx, nil, vod.ID, u)
		if err != nil {
			return err
		}
	}

	return nil
}
