package backend

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vinyl/models"
)

// GetAMRsForVod fetches a set of audible magic responses for a particular vod.
func (b *Backend) GetAMRsForVod(ctx context.Context, vodID int) ([]*models.AMR, error) {
	amrs, err := b.Reader.GetAMRs(ctx, vodID)
	if err != nil {
		return nil, err
	}
	ret, err := convertAMRs(amrs)
	if err != nil {
		return nil, err
	}
	return ret, nil
}
