package backend

import (
	"time"

	"golang.org/x/net/context"

	"code.justin.tv/vod/vinyl/models"
)

// CreateAMRs calls the appropriate writers to store audible magic response data.
func (b *Backend) CreateAMRs(ctx context.Context, vodID int64, amrs []*models.AMR) ([]*models.AMR, error) {
	for _, amr := range amrs {
		amr.CreatedAt = time.Now().UTC().Round(time.Second)
		amr.UpdatedAt = time.Now().UTC().Round(time.Second)
	}

	ids, err := b.Writer.CreateAMRs(ctx, vodID, amrs, false)
	if err != nil {
		return nil, err
	}

	for i, id := range ids {
		amrs[i].AudibleMagicResponseID = id
		go b.trackAMRCreateSuccess(amrs[i])
	}

	return amrs, nil
}

func (b *Backend) trackAMRCreateSuccess(amr *models.AMR) {
	attr := amr.SpadeAttributes()
	b.SpadeClient.SendEvent("vod_mute", attr)
}
