package backend

import (
	"net/http"

	"code.justin.tv/vod/vinyl/models"
	"golang.org/x/net/context"
)

// CreateHighlight calls the appropriate writers to store highlight data.
func (b *Backend) CreateHighlight(ctx context.Context, r *http.Request, highlightInfo *models.HighlightInput) (*models.Vod, error) {
	// We don't merely return the IDs of the created broadcasts due to the thumbnails field.
	// It is passed in as a serialized string, but Vinyl needs to return it as a parsed map.
	createdHighlight, err := b.Writer.CreateHighlight(ctx, highlightInfo, false)
	if err != nil {
		return nil, err
	}

	res, err := createdHighlight.AsVinylVod()
	if err != nil {
		return nil, err
	}

	err = b.Usher.CreateHighlight(res.SourceArchiveID.Int64, res.ID)
	if err != nil {
		// Do not worry about if this fails. There exists a highlight refiring job that gets
		// ran in case this call does not make it.
	}

	go b.SearchIndexerAdd(context.Background(), res)
	go b.trackVodInit(res, r)
	return res, nil
}
