package backend

import (
	"net/http"
	"time"

	"code.justin.tv/vod/vinyl/models"
	"golang.org/x/net/context"
)

// CreatePastBroadcast calls the appropriate writers to store past broadcast data.
func (b *Backend) CreatePastBroadcast(ctx context.Context, r *http.Request, vod *models.Vod) (*models.Vod, error) {
	vod.CreatedAt = time.Now().UTC().Round(time.Second)
	vod.UpdatedAt = time.Now().UTC().Round(time.Second)
	vod.BroadcastType = "archive"
	vod.StartedOn = vod.StartedOn.UTC().Round(time.Second)
	vod.Views = 0
	vod.Offset = 0
	vod.CreatedBy = models.NullInt64{Valid: true, Int64: int64(vod.OwnerID)}
	vod.PublishedAt = models.NullTime{Time: &vod.CreatedAt, Present: true}

	createdVods, err := b.Writer.CreatePastBroadcast(ctx, vod, false)
	if err != nil {
		return nil, err
	}

	res, err := createdVods.AsVinylVod()
	if err != nil {
		return nil, err
	}
	go b.trackVodInit(res, r)

	return res, nil
}
