package backend

import "golang.org/x/net/context"

// DeleteThumbnail deletes a thumbnail using vodID and path
func (b *Backend) DeleteThumbnail(ctx context.Context, vodID int64, path string) error {
	err := b.Writer.DeleteThumbnail(ctx, vodID, path)
	if err != nil {
		return err
	}

	go b.trackThumbnailDelete(vodID, path)

	return b.UpdateVodSearchIndexer(ctx, vodID)
}

func (b *Backend) trackThumbnailDelete(vodID int64, path string) {
	attributes := map[string]interface{}{}
	attributes["vod_id"] = vodID
	attributes["path"] = path
	b.SpadeClient.SendEvent("vod_thumbnail_delete", attributes)
}
