package backend

import "golang.org/x/net/context"

// DeleteUserVods deletes all the given user's vods
func (b *Backend) DeleteUserVods(ctx context.Context, userID int64) error {
	vodIDs, err := b.Reader.GetVodIDsByUser(ctx, userID)
	if err != nil {
		return err
	}
	i := 0
	j := 100
	for i < len(vodIDs) {
		if j > len(vodIDs) {
			j = len(vodIDs)
		}

		batch := vodIDs[i:j]
		if err = b.Usher.DeleteVods(batch); err != nil {
			return err
		}
		go b.SearchIndexerRemoveBatch(context.Background(), batch)

		i += 100
		j += 100
	}

	return nil
}
