package backend

import (
	"code.justin.tv/vod/vinyl/models"
	"golang.org/x/net/context"
)

// DeleteVods calls the appropriate writers to remove vod information.
func (b *Backend) DeleteVods(ctx context.Context, vodIDs []int64) error {
	vods, err := b.GetVodsByID(ctx, vodIDs, false, false, models.VodFilterNone())
	if err != nil { // if retrieving view counts errors, continue operation but skip tracking
		vods = []*models.Vod{}
	}

	err = b.Writer.DeleteVods(ctx, vodIDs)
	if err != nil {
		return err
	}

	go func() {
		for _, vod := range vods {
			b.trackVodDeleteSuccess(vod)
		}
	}()

	return nil
}

func (b *Backend) trackVodDeleteSuccess(vod *models.Vod) {
	attributes := vod.SpadeAttributes(nil)
	attributes["views_count"] = vod.Views
	b.SpadeClient.SendEvent("vod_hard_delete", attributes)
}
