package backend

import (
	"time"

	"golang.org/x/net/context"
)

// DeleteVodsInterval takes a time interval and deletes all vods that need to be deleted in that interval
func (b *Backend) DeleteVodsInterval(ctx context.Context, startTime time.Time, endTime time.Time) (int, error) {
	vodIDs, err := b.Reader.GetIntervalVodIDsToDelete(ctx, startTime, endTime)
	if err != nil {
		return 0, err
	}

	i := 0
	j := 100
	for i < len(vodIDs) {
		if j > len(vodIDs) {
			j = len(vodIDs)
		}
		batchIDs := vodIDs[i:j]
		err := b.Usher.DeleteVods(batchIDs)
		if err != nil {
			return 0, err
		}
		go b.SearchIndexerRemoveBatch(context.Background(), batchIDs)
		i += 100
		j += 100
	}
	return len(vodIDs), nil
}
