package backend

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vinyl/models"
)

// Followed calls the appropriate readers to fetch information about vods from a set of followed user IDs.
func (b *Backend) Followed(ctx context.Context, followedIDs []int, broadcastType, language, status []string, sort string, limit, offset int) ([]*models.Vod, error) {

	dbVods, err := b.Reader.FollowedVods(ctx, followedIDs, broadcastType, language, status, sort, limit, offset)
	if err != nil {
		return nil, err
	}

	res, err := convertVods(dbVods)
	if err != nil {
		return nil, err
	}

	return res, nil
}
