package backend

import (
	"code.justin.tv/vod/vinyl/models"

	"golang.org/x/net/context"
)

// GetUserVideoPrivacyPropertiesBatch calls the appropriate reader to fetch user video privacy properties.
func (b *Backend) GetUserVideoPrivacyPropertiesBatch(ctx context.Context, userIDs []int64) (map[int64]models.UserVideoPrivacyProperties, error) {
	p, err := b.Reader.GetUserVideoPrivacyPropertiesBatch(ctx, userIDs)
	if err != nil {
		return nil, err
	}
	return p, nil
}
