package backend

import (
	"code.justin.tv/vod/vinyl/models"

	"golang.org/x/net/context"
)

// GetUserVODProperties calls the appropriate reader to fetch user video privacy properties.
func (b *Backend) GetUserVODProperties(ctx context.Context, userID int64) (*models.UserVODProperties, error) {
	p, err := b.Reader.GetUserVODProperties(ctx, userID)
	if err != nil {
		return nil, err
	}
	res, err := p.AsVinylUserVODProperties()
	if err != nil {
		return nil, err
	}
	return res, nil
}
