package backend

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vinyl/models"
)

// GetVodAppeals takes in params, limit, offset and pass them to the readers of the backend
func (b *Backend) GetVodAppeals(ctx context.Context, priority, resolved models.NullBool, userInfo string, vodID models.NullInt64, limit, offset int) ([]*models.VodAppeal, error) {
	empty := []*models.VodAppeal{}

	dbVodAppeals, err := b.Reader.GetVodAppeals(ctx, priority, resolved, userInfo, vodID, limit, offset)
	if err != nil {
		return empty, err
	}

	vodAppeals, err := convertVodAppeals(dbVodAppeals)
	if err != nil {
		return empty, err
	}
	return vodAppeals, nil
}
