package backend

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vinyl/errors"
	"code.justin.tv/vod/vinyl/models"
)

func (b *Backend) includeVodNotificationSettings(ctx context.Context, res models.VodList) error {
	if len(res) == 0 {
		return nil
	}

	vodIDs := make([]int64, len(res))
	for index, vod := range res {
		vodIDs[index] = vod.ID
	}

	notificationSettingsList, err := b.getVodNotificationSettings(ctx, vodIDs)
	if err != nil {
		return err
	}

	idVodsMap := map[int64]*models.Vod{}
	for _, vod := range res {
		idVodsMap[vod.ID] = vod
	}

	for _, notificationSettings := range notificationSettingsList {
		vodID := notificationSettings.VodID
		vod := idVodsMap[vodID]
		err = b.addNotificationSettingsToMap(notificationSettings, &vod.NotificationSettings)
		if err != nil {
			return err
		}
	}

	return nil
}

func (b *Backend) addNotificationSettingsToMap(notificationSettings *models.VodNotificationSettings, notificationSettingsMap *models.VodNotificationSettingsMap) error {
	switch notificationSettings.Type {
	case "email":
		notificationSettingsMap.Email = notificationSettings
	case "channel_feed":
		notificationSettingsMap.ChannelFeed = notificationSettings
	default:
		return &errors.NotificationTypeInvalidError{Type: notificationSettings.Type}
	}
	return nil
}

func (b *Backend) getVodNotificationSettings(ctx context.Context, vodIDs []int64) (models.VodNotificationSettingsList, error) {
	var notificationSettingsList models.VodNotificationSettingsList

	dbNotificationSettingsList, err := b.Reader.GetVodNotificationSettingsByVodIDs(ctx, vodIDs)
	if err != nil {
		return notificationSettingsList, err
	}

	notificationSettingsList, err = convertVodNotificationSettings(dbNotificationSettingsList)
	return notificationSettingsList, err
}
